<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:tizen="http://tizen.org/ns/widgets"
                              xmlns:widget="http://www.w3.org/ns/widgets"
                              xmlns:manifest="http://tizen.org/ns/packages">
    <xsl:output encoding="UTF-8" indent="yes" method="xml" />

    <!-- web manifest name space -->
    <xsl:param name="widget" select="'http://www.w3.org/ns/widgets'"/>
    <xsl:param name="tizen" select="'http://tizen.org/ns/packages'"/>

    <!-- Regard web UI app having 'widget' element located first as main web UI app.-->
    <xsl:template match="/">
        <xsl:apply-templates select="/root/manifest/widget:widget[1]"/>
    </xsl:template>

    <!-- root template -->
    <xsl:template match="/root/manifest/widget:widget">
        <xsl:text>&#xa;</xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="//tizen:app-widget"/>
            <xsl:apply-templates select="tizen:application"/>
            <xsl:apply-templates select="widget:content"/>
            <xsl:apply-templates select="widget:feature | //manifest:feature"/>
            <xsl:apply-templates select="widget:icon"/>
            <xsl:apply-templates select="widget:name"/>
            <xsl:apply-templates select="//tizen:privilege | //manifest:privileges/manifest:privilege"/>
            <xsl:apply-templates select="tizen:profile"/>
            <xsl:apply-templates select="tizen:setting"/>
        </xsl:copy>
    </xsl:template>

    <!-- copy 'app-widget' element -->
    <xsl:template match="tizen:app-widget">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!-- update 'id' attribute of 'app-widget' element -->
    <xsl:template match="tizen:app-widget/@id">
       <xsl:attribute name="id">
           <xsl:value-of select="concat(//widget:widget/tizen:application/@id, '.', ../../widget:name/text())"/>
       </xsl:attribute>
    </xsl:template>

    <!-- copy 'application' element -->
    <xsl:template match="tizen:application">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!-- copy 'content' element -->
    <xsl:template match="widget:content">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!--  merge 'feature' element -->
    <xsl:key name="GroupByFeautre" match="widget:feature | manifest:feature" use="@name"/>
    <xsl:template match="widget:feature | manifest:feature">
        <xsl:if test="generate-id()=generate-id(key('GroupByFeautre', @name)[1])">
            <xsl:text>&#xa;    </xsl:text>
            <xsl:element name="{local-name()}">
                <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
            </xsl:element>
        </xsl:if>
    </xsl:template>

    <!-- copy 'icon' element -->
    <xsl:template match="widget:icon">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!-- copy 'name' element -->
    <xsl:template match="widget:name">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!--  merge 'privilege' element -->
    <xsl:key name="GroupByPrivilege" match="tizen:privilege | manifest:privilege[not(preceding::tizen:privilege/@name=./text())]" use="concat(@name, '|' ,text())"/>
    <xsl:template match="tizen:privilege | manifest:privilege">
        <xsl:if test="generate-id()=generate-id(key('GroupByPrivilege', concat(@name, '|' ,text()))[1])">
            <xsl:choose>
                <xsl:when test="text()">
                    <xsl:text>&#xa;    </xsl:text>
                    <xsl:element name="tizen:privilege">
                            <xsl:attribute name="name"><xsl:value-of select="text()"/></xsl:attribute>
                    </xsl:element>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>&#xa;    </xsl:text>
                    <xsl:copy-of select="current()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <!-- copy 'profile' element -->
    <xsl:template match="tizen:profile">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!-- copy 'setting' element -->
    <xsl:template match="tizen:setting">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!-- copy elements and attributes -->
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
