/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.Tizen;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.config.ConfigCLICommand;

@TizenSubCommand(name="cli-config", usage="Configure the Tizen command line interface.")
public class ConfigCLI
extends AbstractCLI {
    private Map<String, String> properties = new HashMap<String, String>();
    @Option(name="-l", aliases={"--list"}, usage="Show the list of all CLI configuration keys and values.")
    public boolean list;
    @Option(name="-g", aliases={"--global"}, usage="Specify whether the operation must be done for a global scope (for all installed SDKs or for the current Tizen Studio only).", depends={})
    public boolean global;
    @Option(name="-d", aliases={"--delete"}, metaVar="<key>", usage="Remove the CLI configuration key and value.")
    public boolean delete;
    private String deleteKey = null;

    @Argument(metaVar="<key>=<value>", usage="Set the <key> of the Tizen CLI configuration with given <value>. In the Windows, <key>=<value> should be enclosed with double quotes like \"<key>=<value>\".")
    private void setConfigProperty(String property) throws CmdLineException {
        if (this.delete) {
            this.deleteKey = property;
        } else {
            this.log.trace("setConfigProperty {}", (Object)property);
            if (null == property || property.startsWith("-")) {
                return;
            }
            String[] arr = property.split("=");
            if (arr.length != 2) {
                throw new CmdLineException("configuration must be specified in the form:<key>=<value>");
            }
            this.properties.put(arr[0], arr[1]);
        }
    }

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Execute configCLI...");
        ConfigCLICommand configCommand = new Tizen().config();
        configCommand.setList(this.list);
        configCommand.setGlobal(this.global);
        configCommand.setKeyValue(this.properties);
        configCommand.setDeleteKey(this.deleteKey);
        if (!this.list && !this.delete && this.properties.isEmpty()) {
            this.printUsage();
            return 0;
        }
        Configuration tizenCLIConfig = (Configuration)configCommand.runCommand();
        if (tizenCLIConfig != null) {
            result = 0;
        }
        if (this.list) {
            if (this.global) {
                Collection<String> allKeys = tizenCLIConfig.getGlobalKeys();
                for (String key : allKeys) {
                    this.output.format("%1$s=%2$s\n", key, tizenCLIConfig.getGlobalValue(key));
                }
            } else {
                Collection<String> allKeys = tizenCLIConfig.getAllKeys();
                for (String key : allKeys) {
                    this.output.format("%1$s=%2$s\n", key, tizenCLIConfig.getValue(key));
                }
            }
        } else if (this.global) {
            this.progressLog.info("Setting global configuration is succeeded....\n");
        } else {
            this.progressLog.info("Setting configuration is succeeded....\n");
        }
        this.output.flush();
        return result;
    }
}

