/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildweb;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.core.web.BuildWebAppModule;
import org.tizen.common.core.web.BuildWebParameter;
import org.tizen.common.core.web.ProgressMonitor;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.util.OSChecker;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;

public class BuildWebCLICommand
extends AbstractSubCommand<BuildWebParameter> {
    private BuildWebAppModule buildWebAppModule = new BuildWebAppModule();
    private BuildWebParameter webAppBuildData = new BuildWebParameter();

    @Override
    protected BuildWebParameter call() {
        this.initExcludes();
        if (this.log.isTraceEnabled()) {
            this.log.trace("BuildData: {}", (Object)this.webAppBuildData);
        }
        if (null != this.webAppBuildData.getWorkingDir()) {
            String canonicalPath = null;
            try {
                canonicalPath = this.workingDir.getCanonicalPath();
                this.buildWebAppModule.setCwd(canonicalPath);
                this.log.trace("canonicalPath:{}", (Object)canonicalPath);
                this.log.trace("absolutPath:{}", (Object)this.workingDir.getAbsolutePath());
                this.log.trace("path:{}", (Object)this.workingDir.getPath());
            }
            catch (IOException e) {
                this.progressLog.error("Error occurred during setting current work path!");
                this.log.error("Error occurred during setting current work path!\n{}", (Object)e.getMessage());
                throw new UnexpectedException(2, "Error occurred during setting current work path!");
            }
        }
        try {
            this.buildWebAppModule.setMonitor(this.progressMonitor);
            this.buildWebAppModule.setData(this.webAppBuildData);
            this.buildWebAppModule.buildResources();
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (BuildException e) {
            this.progressLog.error("Error occured during build!\n\t{}", (Object)e.getMessage());
            throw new UnexpectedException(2, e.getMessage());
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.progressLog.error("Error occured during build!\n\t{}", (Object)e.getMessage());
            throw new UnexpectedException(2, e.getMessage());
        }
        this.progressLog.info("\nBUILD SUCCESSFUL\n");
        return this.webAppBuildData;
    }

    protected String convertPath(String path) throws IOException {
        String target = path;
        if (!OSChecker.isWindows() && target.startsWith("~" + File.separator)) {
            target = path.replaceFirst("~", System.getProperty("user.home"));
        }
        StandardFileHandler fileHandler = new StandardFileHandler();
        return (String)fileHandler.get(target, FileHandler.Attribute.PATH);
    }

    private void initExcludes() {
        this.buildWebAppModule.excludes.clear();
    }

    private void printOptions() {
    }

    public void setOptimize(boolean optimize) {
        this.webAppBuildData.setOptimize(optimize);
    }

    public void setOutputName(String outputName) {
        this.webAppBuildData.setOutputName(outputName);
    }

    public void setExcludeUIFW(boolean excludeUIFW) {
        this.webAppBuildData.setExcludeUIFW(excludeUIFW);
    }

    public void setExcludeList(List<String> excludeList) {
        this.webAppBuildData.setExcludeList(excludeList);
    }

    @Override
    public void setWorkingDir(File targetPath) {
        super.setWorkingDir(targetPath);
        this.webAppBuildData.setWorkingDir(targetPath);
    }

    public void setReferences(File ... refs) {
        this.webAppBuildData.setReferences(refs);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }
}

