/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.clean;

import java.io.File;
import java.util.Set;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.util.DirectoryUtil;
import org.tizen.ncli.util.DotnetUtil;

public class CleanCSProjectCommand
extends AbstractSubCommand<CleanCSProjectCommand> {
    public int clean_count = 0;

    @Override
    protected CleanCSProjectCommand call() {
        String workingPath = this.workingDir.toString();
        Set<String> csprojTargets = DotnetUtil.getCSProjects(workingPath);
        if (csprojTargets != null) {
            for (String csproj : csprojTargets) {
                File releaseObjPath;
                File releaseBuildPath;
                File debugObjPath;
                File parentFile = new File(csproj).getParentFile();
                if (parentFile == null) continue;
                String parentName = parentFile.getName();
                File debugBuildPath = DotnetUtil.getBuildOutputPath(csproj, "Debug");
                if (debugBuildPath.exists()) {
                    if (DirectoryUtil.deleteDirectory(debugBuildPath)) {
                        ++this.clean_count;
                        this.progressLog.info("csharp-app " + parentName + " (Debug) build directory clean success.");
                    } else {
                        this.progressLog.error("csharp-app " + parentName + " (Debug) build directory clean failed.");
                        throw new UnexpectedException(2, "csharp-app (Debug) build directory clean failed.");
                    }
                }
                if ((debugObjPath = DotnetUtil.getObjPath(csproj, "Debug")).exists()) {
                    if (DirectoryUtil.deleteDirectory(debugObjPath)) {
                        ++this.clean_count;
                        this.progressLog.info("csharp-app " + parentName + " (Debug) obj directory clean success.");
                    } else {
                        this.progressLog.error("csharp-app " + parentName + " (Debug) obj directory clean failed.");
                        throw new UnexpectedException(2, "csharp-app (Debug) obj directory clean failed.");
                    }
                }
                if ((releaseBuildPath = DotnetUtil.getBuildOutputPath(csproj, "Release")).exists()) {
                    if (DirectoryUtil.deleteDirectory(releaseBuildPath)) {
                        ++this.clean_count;
                        this.progressLog.info("csharp-app " + parentName + " (Release) build directory clean success.");
                    } else {
                        this.progressLog.error("csharp-app " + parentName + " (Release) build directory clean failed.");
                        throw new UnexpectedException(2, "csharp-app (Release) build directory clean failed.");
                    }
                }
                if (!(releaseObjPath = DotnetUtil.getObjPath(csproj, "Release")).exists()) continue;
                if (DirectoryUtil.deleteDirectory(releaseObjPath)) {
                    ++this.clean_count;
                    this.progressLog.info("csharp-app " + parentName + " (Release) obj directory clean success.");
                    continue;
                }
                this.progressLog.error("csharp-app " + parentName + " (Release) obj directory clean failed.");
                throw new UnexpectedException(2, "csharp-app (Release) obj directory clean failed.");
            }
        }
        return this;
    }
}

