/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.core.gputil.MacroUtil;
import org.tizen.core.gputil.VersionUtil;
import org.tizen.core.gputil.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PackageValidator {
    private boolean validate = false;
    private Map<String, String> macros = new HashMap<String, String>();
    private List<Package> pkgs = new ArrayList<Package>();

    public static boolean matchType(String[] orgProjTypes, String[] projTypes) {
        if (orgProjTypes != null && projTypes != null) {
            int len = orgProjTypes.length;
            if (len > projTypes.length) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (orgProjTypes[i].equals(projTypes[i])) continue;
                return false;
            }
        }
        return true;
    }

    public void addPackage(Package proc) {
        this.pkgs.add(proc);
    }

    public List<Package> getPackageList() {
        return this.pkgs;
    }

    public void reorder() {
        Collections.sort(this.pkgs, new Comparator<Package>(){

            @Override
            public int compare(Package arg0, Package arg1) {
                return Integer.compare(arg0.getPriority(), arg1.getPriority());
            }
        });
    }

    public List<Package> getMatchPakcages(List<String> projTypeList) {
        if (!this.validate) {
            return null;
        }
        ArrayList<Package> matchedPkgs = null;
        for (Package pkg : this.pkgs) {
            if (!pkg.match(projTypeList)) continue;
            if (matchedPkgs == null) {
                matchedPkgs = new ArrayList<Package>();
            }
            matchedPkgs.add(pkg);
        }
        return matchedPkgs;
    }

    public boolean load(File validatorFile, String requireVersion) {
        String name;
        String version;
        Document sbiDoc = XMLUtil.readXML((File)validatorFile);
        if (sbiDoc == null) {
            this.validate = false;
            return false;
        }
        if (requireVersion != null && !requireVersion.isEmpty() && VersionUtil.compareVersion((String)(version = XMLUtil.getDOMValue((Document)sbiDoc, (String)"/ssi/@version")), (String)requireVersion) < 0) {
            this.validate = false;
            return false;
        }
        NodeList inputNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/ssi/macros/input");
        for (int i = 0; i < inputNodes.getLength(); ++i) {
            Element elem;
            Node inputNode = inputNodes.item(i);
            if (!(inputNode instanceof Element) || (name = (elem = (Element)inputNode).getAttribute("name")) == null) continue;
            String value = null;
            String method = elem.getAttribute("method");
            if (method.equals("xpath") || method.equals("sysvar") || !method.equals("user") || (value = elem.getAttribute("value")) == null) continue;
            this.macros.put(name, value);
        }
        NodeList validatNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/ssi/validator/package");
        for (int i = 0; i < validatNodes.getLength(); ++i) {
            Node pkgNode = validatNodes.item(i);
            if (pkgNode == null || !(pkgNode instanceof Element)) continue;
            name = ((Element)pkgNode).getAttribute("name");
            String type = ((Element)pkgNode).getAttribute("type");
            String priority = ((Element)pkgNode).getAttribute("priority");
            String unspecified = ((Element)pkgNode).getAttribute("unspecified");
            Package pkg = new Package();
            if (name != null && !name.isEmpty()) {
                pkg.setName(name);
            }
            if (type != null && !type.isEmpty()) {
                if (this.macros != null && !this.macros.isEmpty()) {
                    type = MacroUtil.processMacro((String)type, this.macros);
                }
                pkg.setType(type);
            }
            if (priority != null && !priority.isEmpty()) {
                try {
                    pkg.setPriority(Integer.parseInt(priority));
                }
                catch (NumberFormatException e) {
                    pkg.setPriority(0);
                }
            }
            if (unspecified != null && !unspecified.isEmpty()) {
                try {
                    pkg.setUnspecified(Boolean.valueOf(unspecified));
                }
                catch (NumberFormatException e) {
                    pkg.setPriority(0);
                }
            }
            NodeList includes = XMLUtil.getDOMNodes((Element)((Element)pkgNode), (String)"include");
            for (int j = 0; j < includes.getLength(); ++j) {
                String prjType;
                Node prjNode = includes.item(j);
                if (prjNode == null || !(prjNode instanceof Element) || (prjType = ((Element)prjNode).getAttribute("type")) == null || prjType.isEmpty()) continue;
                String count = ((Element)prjNode).getAttribute("count");
                String order = ((Element)prjNode).getAttribute("order");
                if (this.macros != null && !this.macros.isEmpty()) {
                    prjType = MacroUtil.processMacro((String)prjType, this.macros);
                    if (count != null && !count.isEmpty()) {
                        count = MacroUtil.processMacro((String)count, this.macros);
                    }
                    if (order != null && !order.isEmpty()) {
                        order = MacroUtil.processMacro((String)order, this.macros);
                    }
                }
                pkg.addProject(new Package.Project(0, prjType, order, count));
            }
            NodeList excludes = XMLUtil.getDOMNodes((Element)((Element)pkgNode), (String)"exclude");
            for (int j = 0; j < excludes.getLength(); ++j) {
                String prjType;
                Node prjNode = excludes.item(j);
                if (prjNode == null || !(prjNode instanceof Element) || (prjType = ((Element)prjNode).getAttribute("type")) == null || prjType.isEmpty()) continue;
                if (this.macros != null && !this.macros.isEmpty()) {
                    prjType = MacroUtil.processMacro((String)prjType, this.macros);
                }
                pkg.addProject(new Package.Project(1, prjType, null, null));
            }
            this.addPackage(pkg);
        }
        this.reorder();
        this.validate = true;
        return true;
    }

    public boolean load(File validatorFile) {
        return this.load(validatorFile, null);
    }

    public boolean isValid() {
        return this.validate;
    }

    public static class Package {
        public String name;
        public String type;
        public int priority = 255;
        private Boolean unspecified = true;
        private List<Project> projs = new ArrayList<Project>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public void setUnspecified(Boolean unspecified) {
            this.unspecified = unspecified;
        }

        public void addProject(Project proc) {
            this.projs.add(proc);
        }

        public List<Project> getProjectList() {
            return this.projs;
        }

        public boolean match(List<String> projTypeList) {
            if (projTypeList == null || projTypeList.isEmpty()) {
                return false;
            }
            int order = 0;
            int[] matchCnts = new int[this.projs.size()];
            for (String projType : projTypeList) {
                String[] projTypes;
                if (projType == null || (projTypes = projType.split("/")).length <= 0) continue;
                int i = 0;
                int mc = 0;
                for (Project proj : this.projs) {
                    boolean r = proj.matchType(projTypes);
                    if (r) {
                        r = proj.matchOrder(order);
                    }
                    if (r) {
                        ++mc;
                        int n = i;
                        matchCnts[n] = matchCnts[n] + 1;
                    }
                    ++i;
                }
                if (mc <= 0 && !this.unspecified.booleanValue()) {
                    return false;
                }
                ++order;
            }
            int i = 0;
            for (Project proj : this.projs) {
                int matchCnt = matchCnts[i];
                if (proj.getType() == 0 ? !proj.matchCount(matchCnt) : proj.getType() == 1 && proj.matchCount(matchCnt)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static class Project {
            public int type;
            public String[] projTypes;
            public CountRule count = new CountRule("n");
            public CountRule order = new CountRule("dc");

            public Project(int type, String projType, String order, String count) {
                this.setType(type);
                this.setProjType(projType);
                this.setOrder(order);
                this.setCount(count);
            }

            public int getType() {
                return this.type;
            }

            public void setType(int type) {
                this.type = type;
            }

            public String[] getProjType() {
                return this.projTypes;
            }

            public void setProjType(String projType) {
                if (projType != null) {
                    this.projTypes = projType.split("/");
                }
            }

            public void setCount(String countFmt) {
                if (countFmt == null || countFmt.isEmpty()) {
                    countFmt = "n";
                }
                this.count.setCountRule(countFmt);
            }

            public void setOrder(String orderFmt) {
                if (orderFmt == null || orderFmt.isEmpty()) {
                    orderFmt = "dc";
                }
                this.order.setCountRule(orderFmt);
            }

            public boolean matchType(String[] projTypes) {
                return PackageValidator.matchType(this.projTypes, projTypes);
            }

            public boolean matchOrder(int orderValue) {
                return this.order.matchCount(orderValue);
            }

            public boolean matchCount(int countValue) {
                return this.count.matchCount(countValue);
            }

            public boolean match(String[] projTypes, int order, int count) {
                boolean r = this.matchType(projTypes);
                if (!r) {
                    return false;
                }
                r = this.matchOrder(order);
                if (!r) {
                    return false;
                }
                r = this.matchCount(count);
                return r;
            }
        }

        private static class CountRule {
            public int countRule = 0;
            public int countValue = 0;

            public CountRule(int rule, int value) {
                this.countRule = rule;
                this.countValue = value;
            }

            public CountRule(String fmt) {
                this.setCountRule(fmt);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setCountRule(String countFmt) {
                if (countFmt == null || countFmt.isEmpty()) {
                    return;
                }
                if (countFmt.equals("dc")) {
                    this.countRule = 0;
                    return;
                }
                if (countFmt.equals("n")) {
                    this.countRule = 2;
                    this.countValue = 0;
                    return;
                }
                String[] os = countFmt.split(" ");
                if (os.length >= 2) {
                    try {
                        this.countValue = Integer.parseInt(os[1]);
                    }
                    catch (NumberFormatException e) {
                        this.countRule = 0;
                    }
                    finally {
                        this.countRule = os[0].equals("gt") ? 2 : (os[0].equals("ge") ? 3 : (os[0].equals("lt") ? 4 : (os[0].equals("le") ? 5 : 0)));
                    }
                } else if (os.length >= 1) {
                    try {
                        this.countValue = Integer.parseInt(os[0]);
                    }
                    catch (NumberFormatException e) {
                        this.countRule = 0;
                    }
                    finally {
                        this.countRule = 1;
                    }
                }
            }

            public boolean matchCount(int count) {
                return !(this.countRule == 1 ? count != this.countValue : (this.countRule == 2 ? count <= this.countValue : (this.countRule == 3 ? count < this.countValue : (this.countRule == 4 ? count >= this.countValue : this.countRule == 5 && count > this.countValue))));
            }
        }
    }
}

