/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.migrate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import org.tizen.core.gputil.IOUtil;
import org.tizen.ncli.subcommands.migrate.MigrationData;

public class ProjectJsonParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parse(String jsonPath, MigrationData data) {
        JsonObject rootObject;
        JsonReader reader = null;
        try {
            reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(jsonPath), "UTF-8"));
            rootObject = new JsonParser().parse(reader).getAsJsonObject();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{reader});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{reader});
            return bl;
        }
        IOUtil.tryClose((Object[])new Object[]{reader});
        JsonObject dependencies = rootObject.getAsJsonObject("dependencies");
        ProjectJsonParser.parseDependencies(data, dependencies);
        JsonObject frameworks = rootObject.getAsJsonObject("frameworks");
        ProjectJsonParser.parseFrameworks(data, frameworks);
        return true;
    }

    private static void parseFrameworks(MigrationData data, JsonObject frameworks) {
        Set entries = frameworks.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            data.addTargerFramework(key);
            if (value.isJsonPrimitive() || !value.isJsonObject()) continue;
            JsonObject obj = value.getAsJsonObject();
            for (Map.Entry subentry : obj.entrySet()) {
                String subkey = (String)subentry.getKey();
                if (subkey.equals("imports")) {
                    JsonElement subvalue = (JsonElement)subentry.getValue();
                    if (subvalue.isJsonPrimitive()) {
                        data.addPackageTargetFallback(subvalue.getAsString());
                        continue;
                    }
                    if (!subvalue.isJsonArray()) continue;
                    JsonArray array = subvalue.getAsJsonArray();
                    for (JsonElement elem : array) {
                        if (!elem.isJsonPrimitive()) continue;
                        data.addPackageTargetFallback(elem.getAsString());
                    }
                    continue;
                }
                if (!subkey.equals("dependencies")) continue;
            }
        }
    }

    private static void parseDependencies(MigrationData data, JsonObject dependencies) {
        Set entries = dependencies.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            String version = null;
            if (value.isJsonPrimitive()) {
                version = value.getAsString();
            } else if (value.isJsonObject()) {
                JsonObject vobj = value.getAsJsonObject();
                for (Map.Entry subentry : vobj.entrySet()) {
                    String subkey = (String)subentry.getKey();
                    if (!subkey.equals("version")) continue;
                    version = ((JsonElement)subentry.getValue()).getAsString();
                    break;
                }
            }
            if (version == null) continue;
            data.addPackage(key, version);
        }
    }
}

