/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.ctrlwords;

import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordHandler;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordListener;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordMap;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Iterator;

public final class RtfCtrlWordMgr {
    public static final boolean debug = false;
    public static final boolean debugFound = false;
    public static final boolean debugNotFound = true;
    private PushbackInputStream reader = null;
    private RtfParser rtfParser = null;
    private RtfCtrlWordMap ctrlWordMap = null;
    private ArrayList listeners = new ArrayList();

    public RtfCtrlWordMgr(RtfParser rtfParser, PushbackInputStream pushbackInputStream) {
        this.rtfParser = rtfParser;
        this.reader = pushbackInputStream;
        this.ctrlWordMap = new RtfCtrlWordMap(rtfParser);
    }

    public int handleKeyword(RtfCtrlWordData rtfCtrlWordData, int n) {
        int n2 = 0;
        this.beforeCtrlWord(rtfCtrlWordData);
        n2 = this.dispatchKeyword(rtfCtrlWordData, n);
        this.afterCtrlWord(rtfCtrlWordData);
        return n2;
    }

    private int dispatchKeyword(RtfCtrlWordData rtfCtrlWordData, int n) {
        int n2 = 0;
        if (rtfCtrlWordData != null) {
            RtfCtrlWordHandler rtfCtrlWordHandler = this.ctrlWordMap.getCtrlWordHandler(rtfCtrlWordData.ctrlWord);
            if (rtfCtrlWordHandler != null) {
                rtfCtrlWordHandler.handleControlword(rtfCtrlWordData);
            } else {
                n2 = -8;
            }
        }
        return n2;
    }

    public void addRtfCtrlWordListener(RtfCtrlWordListener rtfCtrlWordListener) {
        this.listeners.add(rtfCtrlWordListener);
    }

    public void removeRtfCtrlWordListener(RtfCtrlWordListener rtfCtrlWordListener) {
        this.listeners.remove(rtfCtrlWordListener);
    }

    private boolean beforeCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            RtfCtrlWordListener rtfCtrlWordListener = (RtfCtrlWordListener)iterator.next();
            rtfCtrlWordListener.beforeCtrlWord(rtfCtrlWordData);
        }
        return true;
    }

    private boolean onCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            RtfCtrlWordListener rtfCtrlWordListener = (RtfCtrlWordListener)iterator.next();
            rtfCtrlWordListener.onCtrlWord(rtfCtrlWordData);
        }
        return true;
    }

    private boolean afterCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            RtfCtrlWordListener rtfCtrlWordListener = (RtfCtrlWordListener)iterator.next();
            rtfCtrlWordListener.afterCtrlWord(rtfCtrlWordData);
        }
        return true;
    }
}

