/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildweb;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.tizen.common.core.web.BuildWebAppModule;
import org.tizen.common.core.web.BuildWebParameter;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.util.OSChecker;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.subcommands.build.buildweb.BuildWebMethodData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BuildWebCommand {
    private File workingDir;
    private BuildWebAppModule buildWebAppModule = new BuildWebAppModule();
    private BuildWebParameter webAppBuildData = new BuildWebParameter();

    protected String convertPath(String path) throws IOException {
        String target = path;
        if (!OSChecker.isWindows() && target.startsWith("~" + File.separator)) {
            target = path.replaceFirst("~", System.getProperty("user.home"));
        }
        StandardFileHandler fileHandler = new StandardFileHandler();
        return (String)fileHandler.get(target, FileHandler.Attribute.PATH);
    }

    private void initExcludes() {
        this.buildWebAppModule.excludes.clear();
    }

    public void setOptimize(boolean optimize) {
        this.webAppBuildData.setOptimize(optimize);
    }

    public void setOutputName(String outputName) {
        this.webAppBuildData.setOutputName(outputName);
    }

    public void setExcludeUIFW(boolean excludeUIFW) {
        this.webAppBuildData.setExcludeUIFW(excludeUIFW);
    }

    public void setExcludeList(List<String> excludeList) {
        this.webAppBuildData.setExcludeList(excludeList);
    }

    public void setWorkingDir(File targetPath) {
        this.webAppBuildData.setWorkingDir(targetPath);
    }

    public void setReferences(File ... refs) {
        this.webAppBuildData.setReferences(refs);
    }

    private static boolean getManifestInfo(String projectDir, BuildWebMethodData data) {
        File file = new File(projectDir, "config.xml");
        if (!file.exists()) {
            return false;
        }
        Document menifestDoc = XMLUtil.readXML((File)file);
        Node appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:widget/tizen:app-widget");
        String appType = null;
        if (appNode != null) {
            appType = "widget";
        }
        if (appNode == null) {
            appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:widget/tizen:application");
            appType = "app";
        }
        if (appNode == null) {
            appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:widget/tizen:service");
            appType = "service";
        }
        if (appNode != null && appNode instanceof Element) {
            data.setAppType(appType);
            String id = XMLUtil.getDOMValueNS((Element)((Element)appNode), (String)"@appid");
            data.setAppId(id);
        }
        return true;
    }

    public static BuildWebMethodData prepareBuildMethod(String projFullPath) {
        BuildWebMethodData data = new BuildWebMethodData();
        BuildWebCommand.getManifestInfo(projFullPath, data);
        return data;
    }
}

