/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.File;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.FileOptionHandler;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.InvalidPasswordException;
import org.tizen.ncli.ide.shell.AbstractSecurityProfileCLI;
import org.tizen.ncli.util.CommandUtil;

@TizenSubCommand(name="add", usage="Add the specified security profile, which can contain certificates.")
public class SecurityProfileAddCLI
extends AbstractSecurityProfileCLI {
    @Option(name="-n", aliases={"--name"}, required=true, metaVar="<profile name>", usage="Set the profile name. (Required)")
    private String name;
    @Option(name="-a", aliases={"--author"}, required=true, metaVar="<author certificate>", handler=FileOptionHandler.class, usage="Set the author certificate. (Required)")
    private File authorPath;
    @Option(name="-p", aliases={"--password"}, required=true, metaVar="<password>", usage="Set the author certificate password. (Required)")
    private String authorPwd;
    @Option(name="-A", aliases={"--active"}, usage="Set this profile as active.")
    private boolean isActive;
    @Option(name="-c", aliases={"--ca"}, handler=FileOptionHandler.class, metaVar="[CA certificate]", usage="Set the author CA certificate path.")
    private File authorCaPath;
    @Option(name="-r", aliases={"--rootca"}, handler=FileOptionHandler.class, metaVar="[root CA certificate]", usage="Set the author Root CA certificate path.")
    private File authorRootCaPath;
    @Option(name="-d", aliases={"--dist"}, handler=FileOptionHandler.class, metaVar="[distributor certificate]", usage="Set the distributor certificate path.\nIt can be set to multiple arguments.")
    private File[] distPath = new File[0];
    @Option(name="-dp", aliases={"--dist-password"}, metaVar="[distributor password]", usage="Set the distributor password.\nIt can be set to multiple arguments.")
    private String[] distPwd = new String[0];
    @Option(name="-dc", aliases={"--dist-ca"}, handler=FileOptionHandler.class, metaVar="[distributor CA certificate]", usage="Set the distributor CA certificate path.\nIt can be set to multiple arguments.")
    private File[] distCaPath = new File[0];
    @Option(name="-dr", aliases={"--dist-rootca"}, handler=FileOptionHandler.class, metaVar="[distributor root CA certificate]", usage="Set the distributor Root CA certificate path.\nIt can be set to multiple arguments.")
    private File[] distRootCaPath = new File[0];
    @Option(name="-f", aliases={"--force"}, usage="If there is no Profile XML, then generates a file.")
    private boolean force;

    @Override
    public int execute() {
        int result = 0;
        this.log.trace("Begin SecurityProfileAddCLI...");
        this.trace();
        File file = this.getProfileXMLFile();
        this.log.trace("XML Path: {}", (Object)file);
        SigningProfileContainer container = null;
        try {
            container = this.getContainerFrom(file);
        }
        catch (FileNotFoundException e) {
            this.progressLog.error("Not found a file of security profiles. Please check specified path.");
            return 2;
        }
        this.log.trace("Read XML: {} profile found.", (Object)container.getProfiles().size());
        SigningProfile profile = this.getProfileFrom(container);
        try {
            this.createItemForAuthorTo(profile);
            this.createItemForDistributorTo(profile);
        }
        catch (FileNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.progressLog.error("Specified file not found: {}", (Object)e.getMessage());
            return 1;
        }
        catch (InvalidPasswordException e) {
            this.progressLog.error("Invalid file or password: {}", (Object)e.getMessage());
            return 2;
        }
        this.progressLog.info(this.buildInformation(profile));
        try {
            boolean isFirstProfile = container.getActiveProfile() == null && container.getProfiles().isEmpty();
            container.addProfile(profile);
            if (isFirstProfile || this.isActive) {
                container.setActiveProfile(profile);
            }
            File writtenFile = this.writeXML(container, file);
            this.progressLog.info("Succeed to add '{}' profile.", (Object)this.name);
            this.progressLog.info("If want to sign by this, add the file of security profiles in CLI configuration");
            this.progressLog.info("  like 'tizen cli-config \"{}={}\"'.", (Object)"profiles.path", (Object)writtenFile);
        }
        catch (FileNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.progressLog.error("Failed to write '{}'.", (Object)file);
            return 2;
        }
        this.log.trace("Finish SecurityProfileAddCLI...");
        return result;
    }

    private void trace() {
        this.log.trace("[Argument] name: {}", (Object)this.name);
        this.log.trace("[Argument] authorPath: {}", (Object)this.authorPath);
        this.log.trace("[Argument] authorPwd: {}", (Object)this.authorPwd);
        this.log.trace("[Argument] authorCaPath: {}", (Object)this.authorCaPath);
        this.log.trace("[Argument] authorRootCaPath: {}", (Object)this.authorRootCaPath);
        for (File distPathFile : this.distPath) {
            this.log.trace("[Argument] distPath: {}", (Object)distPathFile);
        }
        for (String distPwdStr : this.distPwd) {
            this.log.trace("[Argument] distPwd: {}", (Object)distPwdStr);
        }
        for (File distCaPathFile : this.distCaPath) {
            this.log.trace("[Argument] distCaPath: {}", (Object)distCaPathFile);
        }
        for (File distRootCaPathFile : this.distRootCaPath) {
            this.log.trace("[Argument] distRootCaPath: {}", (Object)distRootCaPathFile);
        }
    }

    private SigningProfileContainer getContainerFrom(File file) throws FileNotFoundException {
        if (file != null) {
            if (file.exists()) {
                return this.readXML(file);
            }
            if (!this.force) {
                throw new FileNotFoundException();
            }
        }
        this.progressLog.error("No exist the default path of security profiles.");
        this.log.trace("New profile container is created.");
        return new SigningProfileContainer();
    }

    private SigningProfile getProfileFrom(SigningProfileContainer container) {
        SigningProfile profile = container.getProfileByName(this.name);
        if (profile != null) {
            this.progressLog.warn("Security profiles have a specified profile. Will be overwritten.");
            container.removeProfile(profile);
            return profile;
        }
        this.log.trace("New profile is created.");
        return new SigningProfile(this.name);
    }

    private void createItemForAuthorTo(SigningProfile profile) throws FileNotFoundException, InvalidPasswordException {
        this.authorPath = this.checkExist(this.authorPath);
        this.authorCaPath = this.checkExist(this.authorCaPath);
        this.authorRootCaPath = this.checkExist(this.authorRootCaPath);
        if (this.authorPwd == null) {
            this.progressLog.warn("Author password is empty.");
        } else if (!this.checkPassword(this.authorPath, this.authorPwd)) {
            throw new InvalidPasswordException(this.authorPath.getPath());
        }
        profile.createProfileItem(0, this.authorPath.getAbsolutePath(), this.authorPwd, this.authorCaPath != null ? this.authorCaPath.getAbsolutePath() : null, this.authorRootCaPath != null ? this.authorRootCaPath.getAbsolutePath() : null);
        this.log.trace("Author item is created.");
    }

    private void createItemForDistributorTo(SigningProfile profile) throws FileNotFoundException, InvalidPasswordException {
        if (ArrayUtil.isEmpty((Object[])this.distPath)) {
            profile.createProfileItemForDeveloper();
            profile.createEmptyProfileItem(2);
            this.log.trace("Default distributor item is created.");
        } else {
            int length = this.distPath.length;
            for (int i = 0; i < length; ++i) {
                String path = null;
                String pwd = null;
                String caPath = null;
                String rootCaPath = null;
                this.distPath[i] = this.checkExist(this.distPath[i]);
                path = this.distPath[i].getAbsolutePath();
                if (this.hasArrayItem(this.distPwd, i)) {
                    pwd = this.distPwd[i];
                    if (!this.checkPassword(this.distPath[i], pwd)) {
                        throw new InvalidPasswordException(this.distPath[i].getPath());
                    }
                } else {
                    this.progressLog.warn("Distributor( {} ) password is empty.", (Object)path);
                }
                if (this.hasArrayItem(this.distCaPath, i)) {
                    this.distCaPath[i] = this.checkExist(this.distCaPath[i]);
                    caPath = this.distCaPath[i].getAbsolutePath();
                }
                if (this.hasArrayItem(this.distRootCaPath, i)) {
                    this.distRootCaPath[i] = this.checkExist(this.distRootCaPath[i]);
                    rootCaPath = this.distRootCaPath[i].getAbsolutePath();
                }
                profile.createProfileItem(i + 1, path, pwd, caPath, rootCaPath);
                this.log.trace("Distributor{} item is created.", (Object)(i + 1));
            }
            if (this.distPath.length < 2) {
                profile.createEmptyProfileItem(2);
            }
        }
    }

    private File checkExist(File file) throws FileNotFoundException {
        String tildeEscapedPath;
        if (file == null) {
            return null;
        }
        if (!OSChecker.isWindows() && (tildeEscapedPath = CommandUtil.getTildeEscapedPath(file.getPath())) != null) {
            file = new File(tildeEscapedPath);
        }
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getPath());
        }
        return file;
    }

    private boolean hasArrayItem(Object[] obj, int i) {
        return i < obj.length && obj[i] != null;
    }

    private String getFirstAlias(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            return alias;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private boolean checkPassword(File keyFile, String password) throws InvalidPasswordException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

