/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.trustanchor;

import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.file.DirectoryCopyHandlingCommand;
import org.tizen.common.core.command.prompter.FileHandlingOption;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TizenSubCommand(name="set", usage="Set a trust-anchor configuration.")
public class TrustAnchorSetCLI
extends AbstractCLI {
    @Option(name="-c", aliases={"--user-certificate-path"}, usage="Specify the user certificate path.")
    private String certPath = null;
    @Option(name="-s", aliases={"--use-system-certs"}, metaVar="{true|false}", usage="Determine whether to use system certificate or not. (false is default)")
    private String useSystemCerts = null;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public int execute() {
        File projectPath = this.getRealWorkingPath();
        this.log.trace("getRealWorkingPath for trust-anchor set: {}", (Object)projectPath.toString());
        String trustAnchorPath = null;
        File manifestFile = new File(projectPath.getAbsolutePath(), "tizen-manifest.xml");
        File configFile = new File(projectPath.getAbsolutePath(), "config.xml");
        Document doc = null;
        String xmlName = null;
        String rootNodeStr = null;
        String trustAnchorNodeStr = null;
        if (manifestFile != null && manifestFile.exists()) {
            xmlName = projectPath + File.separator + "tizen-manifest.xml";
            rootNodeStr = "manifest";
            trustAnchorNodeStr = "trust-anchor";
            doc = XMLUtil.readXML((File)manifestFile);
            trustAnchorPath = projectPath + File.separator + "res" + File.separator + ".trust-anchor";
        } else if (configFile != null && configFile.exists()) {
            xmlName = projectPath + File.separator + "config.xml";
            rootNodeStr = "widget";
            trustAnchorNodeStr = "tizen:trust-anchor";
            doc = XMLUtil.readXML((File)configFile);
            trustAnchorPath = projectPath + File.separator + ".trust-anchor";
        } else {
            this.progressLog.error("Please input the valid Tizen project.");
            this.log.error("Please input the valid Tizen project.");
            return -1;
        }
        if (doc == null) {
            this.progressLog.error("Reading project configuration file failed.");
            this.log.error("Reading project configuration file failed.");
            return -1;
        }
        Element trustAnchorElement = null;
        Node trustAnchorNode = XMLUtil.getDOMNodeT((Document)doc, (String[])new String[]{rootNodeStr, trustAnchorNodeStr});
        if (trustAnchorNode == null) {
            trustAnchorElement = doc.createElement(trustAnchorNodeStr);
            if (this.useSystemCerts == null) {
                this.useSystemCerts = "false";
            }
            trustAnchorElement.setAttribute("use-system-certs", this.useSystemCerts);
            Node rootNode = XMLUtil.getDOMNodeT((Document)doc, (String[])new String[]{rootNodeStr});
            if (trustAnchorElement == null || rootNode == null) {
                this.progressLog.error("Updating use-system-certs attribute failed.");
                this.log.error("Updating use-system-certs attribute failed.");
                return -1;
            }
            rootNode.appendChild(trustAnchorElement);
        } else if (this.useSystemCerts != null) {
            ((Element)trustAnchorNode).setAttribute("use-system-certs", this.useSystemCerts);
        }
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        ArrayList<String> copySrcList = new ArrayList<String>();
        ArrayList<String> copyDesList = new ArrayList<String>();
        if (this.certPath != null && !this.certPath.isEmpty()) {
            String[] certPaths;
            for (String path : certPaths = this.certPath.split(",")) {
                File certFile = new File(path);
                if (!certFile.exists()) continue;
                if (certFile.isFile()) {
                    copyDesList.add(trustAnchorPath + File.separator + new File(path).getName());
                } else {
                    if (!certFile.isDirectory()) continue;
                    copyDesList.add(trustAnchorPath);
                }
                copySrcList.add(path);
            }
        }
        if (trustAnchorElement != null && copySrcList.size() == 0) {
            this.progressLog.error("Please input the valid user certificate file.");
            this.log.error("Please input the valid user certificate file.");
            return -1;
        }
        DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
        dirCopyCmd.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
        executor.execute(new Command[]{dirCopyCmd});
        XMLUtil.writeToFile((Document)doc, (String)xmlName);
        this.progressLog.error("Succeed to set the trust-anchor.");
        return 0;
    }
}

