/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.engine.freemarker;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.verrari.template.TemplateTransformer;

public class FreemarkerTemplateTransformer
extends TemplateTransformer {
    @Override
    public String translateTransform(String contents) {
        Pattern pattern = Pattern.compile("(\\$\\$\\{)(.*?)(\\})");
        Matcher matcher = pattern.matcher(contents);
        String translatedContents = contents;
        while (matcher.find()) {
            translatedContents = translatedContents.replace(matcher.group(), matcher.group().replace("$$", "$").replace('|', '!'));
        }
        return translatedContents;
    }

    @Override
    public String translateFunction(String contents) {
        Pattern pattern = Pattern.compile("(\\$\\@\\{)(.*?)(\\})");
        Matcher matcher = pattern.matcher(contents);
        String translatedContents = contents;
        while (matcher.find()) {
            String matchGroup = matcher.group();
            if (matchGroup.contains("=")) {
                matchGroup = matchGroup.replace("$@{", "").replace("}", "");
                String[] arguments = matchGroup.split("=");
                String assignFunction = String.format("<#assign %s=\"${%s}\">${%s}", arguments[0].trim(), arguments[1].trim(), arguments[0].trim());
                translatedContents = translatedContents.replace(matcher.group(), assignFunction);
                continue;
            }
            translatedContents = translatedContents.replace(matcher.group(), matcher.group().replace("$@", "$"));
        }
        return translatedContents;
    }

    @Override
    public String translateInclude(String contents) {
        Pattern pattern = Pattern.compile("(\\$\\$include)(.*?)(\\})");
        Matcher matcher = pattern.matcher(contents);
        String translatedContents = contents;
        while (matcher.find()) {
            translatedContents = translatedContents.replace(matcher.group(), matcher.group().replace("$$", "<#").replace("{", " ").replace('}', '>'));
        }
        return translatedContents;
    }

    @Override
    public String translateIf(String contents) {
        Pattern pattern = Pattern.compile("(\\$\\$if)(.*?)(\\})");
        Matcher matcher = pattern.matcher(contents);
        String translatedContents = contents;
        while (matcher.find()) {
            translatedContents = translatedContents.replace(matcher.group(), matcher.group().replace("$$", "<#").replace("{", " ").replace("}", "").trim().concat("?exists>"));
        }
        pattern = Pattern.compile("(\\$\\$elseif)(.*?)(\\})");
        matcher = pattern.matcher(translatedContents);
        while (matcher.find()) {
            translatedContents = translatedContents.replace(matcher.group(), matcher.group().replace("$$", "<#").replace("{", " ").replace("}", "").trim().concat("?exists>"));
        }
        pattern = Pattern.compile("(\\$\\$else)");
        matcher = pattern.matcher(translatedContents);
        while (matcher.find()) {
            translatedContents = translatedContents.replace(matcher.group(), matcher.group().replace("$$else", "<#else>"));
        }
        pattern = Pattern.compile("(\\$\\$endif)");
        matcher = pattern.matcher(translatedContents);
        while (matcher.find()) {
            translatedContents = translatedContents.replace(matcher.group(), matcher.group().replace("$$endif", "</#if>"));
        }
        return translatedContents;
    }
}

