/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.util.Set;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.packages.PackageCSCLICommand;
import org.tizen.ncli.subcommands.packages.PackageCSCLICommandData;
import org.tizen.ncli.util.DotnetUtil;

@TizenSubCommand(name="package-cs", usage="Create an C# application package for Tizen.")
public class PackageCSCLI
extends AbstractCLI {
    @Option(name="-t", aliases={"--type"}, metaVar="tpk", usage="package type.", hidden=true)
    private String type;
    @Option(name="-C", aliases={"--configuration"}, metaVar="{Debug|Release}", usage="Specify the build configuration. (Debug is default)")
    private String configuration = null;
    @Option(name="-s", aliases={"--sign"}, metaVar="<security profile>", usage="Specify the security profile name.")
    private String sign;
    @Option(name="-o", aliases={"--output"}, metaVar="<output path>", usage="Specify the output file path.")
    private String outputPath = null;
    @Option(name="-p", aliases={"--project"}, metaVar="<path>", usage="Project path.", hidden=true)
    private String projectPath;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Execute PackageCSCLI...");
        File path = this.getRealWorkingPath();
        this.log.trace("getRealWorkingPath: {}", (Object)path.toString());
        if (!path.exists()) {
            this.progressLog.info("Specify location of the working directory.");
            return -1;
        }
        String workingTargetFilePath = DotnetUtil.getWorkingTarget(path.getPath());
        if (workingTargetFilePath == null) {
            this.progressLog.error("Package failed : There is no solution or project file.");
            return -1;
        }
        if (workingTargetFilePath.isEmpty()) {
            this.progressLog.error("Package failed : There is multiple solution or project files.");
            this.progressLog.error("Please specify which solution or project file to use.");
            return -1;
        }
        Set<String> targets = DotnetUtil.getCSProjectsFromTarget(workingTargetFilePath);
        if (targets == null || targets.isEmpty()) {
            this.progressLog.error("Package failed : Cannot find the project in working directory.");
            this.progressLog.error("Please run command with correct solution file.");
            return -1;
        }
        if (this.configuration == null) {
            this.configuration = DotnetUtil.getDefaultConfiguration();
        }
        if (this.outputPath != null && this.outputPath.startsWith(".")) {
            this.outputPath = this.currentWorkspacePath + File.separator + this.outputPath;
        }
        for (String csproj : targets) {
            File projFile = new File(csproj);
            if (!DotnetUtil.isTizenProject(projFile)) continue;
            String projRoot = projFile.getParentFile().getPath();
            File buildOutput = DotnetUtil.getBuildOutputPath(csproj, this.configuration);
            String type = DotnetUtil.getBuildOutputType(csproj);
            this.progressLog.info(buildOutput.getAbsolutePath());
            PackageCSCLICommand packageCommand = new PackageCSCLICommand();
            packageCommand.setWorkingDir(buildOutput);
            packageCommand.setProjectPath(projRoot);
            packageCommand.setOutputPath(this.outputPath);
            packageCommand.setOutputType(type);
            packageCommand.setProfileName(this.sign);
            packageCommand.setConfiguration(this.configuration);
            PackageCSCLICommandData data = (PackageCSCLICommandData)packageCommand.runCommand();
            if (null != data) {
                String tpkOutPath = data.getTpkPath();
                if (null == tpkOutPath) continue;
                this.progressLog.info("Package File Location: {}", (Object)tpkOutPath);
                continue;
            }
            this.progressLog.warn("Failed to package : {}", (Object)csproj);
        }
        return result;
    }
}

