/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.tizen.core.gputil.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NativeProject {
    private static XPath xpath = XPathFactory.newInstance().newXPath();

    public static boolean isNativeProject(String projectRootPath) {
        if (projectRootPath == null) {
            return false;
        }
        String cprojectPath = projectRootPath + File.separatorChar + ".cproject";
        return new File(cprojectPath).isFile();
    }

    public static Document getDocument(String filePath) {
        Document document;
        File file = new File(filePath);
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            document = null;
        }
        return document;
    }

    public static String getTargetID(Document doc, String buildConfiguration) {
        try {
            String query = String.format("//*/configuration[@name='%s']//*/option[@superClass='sbi.gnu.cpp.compiler.option']", buildConfiguration);
            Node superClassNode = (Node)xpath.evaluate(query, doc, XPathConstants.NODE);
            NodeList list = superClassNode.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!"listOptionValue".equals(node.getNodeName())) continue;
                Node valueNode = node.getAttributes().getNamedItem("value");
                String targetID = valueNode.getNodeValue();
                return targetID;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return null;
    }

    public static String getProjectName(Document doc) {
        try {
            String query = "//projectDescription/name";
            NodeList nameNodeList = (NodeList)xpath.evaluate(query, doc, XPathConstants.NODESET);
            if (nameNodeList.item(0) != null) {
                return nameNodeList.item(0).getTextContent();
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getPackageName(Document doc) {
        if (doc == null) {
            return null;
        }
        try {
            String query = "//manifest";
            Node manifestNode = (Node)xpath.evaluate(query, doc, XPathConstants.NODE);
            String packageName = manifestNode.getAttributes().getNamedItem("package").getTextContent();
            return packageName;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getVersion(Document doc) {
        if (doc == null) {
            return null;
        }
        try {
            String query = "//manifest";
            Node manifestNode = (Node)xpath.evaluate(query, doc, XPathConstants.NODE);
            String versionName = manifestNode.getAttributes().getNamedItem("version").getTextContent();
            return versionName;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getArtifactName(Document doc) {
        if (doc == null) {
            return null;
        }
        try {
            String query = "//@exec";
            String artifactName = (String)xpath.evaluate(query, doc, XPathConstants.STRING);
            return artifactName;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String[] getQueriedStringList(Document doc, String query) {
        if (doc == null) {
            return null;
        }
        NodeList nodeList = XMLUtil.getDOMNodesNS((Document)doc, (String)query);
        if (nodeList == null) {
            return new String[0];
        }
        String[] nodes = new String[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) == null) {
                nodes[i] = null;
                continue;
            }
            try {
                nodes[i] = nodeList.item(i).getTextContent();
                continue;
            }
            catch (DOMException e) {
                nodes[i] = null;
            }
        }
        return nodes;
    }

    private static String[] trimStringArray(String[] stringArray) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string == null || string == "") continue;
            stringList.add(string);
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public static String[] getUIAppIdList(Document doc) {
        return NativeProject.getQueriedStringList(doc, "/:manifest/:ui-application/@appid");
    }

    public static String[] getServiceAppIdList(Document doc) {
        return NativeProject.getQueriedStringList(doc, "/:manifest/:service-application/@appid");
    }

    public static String[] getWatchAppIdList(Document doc) {
        return NativeProject.getQueriedStringList(doc, "/:manifest/:watch-application/@appid");
    }

    public static String[] getWidgetAppIdList(Document doc) {
        return NativeProject.getQueriedStringList(doc, "/:manifest/:widget-application/@appid");
    }

    public static String[] getAppTypeList(Document doc) {
        return NativeProject.getQueriedStringList(doc, "/:manifest/:ui-application/@type");
    }

    public static boolean isUIAppLication(Document doc) {
        return NativeProject.getUIAppIdList(doc).length > 0;
    }

    public static boolean isServiceAppLication(Document doc) {
        return NativeProject.getServiceAppIdList(doc).length > 0;
    }

    public static boolean isWatchAppLication(Document doc) {
        return NativeProject.getWatchAppIdList(doc).length > 0;
    }

    public static boolean isWidgetAppLication(Document doc) {
        return NativeProject.getWidgetAppIdList(doc).length > 0;
    }

    public static boolean isDotnetApplication(Document doc) {
        String[] typeList = NativeProject.getAppTypeList(doc);
        return typeList.length == 1 && typeList[0] != "dotnet";
    }

    public static boolean isStandalone(Document doc) {
        int appCnt = 0;
        appCnt += NativeProject.getUIAppIdList(doc).length;
        appCnt += NativeProject.getServiceAppIdList(doc).length;
        appCnt += NativeProject.getWatchAppIdList(doc).length;
        return (appCnt += NativeProject.getWidgetAppIdList(doc).length) == 1;
    }
}

