/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.file.DirectoryCopyHandlingCommand;
import org.tizen.common.core.command.prompter.FileHandlingOption;
import org.tizen.common.core.command.zip.ZipCommand;
import org.tizen.common.util.FileUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.packages.NativeProject;
import org.tizen.ncli.subcommands.packages.PackageCSCLICommandData;
import org.tizen.ncli.subcommands.sign.SignCLICommand;
import org.w3c.dom.Document;

public class PackageCSCLICommand
extends AbstractSubCommand<PackageCSCLICommandData> {
    private PackageCSCLICommandData data = new PackageCSCLICommandData();
    private static final String EXCLUDE_LIB_PATH = "tools" + File.separator + "ide" + File.separator + "resources" + File.separator + "csharp" + File.separator + "exclude";
    private String profileName;
    private String projectPath;
    private String outputPath;
    private String outputType;
    private String configuration = null;
    private List<String> copySrcList = new ArrayList<String>();
    private List<String> copyDesList = new ArrayList<String>();
    private List<String> excludeList = new ArrayList<String>();

    @Override
    protected PackageCSCLICommandData call() {
        String exeName;
        File workingDir = this.getWorkingDir();
        String projPath = this.getProjectPath();
        String packagePath = FileUtil.appendPath((String)workingDir.getPath(), (String)"packaging");
        String packageBinPath = FileUtil.appendPath((String)packagePath, (String)"bin");
        String publishPath = FileUtil.appendPath((String)workingDir.getPath(), (String)"publish");
        if (!new File(publishPath).exists()) {
            publishPath = workingDir.getPath();
        }
        if ((exeName = this.getArtifactName(projPath)) == null) {
            this.progressLog.error("Failed to get executable name from manifest file");
            return null;
        }
        String pkgName = null;
        if (exeName.contains(".exe")) {
            pkgName = exeName.replace(".exe", ".tpk");
        } else if (exeName.contains(".dll")) {
            pkgName = exeName.replace(".dll", ".tpk");
        }
        if (pkgName == null) {
            this.progressLog.error("Failed to get packaage name from manifest file");
            return null;
        }
        this.excludeList.add(pkgName);
        new File(packagePath).mkdir();
        new File(packageBinPath).mkdir();
        this.getExcludeLibLists();
        this.checkCopyBinDirItems(publishPath, packageBinPath, exeName);
        this.checkCopyResourceItems(projPath, packagePath);
        this.checkCopyLibraryItems(publishPath, FileUtil.appendPath((String)packagePath, (String)"lib"));
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(this.copySrcList, this.copyDesList);
        dirCopyCmd.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
        executor.execute(new Command[]{dirCopyCmd});
        this.signPackage(packagePath);
        String tpkDir = workingDir.getAbsolutePath();
        if (this.outputPath != null && !this.outputPath.isEmpty()) {
            String realoutputPath = this.outputPath.startsWith(".") ? FileUtil.appendPath((String)projPath, (String)this.outputPath) : this.outputPath;
            this.log.debug("Output Path: " + realoutputPath.toString());
            tpkDir = new File(realoutputPath).getAbsolutePath();
        }
        this.zipPackage(FileUtil.appendPath((String)tpkDir, (String)pkgName), packagePath);
        return this.data;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProjectPath(String projDir) {
        this.projectPath = projDir;
        this.data.setProjectDir(projDir);
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getExcludeLibLists() {
        String sdkPath = InstallPathConfig.getSDKPath();
        if (sdkPath == null) {
            this.log.debug("Cannot get SDKPath for csharp packaging.");
            return;
        }
        String excludePath = FileUtil.appendPath((String)sdkPath, (String)EXCLUDE_LIB_PATH);
        File libListFiles = new File(excludePath);
        String[] files = libListFiles.list();
        if (files == null) {
            this.log.debug("Cannot find the exclude library list files.");
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            BufferedReader in = null;
            try {
                String s;
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(FileUtil.appendPath((String)excludePath, (String)files[i])), "UTF-8");
                in = new BufferedReader(isr);
                while ((s = in.readLine()) != null) {
                    this.excludeList.add(s);
                }
                continue;
            }
            catch (IOException e) {
                this.log.debug("IOException while using input stream." + files[i]);
                continue;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.log.debug("IOException while closing input stream." + files[i]);
                    }
                }
            }
        }
    }

    private String getArtifactName(String projPath) {
        File manifest = new File(projPath, "tizen-manifest.xml");
        if (!manifest.exists()) {
            this.progressLog.warn("Cannot find the manifest file : {}", (Object)manifest.getPath());
            return null;
        }
        Document tizenManifestDoc = XMLUtil.readXML((File)manifest);
        if (tizenManifestDoc == null) {
            this.progressLog.warn("Cannot read the manifest file : {}", (Object)manifest.getPath());
            return null;
        }
        return NativeProject.getArtifactName(tizenManifestDoc);
    }

    private void checkCopyBinDirItems(String srcpath, String dstpath, String exeName) {
        String pdbName = exeName.replace(".exe", ".pdb");
        String dllName = exeName.replace(".exe", ".dll");
        File exeFile = new File(FileUtil.appendPath((String)srcpath, (String)exeName));
        if (exeFile.exists()) {
            this.copySrcList.add(FileUtil.appendPath((String)srcpath, (String)exeName));
            this.copyDesList.add(FileUtil.appendPath((String)dstpath, (String)exeName));
        } else {
            this.copySrcList.add(FileUtil.appendPath((String)srcpath, (String)dllName));
            if (this.outputType != null && this.outputType.compareToIgnoreCase("exe") == 0) {
                this.copyDesList.add(FileUtil.appendPath((String)dstpath, (String)exeName));
            } else {
                this.copyDesList.add(FileUtil.appendPath((String)dstpath, (String)dllName));
            }
        }
        if (this.configuration.equals("Debug")) {
            this.copySrcList.add(FileUtil.appendPath((String)srcpath, (String)pdbName));
            this.copyDesList.add(FileUtil.appendPath((String)dstpath, (String)pdbName));
        }
        this.excludeList.add(exeName);
        this.excludeList.add(dllName);
        this.excludeList.add(pdbName);
    }

    private void checkCopyResourceItems(String srcpath, String dstpath) {
        this.copySrcList.add(FileUtil.appendPath((String)srcpath, (String)"res"));
        this.copyDesList.add(FileUtil.appendPath((String)dstpath, (String)"res"));
        this.copySrcList.add(FileUtil.appendPath((String)srcpath, (String)"shared"));
        this.copyDesList.add(FileUtil.appendPath((String)dstpath, (String)"shared"));
        this.copySrcList.add(FileUtil.appendPath((String)srcpath, (String)"lib"));
        this.copyDesList.add(FileUtil.appendPath((String)dstpath, (String)"lib"));
        this.copySrcList.add(FileUtil.appendPath((String)srcpath, (String)"tizen-manifest.xml"));
        this.copyDesList.add(FileUtil.appendPath((String)dstpath, (String)"tizen-manifest.xml"));
    }

    private void checkCopyLibraryItems(String srcpath, String dstpath) {
        this.excludeList.add("build.info");
        this.excludeList.add("packaging");
        this.excludeList.add("runtimes");
        this.excludeList.add("publish");
        String[] libList = new File(srcpath).list();
        for (int i = 0; i < libList.length; ++i) {
            if (this.excludeList.contains(libList[i])) continue;
            this.copySrcList.add(FileUtil.appendPath((String)srcpath, (String)libList[i]));
            this.copyDesList.add(FileUtil.appendPath((String)dstpath, (String)libList[i]));
        }
    }

    private void signPackage(String packagePath) {
        SignCLICommand signCmd = new SignCLICommand();
        signCmd.setWorkingDir(new File(packagePath));
        String sign = this.getProfileName();
        if (sign != null && !sign.isEmpty()) {
            signCmd.setProfileName(sign);
        } else {
            signCmd.setUseDefaultCertificate(true);
        }
        signCmd.runCommand();
    }

    private void zipPackage(String tpkPath, String packageDir) {
        File pkgPath = new File(tpkPath);
        if (pkgPath.exists()) {
            pkgPath.delete();
        }
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        ZipCommand zipCmd = new ZipCommand(packageDir, pkgPath.getAbsolutePath());
        zipCmd.setExcludes(new String[]{".manifest.tmp"});
        executor.execute(new Command[]{zipCmd});
        this.data.setTpkPath(pkgPath.getAbsolutePath());
    }
}

