/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.file.AbstractFileHandler;
import org.tizen.common.file.FileHandler;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;

public class VirtualFileHandler
extends AbstractFileHandler {
    protected static final String ROOT_PREFIX = "/";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Directory root = new Directory();
    protected String cwd = "/";

    protected File getFile(String path) {
        this.logger.trace("Path :{}", (Object)path);
        if (path == null) {
            return null;
        }
        String[] fragments = FilenameUtil.getCanonicalFragments(path);
        File iter = this.root;
        int i = 0;
        int n = fragments.length;
        while (i < n) {
            Directory dir = iter;
            if ((iter = dir.get(fragments[i])) == null) {
                this.logger.debug("fragment :{}", (Object)fragments[i]);
                this.logger.debug("in-processing directory :{}", (Object)dir);
                return null;
            }
            ++i;
        }
        return iter;
    }

    public Directory getParent(String path) throws IOException {
        File parent = this.getFile(FilenameUtil.removeTailingPath(path, 1));
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof Directory)) {
            throw new IOException();
        }
        return (Directory)parent;
    }

    @Override
    public void makeDirectory(String path) throws IOException {
        this.logger.debug("Making directory : {}", (Object)path);
        Directory parent = this.getParent(path);
        String dirName = FilenameUtil.getFilename(path);
        if (parent.name2file.containsKey(dirName)) {
            throw new IOException();
        }
        parent.add(dirName);
    }

    @Override
    public void moveDirectory(String source, String target) throws IOException {
        String filename = FilenameUtil.getFilename(source);
        Directory parent = this.getParent(source);
        File file = parent.get(filename);
        if (!(file instanceof Directory)) {
            throw new IOException();
        }
        Directory newParent = (Directory)this.getFile(target);
        newParent.add(newParent.remove(filename));
    }

    @Override
    public void copyDirectory(String source, String target) throws IOException {
        Directory dir = (Directory)this.getFile(source);
        Directory targetDir = (Directory)this.getFile(target);
        targetDir.add((File)dir.clone());
    }

    @Override
    public void removeDirectory(String path) throws IOException {
        Directory dir = this.getParent(path);
        String name = FilenameUtil.getFilename(path);
        dir.remove(name);
    }

    @Override
    public Collection<String> list(String path) throws IOException {
        Directory dir = (Directory)this.getFile(path);
        Set<String> childNames = dir.name2file.keySet();
        this.logger.trace("Directory[{}]'s child :{}", (Object)path, childNames);
        ArrayList<String> fullNames = new ArrayList<String>();
        for (String name : dir.name2file.keySet()) {
            fullNames.add(FilenameUtil.addTailingPath(path, name));
        }
        this.logger.debug("Fullnames :\n{}", fullNames);
        return fullNames;
    }

    @Override
    public void write(String path, InputStream in) throws IOException {
        Directory parent = this.getParent(path);
        if (parent == null) {
            this.makeDirectory(FilenameUtil.removeTailingPath(path, 1), true);
            parent = this.getParent(path);
        }
        String filename = FilenameUtil.getFilename(path);
        this.logger.debug("Filename :{}", (Object)filename);
        File file = parent.get(filename);
        if (file == null) {
            file = new File(FilenameUtil.getFilename(path), null);
        }
        if (file instanceof Directory) {
            throw new IOException();
        }
        this.getParent(path).add(file);
        byte[] contents = IOUtil.getBytes(in);
        if (this.logger.isTraceEnabled()) {
            int nSize = ArrayUtil.size(contents);
            this.logger.trace("Save file[{}] :{} byte(s)\n{}", new Object[]{path, nSize, String.valueOf(StringUtil.text2hexa(contents, 0, Math.min(64, ArrayUtil.size(contents)))) + (64 < ArrayUtil.size(contents) ? "..." : "")});
        }
        file.setContents(contents);
    }

    public void write(String path, String contents) throws IOException {
        this.logger.trace("Save file :{}\n{}", (Object)path, (Object)contents);
        ByteArrayInputStream in = new ByteArrayInputStream(contents == null ? new byte[]{} : contents.getBytes());
        try {
            this.write(path, in);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(in);
            throw throwable;
        }
        IOUtil.tryClose(in);
    }

    @Override
    public InputStream read(String path) throws IOException {
        this.logger.trace("Read {}", (Object)path);
        File file = this.getFile(path);
        if (file instanceof Directory) {
            throw new IOException();
        }
        return new ByteArrayInputStream(file.contents);
    }

    @Override
    public void moveFile(String source, String target) throws IOException {
        String fileName;
        Directory directory = this.getParent(source);
        File file = directory.remove(fileName = FilenameUtil.getFilename(source));
        if (file == null) {
            throw new IOException();
        }
        Directory targetDirectory = (Directory)this.getFile(target);
        targetDirectory.add(file);
    }

    @Override
    public void copyFile(String source, String target) throws IOException {
        String fileName;
        Directory directory = this.getParent(source);
        File file = directory.get(fileName = FilenameUtil.getFilename(source));
        if (file == null) {
            throw new IOException();
        }
        Directory targetDirectory = (Directory)this.getFile(target);
        targetDirectory.add((File)file.clone());
    }

    @Override
    public void removeFile(String path) throws IOException {
        File file = this.getFile(path);
        if (file instanceof Directory) {
            throw new IOException();
        }
        Directory directory = this.getParent(path);
        String fileName = FilenameUtil.getFilename(path);
        directory.remove(fileName);
    }

    @Override
    public Object get(String path, FileHandler.Attribute name) throws IOException {
        this.logger.trace("Path :{}, Name :{}", (Object)path, (Object)name);
        File file = this.getFile(path);
        if (FileHandler.Attribute.TYPE.equals((Object)name)) {
            if (file instanceof Directory) {
                return FileHandler.Type.DIRECTORY;
            }
            return FileHandler.Type.FILE;
        }
        if (FileHandler.Attribute.EXISTS.equals((Object)name)) {
            if (file != null) {
                return true;
            }
            return false;
        }
        if (FileHandler.Attribute.SIZE.equals((Object)name)) {
            if (file == null || file.getContents() == null) {
                return 0L;
            }
            return (long)file.getContents().length;
        }
        if (FileHandler.Attribute.PATH.equals((Object)name)) {
            if (path.startsWith(ROOT_PREFIX)) {
                return FilenameUtil.getCanonicalForm(path);
            }
            return FilenameUtil.getCanonicalForm(FilenameUtil.addTailingPath(this.cwd, path));
        }
        if (FileHandler.Attribute.NAME.equals((Object)name)) {
            return FilenameUtil.getFilename(path);
        }
        if (FileHandler.Attribute.URI.equals((Object)name) || FileHandler.Attribute.URL.equals((Object)name)) {
            return "vf://" + path;
        }
        file.getAttribute(name);
        return false;
    }

    @Override
    public void set(String path, FileHandler.Attribute name, Object value) throws IOException {
        File file = this.getFile(path);
        if (file != null) {
            file.setAttribute(name, value);
        }
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return this.cwd;
    }

    @Override
    public void setCurrentWorkingDirectory(String cwd) {
        this.cwd = cwd;
        this.logger.info("CWD changed :{}", (Object)this.cwd);
    }

    class Directory
    extends File
    implements Cloneable {
        protected final HashMap<String, File> name2file;

        public Directory() {
            this.name2file = new HashMap();
        }

        public Directory(String name) {
            super(name, null);
            this.name2file = new HashMap();
        }

        public File get(String name) {
            return this.name2file.get(name);
        }

        public File remove(String name) {
            return this.name2file.remove(name);
        }

        public void add(String name, byte[] contents) {
            this.name2file.put(name, new File(name, contents));
        }

        public void add(String name) {
            this.name2file.put(name, new Directory(name));
        }

        public void add(File file) {
            this.name2file.put(file.getName(), file);
        }

        @Override
        public Object clone() {
            Directory dir = new Directory();
            dir.contents = this.contents;
            dir.name = this.name;
            for (String name : this.name2file.keySet()) {
                this.name2file.put(name, (File)this.name2file.get(name).clone());
            }
            return dir;
        }

        public String toString() {
            return this.name2file.keySet().toString();
        }
    }

    private class File
    implements Cloneable {
        String name;
        byte[] contents;
        HashMap<FileHandler.Attribute, Object> attr = new HashMap();

        public File() {
        }

        public File(String name, byte[] contents) {
            this.name = name;
            this.contents = contents;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getContents() {
            return this.contents;
        }

        public void setContents(byte[] contents) {
            this.contents = contents;
        }

        public void setAttribute(FileHandler.Attribute name, Object value) {
            this.attr.put(name, value);
        }

        public Object getAttribute(FileHandler.Attribute name) {
            return this.attr.get((Object)name);
        }

        public Object clone() {
            File file = new File();
            file.name = this.name;
            file.contents = this.contents;
            return file;
        }
    }
}

