/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.target;

import java.io.IOException;
import org.tizen.common.util.FileUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.PackageInfo;
import org.tizen.sdblib.service.ApplicationCmdService;

public class SdbAppCmdAPI {
    private ApplicationCmdService absCmdServ = null;

    public SdbAppCmdAPI(IDevice target) {
        if (target != null) {
            this.absCmdServ = target.getApplicationCmdService();
        }
    }

    public boolean isAvailable() {
        return this.absCmdServ != null;
    }

    public boolean installPackage(String packagePath, String packageTepPath, IShellOutputReceiver receiver) throws IOException {
        String ext = FileUtil.getFileExtension((String)packagePath);
        ApplicationCmdService.PackageType type = this.extToType(ext);
        if (receiver == null) {
            return this.absCmdServ.installPackage(type, packagePath, null, packageTepPath);
        }
        return this.absCmdServ.installPackage(type, packagePath, null, packageTepPath, receiver);
    }

    public boolean uninstallPackage(String packageID, IShellOutputReceiver receiver) throws IOException {
        if (receiver == null) {
            return this.absCmdServ.uninstallPackage(packageID);
        }
        return this.absCmdServ.uninstallPackage(packageID, receiver);
    }

    public boolean runPackage(String packageID, IShellOutputReceiver receiver) throws IOException {
        PackageInfo pkgInfo = this.absCmdServ.queryPackageInfo(packageID);
        ApplicationCmdService.PackageType type = ApplicationCmdService.PackageType.UnknownPkg;
        String appID = packageID;
        if (pkgInfo != null) {
            type = pkgInfo.getPkgType();
            appID = pkgInfo.getMainAppID();
        }
        if (type == ApplicationCmdService.PackageType.NativePkg) {
            if (receiver == null) {
                this.absCmdServ.killApplication(appID);
            } else {
                this.absCmdServ.killApplication(appID, receiver);
            }
        }
        if (receiver == null) {
            return this.absCmdServ.runApplication(appID);
        }
        return this.absCmdServ.runApplication(appID, receiver);
    }

    public ApplicationCmdService.PackageType extToType(String ext) {
        switch (ext) {
            case "wgt": {
                return ApplicationCmdService.PackageType.WebPkg;
            }
            case "tpk": {
                return ApplicationCmdService.PackageType.NativePkg;
            }
        }
        return ApplicationCmdService.PackageType.UnknownPkg;
    }
}

