/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.listnative;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.createnative.CreateNativeProjectCommandData;
import org.tizen.ncli.subcommands.createnative.NativeProjectInfo;
import org.tizen.ncli.subcommands.listnative.ListNativeProject;
import org.tizen.ncli.subcommands.listnative.ProfileCompare;

public class ListNativeProjectCLICommand
extends AbstractSubCommand<ListNativeProject> {
    private final String VIEW_FORMAT = "%-20s %s";
    private final String TITLE_FORMAT = String.format("%-20s %s", "[PROFILE]", "[TEMPLATE]");

    @Override
    protected ListNativeProject call() {
        Map<NativeProjectInfo, String> nativeProjectMap = CreateNativeProjectCommandData.getTemplateListFromAllProfile();
        ListNativeProject list = new ListNativeProject();
        if (nativeProjectMap != null && !nativeProjectMap.isEmpty()) {
            this.progressLog.info(this.TITLE_FORMAT);
            Set<NativeProjectInfo> nativeProjectInfoSet = nativeProjectMap.keySet();
            ArrayList<NativeProjectInfo> nativeProjectList = new ArrayList<NativeProjectInfo>(nativeProjectInfoSet);
            Collections.sort(nativeProjectList, new ProfileCompare());
            for (NativeProjectInfo info : nativeProjectList) {
                String projectInfo = String.format("%-20s %s", info.getProfileName(), info.getTemplateId());
                this.progressLog.info(projectInfo);
            }
        } else {
            this.progressLog.error("Not Found Native templates");
            throw new UnexpectedException(2, "Not Found Native templates");
        }
        return list;
    }
}

