/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.File;
import java.io.FileNotFoundException;
import org.kohsuke.args4j.Option;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractSecurityProfileCLI;

@TizenSubCommand(name="set-active", usage="Set the specified security profile to active.")
public class SecurityProfileSetActiveCLI
extends AbstractSecurityProfileCLI {
    @Option(name="-n", aliases={"--name"}, required=true, metaVar="<profile name>", usage="Set the profile name. (Required)")
    private String name;

    @Override
    public int execute() {
        int result = 0;
        this.log.trace("Begin SecurityProfileSetActiveCLI...");
        this.trace();
        File file = this.getProfileXMLFile();
        if (file == null) {
            this.progressLog.error("Not exist the default path of security profiles.");
            return 2;
        }
        SigningProfileContainer container = null;
        try {
            container = this.readXML(file);
            this.log.trace("Read XML: {} profile found.", (Object)container.getProfiles().size());
            if (!this.activateProfile(container)) {
                this.progressLog.error("There is no '{}' profile in security profiles. Please check the profile list by 'tizen security-profiles list' command.", (Object)this.name);
                return 2;
            }
            this.writeXML(container, file);
            this.progressLog.info("Succeed to set '{}' profile as active.", (Object)this.name);
        }
        catch (FileNotFoundException e) {
            this.progressLog.error("Not found a file of security profiles. Please check specified path.");
            return 2;
        }
        catch (UnexpectedException e) {
            throw e;
        }
        this.log.trace("Finish SecurityProfileSetActiveCLI...");
        return result;
    }

    private void trace() {
        this.log.trace("[Argument] name: {}", (Object)this.name);
    }

    private boolean activateProfile(SigningProfileContainer container) {
        SigningProfile profile = container.getProfileByName(this.name);
        if (profile == null) {
            return false;
        }
        container.setActiveProfile(profile);
        return true;
    }
}

