/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.util.SWTUtil;

public class ViewUtil {
    public static void showView(String id, boolean sync) {
        ViewRunnable runnable = new ViewRunnable(id);
        if (sync) {
            SWTUtil.syncExec(runnable);
        } else {
            SWTUtil.asyncExec(runnable);
        }
    }

    public static IViewPart getView(String id) {
        return ViewUtil.getView(id, true);
    }

    public static IViewPart getView(String id, boolean show) {
        IWorkbenchWindow window = ViewUtil.getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage activeWorkbenchPage = window.getActivePage();
        if (activeWorkbenchPage == null) {
            return null;
        }
        IViewPart view = activeWorkbenchPage.findView(id);
        if (view != null && show) {
            ViewUtil.showView(id, true);
        }
        return view;
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        if (workbench.getWorkbenchWindowCount() == 0) {
            return null;
        }
        return workbench.getWorkbenchWindows()[0];
    }

    static class ViewRunnable
    implements Runnable {
        String id;

        public ViewRunnable(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = ViewUtil.getWorkbenchWindow();
            if (window == null) {
                return;
            }
            try {
                window.getActivePage().showView(this.id);
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("showView failed: " + e.getMessage()));
            }
        }
    }
}

