/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdb.command;

import java.io.IOException;
import org.tizen.sdb.command.Command;
import org.tizen.sdb.command.receiver.OutputReceiver;

public class Install
extends Command {
    public Install() {
        this("install");
    }

    protected Install(String command) {
        super(command);
    }

    protected void setParameter(String pkgPath, String tepPath, String packageID, String extractPath, boolean incremental, boolean debug, boolean onlyunzip) {
        if (pkgPath != null && !pkgPath.isEmpty()) {
            this.addParameter("-p");
            this.addParameter(pkgPath);
        }
        if (tepPath != null && !tepPath.isEmpty()) {
            this.addParameter("-t");
            this.addParameter(tepPath);
        }
        if (extractPath != null && !extractPath.isEmpty()) {
            this.addParameter("--extract-tar");
            this.addParameter(extractPath);
        }
        if (incremental || onlyunzip) {
            if (incremental) {
                this.addParameter("--incremental");
            } else {
                this.addParameter("--incremental-unziponly");
            }
            if (packageID != null && !packageID.isEmpty()) {
                this.addParameter(packageID);
            }
        } else if (packageID != null && !packageID.isEmpty()) {
            this.addParameter("--reinstall");
            this.addParameter(packageID);
        }
        if (debug) {
            this.addParameter("--debug");
        }
    }

    public void installPackage(String pkgPath, boolean debug, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter(pkgPath, null, null, null, false, debug, false);
        this.execute(deviceSerial, receiver);
    }

    public void installPackageWithTep(String pkgPath, String tepPath, boolean debug, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter(pkgPath, tepPath, null, null, false, debug, false);
        this.execute(deviceSerial, receiver);
    }

    public void installPackageWithRDS(String pkgPath, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter(pkgPath, null, null, null, true, false, false);
        this.execute(deviceSerial, receiver);
    }

    public void installPackageWithRDS(String pkgPath, String packageID, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter(pkgPath, null, packageID, null, true, false, false);
        this.execute(deviceSerial, receiver);
    }

    public void unzipPackage(String pkgPath, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter(pkgPath, null, null, null, false, false, true);
        this.execute(deviceSerial, receiver);
    }

    public void unzipPackage(String pkgPath, String packageID, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter(pkgPath, null, packageID, null, false, false, true);
        this.execute(deviceSerial, receiver);
    }

    public void extractTarPackage(String pkgPath, String extractPath, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter(pkgPath, null, null, extractPath, false, false, false);
        this.execute(deviceSerial, receiver);
    }

    public void reinstallPackage(String packageID, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter(null, null, packageID, null, false, false, false);
        this.execute(deviceSerial, receiver);
    }
}

