/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.builder.error;

import org.tizen.common.builder.error.Location;
import org.tizen.common.util.Assert;

public class BuildErrorInfo {
    private Location location;
    private int severity;
    private String message;
    public static final int SEVERITY_ERROR = 2;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_INFO = 0;

    public BuildErrorInfo(Location location, int severity, String message) {
        Assert.notNull((Object)location);
        Assert.notNull((Object)severity);
        Assert.notNull((Object)message);
        this.location = location;
        this.severity = severity;
        this.message = message;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        switch (this.getSeverity()) {
            case 2: {
                sb.append("ERROR");
                break;
            }
            case 1: {
                sb.append("WARNING");
                break;
            }
            case 0: {
                sb.append("INFO");
                break;
            }
        }
        sb.append("] ");
        sb.append(this.location.toString());
        sb.append(" - ");
        sb.append(this.getMessage());
        return sb.toString();
    }
}

