/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createcsharp;

import java.io.File;
import java.time.Year;
import java.util.HashMap;
import java.util.Map;
import org.tizen.common.util.FileUtil;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.createcsharp.CSSolutionInfo;
import org.tizen.ncli.subcommands.createcsharp.CSTemplateInfo;
import org.tizen.ncli.subcommands.createcsharp.CreateCSProjectCommandData;
import org.tizen.ncli.subcommands.createcsharp.VSTemplateParser;

public class CreateCSProjectCommand
extends AbstractSubCommand<CreateCSProjectCommandData> {
    public CreateCSProjectCommandData data = new CreateCSProjectCommandData();

    public CreateCSProjectCommandData getData() {
        return this.data;
    }

    @Override
    protected CreateCSProjectCommandData call() {
        CSSolutionInfo solution;
        Map<String, CSTemplateInfo> csTemplates = CreateCSProjectCommandData.getTemplateList();
        if (csTemplates == null || csTemplates.size() == 0) {
            this.progressLog.error("No templates found");
            throw new UnexpectedException(2, "No templates found");
        }
        CSTemplateInfo templateInfo = csTemplates.get(this.data.getTemplateName());
        if (templateInfo == null) {
            this.progressLog.error("The template is not found");
            throw new UnexpectedException(2, "The template is not found");
        }
        VSTemplateParser vParser = new VSTemplateParser(templateInfo.getVstemplateFile());
        if (!vParser.parse()) {
            this.progressLog.error("Failed to parse vstemplate file");
            throw new UnexpectedException(2, "Failed to parse vstemplate file");
        }
        Map<String, String> symbols = this.makeSymbolDictionary();
        if (!this.copyCSProjectTemplate(vParser, templateInfo, symbols, solution = new CSSolutionInfo())) {
            this.progressLog.error("Failed to create C# project");
            throw new UnexpectedException(2, "Failed to create C# project");
        }
        String solutionFile = FileUtil.appendPath((String)this.data.getOutputName(), (String)(this.data.getProjectName() + ".sln"));
        if (!solution.makeSolutionFile(solutionFile)) {
            String errorMsg = String.format("Failed to create '%s' solution file", templateInfo.getTemplateTitle());
            this.progressLog.error(errorMsg);
            throw new UnexpectedException(2, errorMsg);
        }
        return this.data;
    }

    private Map<String, String> makeSymbolDictionary() {
        HashMap<String, String> symbols = new HashMap<String, String>();
        symbols.put("$projectname$", this.data.getProjectName());
        symbols.put("$safeprojectname$", VSTemplateParser.makeSafeProjectName(this.data.getProjectName()));
        symbols.put("$year$", String.valueOf(Year.now().getValue()));
        return symbols;
    }

    private boolean copyCSProjectTemplate(VSTemplateParser vParser, CSTemplateInfo templateInfo, Map<String, String> symbols, CSSolutionInfo solution) {
        String templatePath = templateInfo.getTemplatePath();
        if (templatePath == null) {
            String errormsg = String.format("Wrong template path for '%s' template", templateInfo.getTemplateTitle());
            this.progressLog.error(errormsg);
            return false;
        }
        File templatePathFile = new File(templatePath);
        if (templatePathFile == null || !templatePathFile.exists()) {
            String errormsg = String.format("Wrong template path for '%s' template", templateInfo.getTemplateTitle());
            this.progressLog.error(errormsg);
            return false;
        }
        String destDir = this.data.getOutputName();
        File destDirFile = new File(destDir);
        if (destDirFile.exists()) {
            this.progressLog.error(String.format("'%s' already exists", destDir));
            return false;
        }
        destDirFile.mkdir();
        String solutionDir = FileUtil.appendPath((String)destDir, (String)this.data.getProjectName());
        File slnDir = new File(solutionDir);
        slnDir.mkdir();
        int ret = vParser.copyFiles(solutionDir, symbols, solution);
        if (ret < 0) {
            this.progressLog.error(String.format("Failed to copy '%s' template files ", templateInfo.getTemplateTitle()));
            return false;
        }
        return true;
    }
}

