/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createcsharp;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.tizen.ncli.subcommands.createcsharp.CSTemplateInfo;

public class CreateCSProjectCommandData {
    private static final String CSHARP_TEMPLATE_PATH = "cs-templates";
    private static final String TIZEN_CS_TEMPLATE_FILE = ".+\\.vstemplate";
    private String templateName = "";
    private String projectName = "";
    private String outputName = "";
    private String projectType;
    private static Map<String, CSTemplateInfo> csTemplates = new HashMap<String, CSTemplateInfo>();

    public static Map<String, CSTemplateInfo> getTemplateList() {
        return csTemplates;
    }

    private static void initializeTemplateList() {
        csTemplates.clear();
        String cliToolPath = FileUtil.appendPath((String)InstallPathConfig.getToolsPath(), (String)"ide");
        File root = new File(FileUtil.appendPath((String)cliToolPath, (String)CSHARP_TEMPLATE_PATH));
        List<File> fileArray = null;
        try {
            fileArray = CreateCSProjectCommandData.findVSTemplates(root);
        }
        catch (FileNotFoundException e) {
            return;
        }
        for (File templatefile : fileArray) {
            File parentDir = templatefile.getParentFile();
            if (parentDir == null || csTemplates.containsKey(parentDir.getName())) continue;
            String templateName = parentDir.getName();
            if (templateName == null || templateName.isEmpty()) {
                templateName = templatefile.getName();
            }
            CSTemplateInfo templateInfo = new CSTemplateInfo(templateName, parentDir.getAbsolutePath(), templatefile.getAbsolutePath());
            csTemplates.put(templateName, templateInfo);
        }
    }

    private static List<File> findVSTemplates(File root) throws FileNotFoundException {
        if (!root.exists()) {
            throw new FileNotFoundException(root.getPath() + "does not exist!");
        }
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = root.listFiles();
        if (null == filesAndDirs) {
            return result;
        }
        for (File file : filesAndDirs) {
            File tfile;
            if (!file.isDirectory() || (tfile = CreateCSProjectCommandData.getVSTemplateFile(file)) == null) continue;
            result.add(tfile);
        }
        return result;
    }

    private static File getVSTemplateFile(File dir) {
        File[] filesAndDirs = dir.listFiles();
        if (filesAndDirs == null) {
            return null;
        }
        for (File file : filesAndDirs) {
            String name = file.getName();
            if (!name.matches(TIZEN_CS_TEMPLATE_FILE) || !file.isFile()) continue;
            return file;
        }
        return null;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    static {
        CreateCSProjectCommandData.initializeTemplateList();
    }
}

