/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.trustanchor;

import java.io.File;
import java.util.ArrayList;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;

@TizenSubCommand(name="delete", usage="Delete a trust-anchor user certificates.")
public class TrustAnchorDeleteCLI
extends AbstractCLI {
    @Option(name="-c", aliases={"--user-certificate-path"}, required=true, usage="Specify the user certificate path.")
    private String certPath = null;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public int execute() {
        File certFile;
        File projectPath = this.getRealWorkingPath();
        this.log.trace("getRealWorkingPath for trust-anchor add: {}", (Object)projectPath.toString());
        String trustAnchorPath = null;
        File manifestFile = new File(projectPath.getAbsolutePath(), "tizen-manifest.xml");
        File configFile = new File(projectPath.getAbsolutePath(), "config.xml");
        if (manifestFile != null && manifestFile.exists()) {
            trustAnchorPath = projectPath + File.separator + "res" + File.separator + ".trust-anchor";
        } else if (configFile != null && configFile.exists()) {
            trustAnchorPath = projectPath + File.separator + ".trust-anchor";
        } else {
            this.progressLog.error("Please input the valid Tizen project.");
            this.log.error("Please input the valid Tizen project.");
            return -1;
        }
        String[] certPaths = this.certPath.split(",");
        ArrayList<String> deleteList = new ArrayList<String>();
        for (String fileName : certPaths) {
            certFile = new File(trustAnchorPath + File.separator + fileName);
            if (!certFile.exists() || !certFile.isFile()) {
                this.progressLog.warn("Invalid user certificate file {}", (Object)fileName);
                this.log.error("Invalid user certificate file {}", (Object)fileName);
                continue;
            }
            deleteList.add(certFile.getAbsolutePath());
        }
        String[] totalCertFiles = new File(trustAnchorPath).list();
        if (totalCertFiles == null) {
            this.progressLog.error("Cannot delete the certificate files");
            this.log.error("Cannot delete the certificate files");
            return -1;
        }
        if (totalCertFiles.length > deleteList.size()) {
            String certListStr = "Succeed to delete the certificates ";
            for (String fileName : deleteList) {
                certFile = new File(fileName);
                certFile.delete();
                certListStr = certListStr + certFile.getName() + ", ";
            }
            this.progressLog.info(certListStr.substring(0, certListStr.length() - 2));
        } else {
            this.progressLog.info("Cannot delete the specified files, because there will not be remained the certificate file after deleting.");
        }
        return 0;
    }
}

