/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSCLICommand;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSData;

@TizenSubCommand(name="build-cs", usage="Build a C# project.")
public class BuildCSCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-C", aliases={"--configuration"}, metaVar="{Debug|Release}", usage="Specify the build configuration. (Debug is default)")
    private String configuration;
    @Option(name="-s", aliases={"--sign"}, metaVar="<security profile>", usage="Specify the security profile name.")
    private String sign;

    @Override
    public int execute() {
        int result = -1;
        this.log.trace("Execute BuildCSCLI...");
        BuildCSCLICommand command = new BuildCSCLICommand();
        command.setWorkingDir(this.getRealWorkingPath());
        command.setRequiredOptions(new String[]{this.configuration});
        command.setProfileName(this.sign);
        BuildCSData data = (BuildCSData)command.runCommand();
        if (data != null) {
            this.progressLog.info("Output path : {} (binary:{})", (Object)data.getOutputPath(), (Object)data.getExecName());
            result = data.getExitCode();
        }
        return result;
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

