/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildcs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.tizen.common.util.IOUtil;

public class BuildCSData {
    private String appName;
    private String appId;
    private String appType;
    private String execName;
    private String packageName;
    private String config;
    private String profileName;
    private String profileVersion;
    private String type;
    private String workingDir;
    public boolean hasRequiredOptions = true;
    private String outputPath;
    private String projectPath;
    protected List<String> predefineOptions;
    protected int jobs;
    private Set<String> csProjects = null;
    private int exitCode = -1;

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public String getExecName() {
        return this.execName;
    }

    public void setExecName(String execName) {
        this.execName = execName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfile(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(String profileVersion) {
        this.profileVersion = profileVersion;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setProfileFullName(String profileFullName) {
        if (profileFullName == null || profileFullName.isEmpty()) {
            this.profileName = null;
            this.profileVersion = null;
            return;
        }
        String[] s = profileFullName.split("-");
        if (s.length > 0) {
            if (s.length >= 1) {
                this.profileName = s[0];
            }
            if (s.length >= 2) {
                this.profileVersion = s[1];
            }
        }
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public List<String> getPredefineOptions() {
        return this.predefineOptions;
    }

    public void setPredefineOptions(List<String> predefineOptions) {
        this.predefineOptions = predefineOptions;
    }

    public int getJobs() {
        return this.jobs;
    }

    public void setJobs(int jobs) {
        this.jobs = jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuildInfo(String buildInfoPath, String projectPath) {
        File propFile;
        Properties props = new Properties();
        if (this.config != null) {
            props.put("config", this.config);
        }
        if (this.type != null) {
            props.put("type", this.type);
        }
        if (projectPath != null) {
            props.put("project-path", projectPath);
        }
        if ((propFile = new File(buildInfoPath)).exists()) {
            propFile.delete();
        }
        try {
            propFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(buildInfoPath);
            props.store(outStream, "Build information");
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{outStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{outStream});
            return;
        }
        IOUtil.tryClose((Object[])new Object[]{outStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readBuildInfo(String buildInfoPath, Logger log) {
        File buildInfoFile = new File(buildInfoPath);
        if (!buildInfoFile.exists()) {
            return false;
        }
        FileInputStream inStream = null;
        Properties props = new Properties();
        try {
            inStream = new FileInputStream(buildInfoFile);
            props.load(inStream);
        }
        catch (IOException e) {
            boolean bl;
            try {
                e.printStackTrace();
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{inStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{inStream});
            return bl;
        }
        IOUtil.tryClose((Object[])new Object[]{inStream});
        this.config = props.getProperty("config");
        this.type = props.getProperty("type");
        this.projectPath = props.getProperty("project-path");
        return true;
    }

    public Set<String> getCsProjects() {
        return this.csProjects;
    }

    public void setCsProjects(Set<String> csProjects) {
        this.csProjects = csProjects;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }
}

