/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.Executor;
import org.tizen.common.sign.command.ReadSigningProfileFileCommand;
import org.tizen.common.sign.command.SignCommand;
import org.tizen.common.sign.preferences.DefaultSigningProfile;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.sign.Sign;

public class SignCLICommand
extends AbstractSubCommand<Sign> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Configuration config = new Configuration();
    private String profilesPath;
    private String profileName;
    private boolean useDefaultCertificate = false;

    @Override
    protected Sign call() {
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        SigningProfile profile = this.getSigningProfile(executor);
        if (profile == null) {
            return null;
        }
        for (int i = 0; i <= 2; ++i) {
            SigningProfileItem item = profile.getProfileItem(i);
            if (item == null || StringUtil.isEmpty((CharSequence)item.getKeyLocation())) continue;
            String msg = i == 0 ? "Author certficate: " : "Distributor" + i + " certificate : ";
            System.out.println(msg + item.getKeyLocation());
        }
        SignCommand command = new SignCommand(this.workingDir.getAbsolutePath(), profile);
        command.setIncludes(null);
        command.setExcludes(this.getDefaultExcludes());
        if (new File(this.workingDir, "res/res.xml").exists()) {
            command.setSlicingMode(true);
        }
        executor.execute(new Command[]{command});
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SigningProfile getSigningProfile(Executor executor) {
        String pname = null;
        this.setProfilesPath();
        boolean validProfile = this.validateProfilesPath();
        if (validProfile) {
            pname = this.getActiveProfileName();
        }
        if (this.useDefaultCertificate) {
            if (pname == null) {
                this.progressLog.warn(TizenCLIMessages.SIGN_DEFAULT_PROFILE_WARN);
                return new DefaultSigningProfile();
            }
            this.progressLog.info(TizenCLIMessages.SIGN_USE_ACTIVE_PROFILE);
        } else if (this.profileName == null || this.profileName.isEmpty()) {
            if (pname == null) {
                this.progressLog.error("There is no signing profile. Please use '--sign' option.");
                return null;
            }
        } else {
            if (!validProfile) {
                this.progressLog.error(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)this.profileName));
                return null;
            }
            pname = this.profileName;
        }
        if (pname != null) {
            ReadSigningProfileFileCommand readProfile = new ReadSigningProfileFileCommand(this.profilesPath, pname);
            executor.execute(new Command[]{readProfile});
            this.log.info("Profiles file[{}] is read", (Object)this.profilesPath);
            return readProfile.getProfile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getActiveProfileName() {
        String string;
        SigningProfileContainer container = new SigningProfileContainer();
        InputStream in = null;
        try {
            in = new FileInputStream(this.profilesPath);
            in = new BufferedInputStream(in);
            container.readProfileXML(in);
            string = container.getActiveProfileName();
        }
        catch (FileNotFoundException e) {
            String string2;
            try {
                this.log.error("Exception occurred.", (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{in});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{in});
            return string2;
        }
        IOUtil.tryClose((Object[])new Object[]{in});
        return string;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public void setUseDefaultCertificate(boolean useDefaultCertificate) {
        this.useDefaultCertificate = useDefaultCertificate;
    }

    private void setProfilesPath() {
        this.profilesPath = this.config.getValue("profiles.path");
        if (this.profilesPath == null) {
            this.profilesPath = this.config.getValue("default.profiles.path");
        }
    }

    private boolean validateProfilesPath() {
        boolean result = false;
        if (this.profilesPath != null) {
            File profiles = new File(this.profilesPath);
            if (profiles.exists()) {
                result = true;
            } else {
                System.out.println(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)this.profilesPath));
            }
        } else {
            System.out.println(TizenCLIMessages.SIGN_NO_CONFIG_PROFILES);
        }
        return result;
    }

    protected String[] getDefaultExcludes() {
        return new String[]{".manifest.tmp", ".delta.lst"};
    }
}

