/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.tizen.common.ITizenProject;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.util.ProjectUtil;

public class TizenPackageInfoStore {
    private IProject project;
    private final List<PackageResourceInfo> resInfoList;
    private final List<PackageResourceInfo> invisibleResInfoList;
    private List<PackageResourceInfo> defaultBlackList = new ArrayList<PackageResourceInfo>();

    public TizenPackageInfoStore(IProject project) {
        this(project, null, null);
    }

    public TizenPackageInfoStore(IProject project, List<PackageResourceInfo> resInfoList, List<PackageResourceInfo> invisibleResInfoList) {
        this.project = project;
        this.resInfoList = resInfoList != null ? resInfoList : new ArrayList<PackageResourceInfo>();
        this.invisibleResInfoList = invisibleResInfoList != null ? invisibleResInfoList : new ArrayList<PackageResourceInfo>();
    }

    public List<PackageResourceInfo> getRequirementRes() {
        ArrayList<PackageResourceInfo> requirementResInfo = new ArrayList<PackageResourceInfo>();
        for (PackageResourceInfo resInfo : this.resInfoList) {
            if (!resInfo.isRequirement()) continue;
            requirementResInfo.add(resInfo);
        }
        for (PackageResourceInfo resInfo : this.invisibleResInfoList) {
            if (!resInfo.isRequirement()) continue;
            requirementResInfo.add(resInfo);
        }
        return requirementResInfo;
    }

    public List<PackageResourceInfo> getPackageRes() {
        return this.resInfoList;
    }

    public List<PackageResourceInfo> getInvisiblePkgRes() {
        return this.invisibleResInfoList;
    }

    public List<PackageResourceInfo> getBlackList() {
        ITizenProject tizenProject = ProjectUtil.getTizenProject(this.project);
        TizenProjectDescription tizenDesc = tizenProject.getDescription();
        return tizenDesc.getBlacklist();
    }

    public List<PackageResourceInfo> getDefaultBlackList() {
        return this.defaultBlackList;
    }

    public List<PackageResourceInfo> getExcludeList() {
        ArrayList<PackageResourceInfo> excludeList = new ArrayList<PackageResourceInfo>();
        ITizenProject tizenProject = ProjectUtil.getTizenProject(this.project);
        TizenProjectDescription tizenDesc = tizenProject.getDescription();
        for (PackageResourceInfo blackListItem : tizenDesc.getBlacklist()) {
            excludeList.addAll(blackListItem.getExcludeList());
        }
        return excludeList;
    }

    public Map<String, String> getIncludeMap() {
        return new HashMap<String, String>();
    }

    public List<DeltaResourceInfo> getInterestList() {
        ArrayList<DeltaResourceInfo> interestList = new ArrayList<DeltaResourceInfo>();
        return interestList;
    }

    public List<DeltaResourceInfo> getIgnoreList() {
        ArrayList<DeltaResourceInfo> ignoreList = new ArrayList<DeltaResourceInfo>();
        return ignoreList;
    }

    public IProject getProject() {
        return this.project;
    }

    public List<PackageResourceInfo> getResInfoList() {
        return this.resInfoList;
    }
}

