/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdb.command;

import java.io.IOException;
import org.tizen.sdb.command.Command;
import org.tizen.sdb.command.receiver.OutputReceiver;

public class Dlog
extends Command {
    public static final String DLOG_FORMAT_BRIEF = "brief";
    public static final String DLOG_FORMAT_PROCESS = "process";
    public static final String DLOG_FORMAT_TAG = "tag";
    public static final String DLOG_FORMAT_THREAD = "thread";
    public static final String DLOG_FORMAT_RAW = "raw";
    public static final String DLOG_FORMAT_TIME = "time";
    public static final String DLOG_FORMAT_THREADTIME = "threadtime";
    public static final String DLOG_FORMAT_KERNELTIME = "kerneltime";
    public static final String DLOG_FORMAT_LONG = "long";
    public static final String DLOG_FORMAT_REV_REALTIME = "recv_realtime";
    public static final String DLOG_FORMAT_RWTIME = "rwtime";

    public Dlog() {
        this("dlog");
    }

    protected Dlog(String command) {
        super(command);
    }

    public void clear(String deviceSerial) throws IOException {
        this.addParameter("-c");
        this.execute(deviceSerial, null);
    }

    public boolean isPlatformLogOn(String deviceSerial) throws IOException {
        this.addParameter("-k");
        this.addParameter("plog");
        this.addParameter("-g");
        this.execute(deviceSerial, null);
        return Integer.parseInt(this.getResponse().getResult()) > 0;
    }

    public void setPlatformLogOnOff(String deviceSerial, boolean logOn) throws IOException {
        this.addParameter("-k");
        this.addParameter("plog");
        this.addParameter("-s");
        this.addParameter(logOn ? "1" : "0");
        this.execute(deviceSerial, null);
    }

    public void run(String deviceSerial, String format, String filter, String filename, int count, int kbyte, OutputReceiver receiver) throws IOException {
        if (format != null && !format.isEmpty()) {
            this.addParameter("-v");
            this.addParameter(format);
        }
        if (filename != null && !filename.isEmpty()) {
            this.addParameter("-f");
            this.addParameter(filename);
        }
        if (count > 0 || kbyte > 0) {
            if (filename != null && !filename.isEmpty() && count > 0 && kbyte > 0) {
                this.addParameter("-n");
                this.addParameter(Integer.toString(count));
                this.addParameter("-r");
                this.addParameter(Integer.toString(kbyte));
            } else {
                throw new IOException("invalid argument");
            }
        }
        if (filter != null && !filter.isEmpty()) {
            this.addParameter(filter);
        }
        this.execute(deviceSerial, receiver);
    }
}

