/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.SocketChannel;
import org.tizen.sdblib.SdbHelper;
import org.tizen.sdblib.SdbResponse;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.SmartDevelopmentBridgetConstants;
import org.tizen.sdblib.exception.SyncException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.SyncServiceReturnCode;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.ByteUtil;
import org.tizen.sdblib.util.Log;

public class FileEntryOutputStream
extends OutputStream {
    protected final FileEntry entry;
    protected final int timeOut;
    protected final byte[] buffer = new byte[65544];
    protected int index = 8;
    protected final SocketChannel channel;

    public FileEntryOutputStream(FileEntry entry, int timeOut) throws IOException {
        Assert.notNull(entry);
        this.entry = entry;
        this.timeOut = timeOut;
        this.channel = SmartDevelopmentBridge.getBridge().openChannel();
        this.channel.configureBlocking(true);
        SdbHelper.initializeDevice(this.channel, this.entry.getDevice().getSerialNumber());
        byte[] request = SdbHelper.formSdbRequest("sync:");
        SdbHelper.write(this.channel, request);
        SdbResponse resp = SdbHelper.readSdbResponse(this.channel);
        if (!resp.okay) {
            Log.w("sdb", "Got unhappy response from sdb sync req: " + resp.message);
            this.channel.close();
            throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_ERROR);
        }
        byte[] remotePath = SdbHelper.string2bytes(this.entry.getFullPath());
        try {
            if (1024 < remotePath.length) {
                throw new SyncException(SyncServiceReturnCode.RESULT_REMOTE_PATH_LENGTH);
            }
            byte[] msg = FileEntryOutputStream.createSendFileReq(SmartDevelopmentBridgetConstants.ID_SEND, remotePath, 493);
            if (msg != null) {
                SdbHelper.write(this.channel, msg, -1, timeOut);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SyncException(SyncServiceReturnCode.RESULT_REMOTE_PATH_ENCODING, (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_TIMEOUT, (Throwable)e);
        }
        catch (IOException e) {
            throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Throwable)e);
        }
        System.arraycopy(SmartDevelopmentBridgetConstants.ID_DATA, 0, this.buffer, 0, SmartDevelopmentBridgetConstants.ID_DATA.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer.length <= this.index) {
            this.flush();
        }
        this.buffer[this.index++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
        Log.d("sync", "flush " + System.currentTimeMillis());
        if (this.index <= 8) {
            return;
        }
        ByteUtil.toBytes(this.index - 8, this.buffer, 4);
        try {
            SdbHelper.write(this.channel, this.buffer, this.index, this.timeOut);
        }
        catch (TimeoutException e) {
            throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_TIMEOUT, (Throwable)e);
        }
        catch (IOException e) {
            throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Throwable)e);
        }
        this.index = 8;
        Log.d("sync", "flushd " + System.currentTimeMillis());
        super.flush();
    }

    private static byte[] createSendFileReq(byte[] command, byte[] path, int mode) {
        String modeStr = "," + (mode & 0x1FF);
        try {
            byte[] modeContent = modeStr.getBytes("ISO-8859-1");
            byte[] array = new byte[8 + path.length + modeContent.length];
            System.arraycopy(command, 0, array, 0, 4);
            ByteUtil.toBytes(path.length + modeContent.length, array, 4);
            System.arraycopy(path, 0, array, 8, path.length);
            System.arraycopy(modeContent, 0, array, 8 + path.length, modeContent.length);
            return array;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static byte[] createReq(byte[] command, int value) {
        byte[] array = new byte[8];
        System.arraycopy(command, 0, array, 0, 4);
        ByteUtil.toBytes(value, array, 4);
        return array;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        long time = System.currentTimeMillis() / 1000L;
        SdbHelper.write(this.channel, FileEntryOutputStream.createReq(SmartDevelopmentBridgetConstants.ID_DONE, (int)time), -1, this.timeOut);
        byte[] result = new byte[8];
        SdbHelper.read(this.channel, result, -1, this.timeOut);
        if (!SdbHelper.check(result, 0, SmartDevelopmentBridgetConstants.ID_OKAY, 0, 4)) {
            if (SdbHelper.check(result, 0, SmartDevelopmentBridgetConstants.ID_FAIL, 0, 4)) {
                int len = ByteUtil.fromBytes(result, 4);
                SdbHelper.read(this.channel, this.buffer, len, this.timeOut);
                String message = new String(this.buffer, 0, len);
                Log.e("sdb", "transfer error: " + message);
                throw new SyncException(SyncServiceReturnCode.RESULT_UNKNOWN_ERROR, message);
            }
            throw new SyncException(SyncServiceReturnCode.RESULT_UNKNOWN_ERROR);
        }
        SdbHelper.write(this.channel, FileEntryOutputStream.createReq(SmartDevelopmentBridgetConstants.ID_QUIT, 0));
        this.channel.close();
        super.close();
    }
}

