/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildapp;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.Version;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.zip.ZipCommand;
import org.tizen.common.core.web.BuildWebParameter;
import org.tizen.common.core.web.TextProgressMonitor;
import org.tizen.core.gputil.PathUtil;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.BuildMethodData;
import org.tizen.ncli.subcommands.build.buildapp.BuildAppData;
import org.tizen.ncli.subcommands.build.buildapp.BuildScriptData;
import org.tizen.ncli.subcommands.build.buildapp.BuildScriptFileParser;
import org.tizen.ncli.subcommands.build.buildapp.BuildScriptParamParser;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeCommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeData;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeMethodData;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeOption;
import org.tizen.ncli.subcommands.build.buildweb.BuildWebCLICommand;
import org.tizen.ncli.subcommands.build.buildweb.BuildWebCommand;
import org.tizen.ncli.subcommands.build.buildweb.BuildWebMethodData;
import org.tizen.ncli.subcommands.packages.PackageData;
import org.tizen.ncli.subcommands.packages.PackageNativeCLICommand;
import org.tizen.ncli.subcommands.packages.PackageProject;
import org.tizen.ncli.subcommands.packages.PackageValidator;
import org.tizen.ncli.subcommands.sign.SignCLICommand;
import org.tizen.ncli.util.DirectoryUtil;
import org.tizen.sbilib.for_cli.SBIProcess;
import org.tizen.sbilib.for_cli.sbiplugin.SBIPluginManager;
import org.tizen.ssilib.SSIData;
import org.tizen.ssilib.SSIMacro;
import org.tizen.ssilib.SSIProcess;
import org.tizen.ssilib.SSITargetType;

public class BuildAppCLICommand
extends AbstractSubCommand<BuildAppData> {
    private String workspacePath;
    private BuildAppData data;
    private String scriptPath;
    private String sign;
    private String outputPath;
    private String[] targetDesc;
    private String[] methodDesc;
    private String[] buildDesc;
    private String[] packageDesc;
    private Map<String, String> macros = new HashMap<String, String>();
    private static int globalBuildOrder = 0;
    private SBIProcess sbi0 = null;

    public BuildAppCLICommand() {
        this.data = new BuildAppData();
    }

    private boolean setCommandArgs() {
        boolean result = true;
        String sdkPath = InstallPathConfig.getSDKPath();
        if (sdkPath == null) {
            this.log.debug("Cannot get SDKPath");
            result = false;
        } else {
            this.data.setSdkPath(sdkPath);
            this.data.setSbiHomePath(sdkPath + File.separator + BuildNativeOption.SBI_HOME_PATH);
        }
        return result;
    }

    private boolean isNativeProject(String projPath) {
        return BuildNativeCommand.validateProject(projPath);
    }

    private boolean isWebProject(String projPath) {
        File projFile = new File(projPath);
        if (!new File(projFile, ".tproject").exists()) {
            return false;
        }
        return new File(projFile, "config.xml").exists();
    }

    private int buildAllForPackage(PackageTargetData pkgData, List<BuildTargetData> completeTargetList) {
        for (Map.Entry<BuildConfigData, List<BuildTargetData>> config : pkgData.configMap.entrySet()) {
            List<BuildTargetData> builds = config.getValue();
            Collections.sort(builds, new Comparator<BuildTargetData>(){

                @Override
                public int compare(BuildTargetData arg0, BuildTargetData arg1) {
                    return Integer.compare(arg0.buildOrder, arg1.buildOrder);
                }
            });
            for (BuildTargetData build : builds) {
                if (completeTargetList != null && completeTargetList.contains(build)) continue;
                if (build.projType.equals("native")) {
                    BuildNativeData result = BuildNativeCommand.build(build.sbi, build.buildMethod, build.projPath, false, build.output, pkgData.workspacePath, this.progressLog);
                    if (result == null) {
                        return -1;
                    }
                    BuildNativeCommand.writeBuildInfo(build.projPath, result.getOutputPath(), result);
                    build.resultPath = result.getOutputPath();
                }
                if (completeTargetList == null) continue;
                completeTargetList.add(build);
            }
        }
        for (String buildTarget : pkgData.projectList) {
            BuildTargetData build = pkgData.projectMap.get(buildTarget);
            if (completeTargetList != null && completeTargetList.contains(build) || !build.projType.equals("web")) continue;
            BuildWebCLICommand command = new BuildWebCLICommand();
            command.setWorkingDir(new File(build.projPath));
            command.setOutputName(build.output);
            command.setProgressMonitor(new TextProgressMonitor(new PrintWriter(System.out)));
            BuildWebParameter commandData = (BuildWebParameter)command.runCommand();
            if (commandData != null) {
                build.resultPath = commandData.getOutputName();
            }
            if (completeTargetList == null) continue;
            completeTargetList.add(build);
        }
        return 0;
    }

    private int buildAll(List<BuildTargetData> targetList, String workspacePath, List<BuildTargetData> completeTargetList) {
        if (targetList == null) {
            return -1;
        }
        for (BuildTargetData build : targetList) {
            if (completeTargetList != null && completeTargetList.contains(build)) continue;
            if (build.projType.equals("native")) {
                BuildNativeData result = BuildNativeCommand.build(build.sbi, build.buildMethod, build.projPath, false, build.output, workspacePath, this.progressLog);
                if (result == null) {
                    return -1;
                }
                BuildNativeCommand.writeBuildInfo(build.projPath, result.getOutputPath(), result);
                build.resultPath = result.getOutputPath();
                if (completeTargetList == null) continue;
                completeTargetList.add(build);
                continue;
            }
            if (!build.projType.equals("web")) continue;
            BuildWebCLICommand command = new BuildWebCLICommand();
            command.setWorkingDir(new File(build.projPath));
            command.setOutputName(build.output);
            command.setProgressMonitor(new TextProgressMonitor(new PrintWriter(System.out)));
            BuildWebParameter commandData = (BuildWebParameter)command.runCommand();
            if (commandData != null) {
                build.resultPath = commandData.getOutputName();
            }
            if (completeTargetList == null) continue;
            completeTargetList.add(build);
        }
        return 0;
    }

    private List<BuildMethodData> mergeBuildMethodList(BuildMethodData baseBuildMethod, List<BuildMethodData> buildMethods) {
        ArrayList<BuildMethodData> list = new ArrayList<BuildMethodData>();
        for (BuildMethodData buildMethod : buildMethods) {
            BuildMethodData method = new BuildMethodData(baseBuildMethod);
            method.merge(buildMethod);
            list.add(method);
        }
        return list;
    }

    private List<BuildMethodData> mergeBuildMethodList(List<BuildMethodData> baseBuildMethods, List<BuildMethodData> buildMethods) {
        ArrayList<BuildMethodData> list = new ArrayList<BuildMethodData>();
        if (baseBuildMethods != null) {
            if (buildMethods != null) {
                for (BuildMethodData buildMethod : baseBuildMethods) {
                    List<BuildMethodData> lst = this.mergeBuildMethodList(buildMethod, buildMethods);
                    list.addAll(lst);
                }
            } else {
                list.addAll(baseBuildMethods);
            }
        } else if (buildMethods != null) {
            list.addAll(buildMethods);
        }
        return list;
    }

    private BuildScriptData.BuildEntry mergeBuild(BuildScriptData.BuildEntry baseBuild, BuildScriptData.BuildEntry build, boolean overwriteName) {
        BuildScriptData.BuildEntry newBuild = null;
        if (baseBuild != null) {
            if (build != null) {
                newBuild = new BuildScriptData.BuildEntry(baseBuild.getName(), baseBuild.getTargetList(), baseBuild.getBuildMethodList(), baseBuild.getArchitecture(), baseBuild.getOutputPath());
                if (overwriteName && build.getName() != null && !build.getName().isEmpty()) {
                    newBuild.setName(build.getName());
                }
                if (build.getTargetList() != null && !build.getTargetList().isEmpty()) {
                    newBuild.addTargetProjectAll(build.getTargetList());
                }
                if (build.getBuildMethodList() != null && !build.getBuildMethodList().isEmpty()) {
                    newBuild.addBuildMethodAll(build.getBuildMethodList());
                }
                if (build.getArchitecture() != null && !build.getArchitecture().isEmpty()) {
                    newBuild.setArchitecture(build.getArchitecture());
                }
                if (build.getOutputPath() != null && !build.getOutputPath().isEmpty()) {
                    newBuild.setOutputPath(build.getOutputPath());
                }
            } else {
                newBuild = baseBuild;
            }
        } else if (build != null) {
            newBuild = build;
        }
        return newBuild;
    }

    private List<BuildMethodData> convBuildMethodList(BuildScriptData.BuildMethodEntry buildMethodEntry) {
        List<Object> configList;
        if (buildMethodEntry == null) {
            return null;
        }
        ArrayList<BuildMethodData> methodList = new ArrayList<BuildMethodData>();
        if (buildMethodEntry.getBuildConfigs() != null && !buildMethodEntry.getBuildConfigs().isEmpty()) {
            configList = buildMethodEntry.getBuildConfigs();
        } else {
            configList = new ArrayList<Object>();
            configList.add(null);
        }
        for (String string : configList) {
            if (buildMethodEntry.getRootstrapList() != null && !buildMethodEntry.getRootstrapList().isEmpty()) {
                for (BuildScriptData.BuildMethodEntry.Rootstrap rootstrap : buildMethodEntry.getRootstrapList()) {
                    BuildMethodData method = new BuildMethodData();
                    method.setToolchain(buildMethodEntry.getToolchain());
                    method.setBuildConfig(string);
                    method.setRootstrapName(rootstrap.id);
                    method.setProfileFullName(rootstrap.platform);
                    method.setArchitecture(rootstrap.arch);
                    method.setPredefineOptions(buildMethodEntry.getPredefines());
                    methodList.add(method);
                }
                continue;
            }
            BuildMethodData method = new BuildMethodData();
            method.setToolchain(buildMethodEntry.getToolchain());
            method.setBuildConfig(string);
            method.setPredefineOptions(buildMethodEntry.getPredefines());
            if (method.isEmpty()) continue;
            methodList.add(method);
        }
        return !methodList.isEmpty() ? methodList : null;
    }

    private List<BuildProjectListItem> makeBuildProjectList(int order, String projectName, String buildName, BuildScriptData buildScriptData, Map<String, BuildScriptData.BuildEntry> finalBuildMap, String workspacePath) {
        String projTypeDetail;
        int type;
        boolean validate;
        String projType;
        String projPath;
        ArrayList<BuildProjectListItem> buildResult = new ArrayList<BuildProjectListItem>();
        BuildScriptData.ProjectEntry project = buildScriptData.getProjectEntry(projectName);
        List<String> prdefines = null;
        int idx = 0;
        if (project != null) {
            if (project.getDependencies() != null) {
                for (String nextProj : project.getDependencies()) {
                    List<BuildProjectListItem> r = this.makeBuildProjectList(order + idx + 1, nextProj, buildName, buildScriptData, finalBuildMap, workspacePath);
                    if (r == null) {
                        return null;
                    }
                    if (r == null || r.isEmpty()) continue;
                    for (BuildProjectListItem rr : r) {
                        if (buildResult.contains(rr)) continue;
                        buildResult.add(rr);
                        ++idx;
                    }
                }
            }
            projPath = project.getProjectPath();
            projType = project.getType();
            validate = project.getValidate();
            prdefines = project.getPredefines();
            type = 0;
        } else {
            projPath = projectName;
            projType = null;
            validate = false;
            prdefines = null;
            type = 1;
        }
        String projFullPath = PathUtil.getFullPath((String)workspacePath, (String)projPath);
        if (!new File(projFullPath).exists()) {
            return null;
        }
        String defProfile = null;
        String defProfileVer = null;
        String defArch = null;
        if (this.isNativeProject(projFullPath)) {
            BuildNativeData buildData = BuildNativeCommand.analisysProjectInfo(projFullPath);
            projTypeDetail = "native/" + buildData.getSbiType();
            if (buildData.getSbiAppType() != null) {
                projTypeDetail = projTypeDetail + "/" + buildData.getSbiAppType();
            }
            defProfile = buildData.getSbiProfile();
            defProfileVer = buildData.getSbiProfileVersion();
            defArch = buildData.getSbiArchitecture();
        } else if (this.isWebProject(projFullPath)) {
            BuildWebMethodData webMethod = BuildWebCommand.prepareBuildMethod(projFullPath);
            projTypeDetail = "web";
            if (webMethod.getAppType() != null) {
                projTypeDetail = projTypeDetail + "/" + webMethod.getAppType();
            }
        } else {
            projTypeDetail = null;
        }
        if (validate && projTypeDetail != null && projType != null) {
            String[] orgTypes = projTypeDetail.split("/");
            String[] projTypes = projType.split("/");
            if (!PackageValidator.matchType(projTypes, orgTypes)) {
                this.log.error("Wrong project type. desc:{}, target:{}", (Object)projType, (Object)projTypeDetail);
                return null;
            }
        }
        buildResult.add(new BuildProjectListItem(order, idx, type, projPath, projTypeDetail, defProfile, defProfileVer, defArch, buildName, prdefines, projFullPath));
        return buildResult;
    }

    private List<BuildProjectListItem> makeBuildProjectList(BuildScriptData buildScriptData, String buildName, Map<String, BuildScriptData.BuildEntry> finalBuildMap, String workspacePath, int idx) {
        ArrayList<BuildProjectListItem> buildResult = new ArrayList<BuildProjectListItem>();
        BuildScriptData.BuildEntry build = null;
        if (finalBuildMap != null) {
            build = finalBuildMap.get(buildName);
        }
        if (build != null) {
            List<String> targetList2;
            List<String> targetList = build.getTargetList();
            if (targetList == null) {
                return null;
            }
            if (targetList.size() == 1 && targetList.get(0).equals("*")) {
                if (buildScriptData.getProjects() == null || buildScriptData.getProjects().isEmpty()) {
                    return null;
                }
                targetList2 = buildScriptData.genAllProjectNames();
            } else {
                targetList2 = targetList;
            }
            if (targetList2 == null) {
                return null;
            }
            for (String target : targetList2) {
                BuildNativeData data2 = new BuildNativeData();
                data2.setSbiToolchain(this.data.getSbiToolchain());
                List<BuildProjectListItem> r = this.makeBuildProjectList(idx, target, buildName, buildScriptData, finalBuildMap, workspacePath);
                if (r == null) {
                    return null;
                }
                if (r == null || r.isEmpty()) continue;
                buildResult.addAll(r);
                idx = buildResult.size();
            }
        } else {
            List<BuildProjectListItem> r = this.makeBuildProjectList(idx, buildName, null, buildScriptData, finalBuildMap, workspacePath);
            if (r == null) {
                return null;
            }
            if (r != null && !r.isEmpty()) {
                buildResult.addAll(r);
                idx = buildResult.size();
            }
        }
        return buildResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<BuildProjectListItem> makeBuildProjectListAll(BuildScriptData buildScriptData, List<String> buildNames, Map<String, BuildScriptData.BuildEntry> finalBuildMap, String workspacePath) {
        List<String> buildNames2;
        ArrayList<BuildProjectListItem> buildResult = new ArrayList<BuildProjectListItem>();
        if (buildNames.size() == 1 && buildNames.get(0).equals("*")) {
            if (buildScriptData.getBuilds() != null && buildScriptData.getBuilds().isEmpty()) {
                buildNames2 = buildScriptData.genAllBuildNames();
            } else {
                if (buildScriptData.getBuilds() == null || !buildScriptData.getBuilds().isEmpty()) return null;
                buildNames2 = buildScriptData.genAllProjectNames();
            }
        } else {
            buildNames2 = buildNames;
        }
        int idx = 0;
        for (String buildName : buildNames2) {
            List<BuildProjectListItem> r = this.makeBuildProjectList(buildScriptData, buildName, finalBuildMap, workspacePath, idx);
            if (r == null) {
                return null;
            }
            buildResult.addAll(r);
            idx += r.size();
        }
        return buildResult;
    }

    private BuildTargetData makeFinalBuildTargetForNative(SBIPluginManager sbiPlugins, String sdkPath, String workspacePath, List<String> predefines, String baseOutputPath, String projPath, String projFullPath, String projType, int order, int buildOrder, String buildScriptPath, int jobs, BuildMethodData method) {
        SBIProcess sbi2 = null;
        String buildScriptFullPath = null;
        if (buildScriptPath != null) {
            buildScriptFullPath = PathUtil.getFullPath((String)workspacePath, (String)buildScriptPath);
            sbi2 = BuildNativeCommand.genSBIProcess(sbiPlugins, buildScriptFullPath, projFullPath);
        }
        if (sbi2 == null) {
            if (this.sbi0 == null) {
                this.sbi0 = BuildNativeCommand.genDefSBIProcess(sbiPlugins, sdkPath);
            }
            sbi2 = this.sbi0;
        }
        if (sbi2 == null) {
            return null;
        }
        BuildNativeMethodData nativeMethod = BuildNativeCommand.prepareBuildMethod(sbi2, method, null, projFullPath);
        if (nativeMethod == null) {
            return null;
        }
        nativeMethod.setPredefineOptions(predefines);
        nativeMethod.setJobs(jobs);
        nativeMethod.setBuildScriptPath(buildScriptFullPath);
        String outputFullPath = baseOutputPath != null ? PathUtil.getFullPath((String)baseOutputPath, (String)this.outputPath) : PathUtil.getFullPath((String)projFullPath, (String)this.outputPath);
        String extPath = nativeMethod.getBuildConfig();
        if ((baseOutputPath != null || this.outputPath != null) && nativeMethod.getAppName() != null) {
            extPath = nativeMethod.getAppName() + File.separator + extPath;
        }
        if (!extPath.isEmpty()) {
            outputFullPath = outputFullPath + File.separator + extPath;
        }
        BuildTargetData r = new BuildTargetData();
        r.projPath = projFullPath;
        r.projType = "native";
        r.projTypeDetail = projType;
        r.platform = nativeMethod.getProfileName() + "-" + nativeMethod.getProfileVersion();
        r.arch = nativeMethod.getArchitecture();
        r.config = nativeMethod.getBuildConfig();
        r.output = outputFullPath;
        r.order = order;
        r.buildOrder = buildOrder;
        r.buildMethod = nativeMethod;
        r.sbi = sbi2;
        return r;
    }

    private BuildTargetData makeFinalBuildTargetForWeb(String baseOutputPath, String projFullPath, String projType, int order, int buildOrder) {
        String outputFullPath = baseOutputPath != null ? PathUtil.getFullPath((String)baseOutputPath, (String)this.outputPath) : PathUtil.getFullPath((String)projFullPath, (String)this.outputPath);
        String extPath = ".buildResult";
        if (baseOutputPath != null || this.outputPath != null) {
            extPath = new File(projFullPath).getName() + File.separator + extPath;
        }
        outputFullPath = outputFullPath + File.separator + extPath;
        BuildTargetData r = new BuildTargetData();
        r.projPath = projFullPath;
        r.projType = "web";
        r.projTypeDetail = projType;
        r.output = outputFullPath;
        r.order = order;
        r.buildOrder = buildOrder;
        r.buildMethod = null;
        return r;
    }

    private boolean preprocValidator(PackageValidator validator, String sdkPath, Logger log) {
        boolean result = false;
        File ssiConfFile = new File(this.workspacePath + "/Build/Validator.xml");
        if (ssiConfFile.exists()) {
            result = validator.load(ssiConfFile, "1.0");
        }
        if (!result && (ssiConfFile = new File(sdkPath, "tools/ide/resources/common/Build/Validator.xml")).exists()) {
            result = validator.load(ssiConfFile);
        }
        return result;
    }

    private boolean preprocSSI(SSIProcess ssi, SSIData data, String sdkPath, Logger log) {
        boolean result = false;
        File ssiConfFile = new File(this.workspacePath, "Build/SSI.xml");
        if (ssiConfFile.exists() && (result = ssi.analisysPackageScript(ssiConfFile, data, "1.0"))) {
            ssi.setHomePath(this.workspacePath + "/Build");
        }
        if (!result && (ssiConfFile = new File(sdkPath, "tools/ide/resources/common/Build/SSI.xml")).exists() && (result = ssi.analisysPackageScript(ssiConfFile, data))) {
            ssi.setHomePath(sdkPath + "/tools/ide/resources/common/Build");
        }
        return result;
    }

    private void processSSI(SSIProcess ssi, List<SSITargetType> targets, String pkgType, SSIData data, String sdkPath, String sign, String outputFilePath, Logger log) {
        Version version;
        this.preprocSSI(ssi, data, sdkPath, log);
        if (targets == null || targets.isEmpty()) {
            return;
        }
        boolean needEmptyDirectory = true;
        String profileVersion = (String)data.getProperty("profile.version");
        if (profileVersion != null && (version = new Version(profileVersion)).isSameOrBiggerThanVersion3()) {
            needEmptyDirectory = false;
        }
        ssi.getGlobalMacros().put("__PARAM2__", needEmptyDirectory ? "mandatory" : "strip");
        File tempFile = null;
        try {
            tempFile = DirectoryUtil.createTempDirectory();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        String format = ssi.getStructureFormat(pkgType);
        ssi.procStructuring(pkgType, targets.toArray(new SSITargetType[targets.size()]), tempFile.toString(), log);
        if (sign != null && !sign.isEmpty()) {
            File tmp = new File(tempFile, ".manifest.tmp");
            if (tmp.exists()) {
                tmp.delete();
            }
            SignCLICommand signCmd = new SignCLICommand();
            signCmd.setWorkingDir(tempFile);
            signCmd.setProfileName(sign);
            signCmd.runCommand();
            if (tmp.exists()) {
                tmp.delete();
            }
        }
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        File outFile = new File(outputFilePath + "." + format);
        if (outFile.exists()) {
            outFile.delete();
        }
        ZipCommand zipCmd = new ZipCommand(tempFile.toString(), outFile.toString());
        zipCmd.setExcludes(new String[]{".manifest.tmp"});
        executor.execute(new Command[]{zipCmd});
        DirectoryUtil.deleteDirectory(tempFile);
    }

    private PackageTargetData analisys(List<BuildTargetData> buildResultList, String workspacePath) {
        if (buildResultList == null) {
            return null;
        }
        PackageTargetData pkg = new PackageTargetData();
        pkg.workspacePath = workspacePath;
        HashMap<BuildConfigData, HashMap<String, BuildTargetData>> configMap = new HashMap<BuildConfigData, HashMap<String, BuildTargetData>>();
        HashSet<String> nativeProjList = new HashSet<String>();
        for (BuildTargetData buildTargetData : buildResultList) {
            if (buildTargetData.projType.equals("native")) {
                BuildConfigData config = new BuildConfigData(null, buildTargetData.platform, buildTargetData.arch, buildTargetData.config);
                HashMap<String, BuildTargetData> projList = (HashMap<String, BuildTargetData>)configMap.get(config);
                if (projList == null || projList.isEmpty()) {
                    projList = new HashMap<String, BuildTargetData>();
                    configMap.put(config, projList);
                }
                projList.put(buildTargetData.projPath, buildTargetData);
                if (!nativeProjList.contains(buildTargetData.projPath)) {
                    nativeProjList.add(buildTargetData.projPath);
                }
            }
            pkg.projectMap.put(buildTargetData.projPath, buildTargetData);
            if (pkg.projectList.contains(buildTargetData.projPath)) continue;
            pkg.projectList.add(buildTargetData.projPath);
        }
        for (Map.Entry entry : configMap.entrySet()) {
            if (((Map)entry.getValue()).size() != nativeProjList.size()) continue;
            ArrayList<BuildTargetData> lst = new ArrayList<BuildTargetData>();
            Collection buildTargets = ((Map)entry.getValue()).values();
            for (BuildTargetData buildTarget : buildTargets) {
                lst.add(buildTarget);
            }
            pkg.configMap.put((BuildConfigData)entry.getKey(), (List<BuildTargetData>)lst);
        }
        return pkg;
    }

    private Map<String, BuildScriptData.BuildEntry> prepBuildList(BuildScriptData buildScriptData) {
        List<BuildScriptData.BuildEntry> builds = buildScriptData.getBuilds();
        if (builds == null || builds.isEmpty()) {
            return null;
        }
        HashMap<String, BuildScriptData.BuildEntry> map = new HashMap<String, BuildScriptData.BuildEntry>();
        BuildScriptData.BuildEntry def = buildScriptData.getBuildEntry("_default_");
        BuildScriptData.BuildEntry ovr = buildScriptData.getBuildEntry("_override_");
        BuildScriptData.BuildEntry dummyEntry = new BuildScriptData.BuildEntry(def);
        dummyEntry.setName("_dummy_");
        dummyEntry.merge(ovr, false);
        map.put("_dummy_", dummyEntry);
        for (BuildScriptData.BuildEntry buildEntry : builds) {
            BuildScriptData.BuildEntry entry = new BuildScriptData.BuildEntry(def);
            entry.merge(buildEntry, true);
            entry.merge(ovr, false);
            map.put(buildEntry.getName(), entry);
        }
        return map;
    }

    private Map<String, List<BuildMethodData>> prepMethodList(Map<String, BuildScriptData.BuildMethodEntry> methodMap) {
        if (methodMap == null) {
            return null;
        }
        HashMap<String, List<BuildMethodData>> map = new HashMap<String, List<BuildMethodData>>();
        BuildScriptData.BuildMethodEntry defMethodEntry = methodMap.get("_default_");
        List<BuildMethodData> defBuildMethodList = this.convBuildMethodList(defMethodEntry);
        BuildScriptData.BuildMethodEntry overMethodEntry = methodMap.get("_override_");
        List<BuildMethodData> overBuildMethodList = this.convBuildMethodList(overMethodEntry);
        List<BuildMethodData> methodList = defBuildMethodList;
        if (overBuildMethodList != null && !overBuildMethodList.isEmpty()) {
            methodList = methodList != null ? this.mergeBuildMethodList(methodList, overBuildMethodList) : overBuildMethodList;
        }
        if (methodList != null && !methodList.isEmpty()) {
            map.put("_dummy_", methodList);
        }
        for (BuildScriptData.BuildMethodEntry methodEntry : methodMap.values()) {
            methodList = this.convBuildMethodList(methodEntry);
            if (defBuildMethodList != null && !defBuildMethodList.isEmpty()) {
                methodList = this.mergeBuildMethodList(defBuildMethodList, methodList);
            }
            if (overBuildMethodList != null && !overBuildMethodList.isEmpty()) {
                methodList = methodList != null ? this.mergeBuildMethodList(methodList, overBuildMethodList) : overBuildMethodList;
            }
            if (methodList == null || methodList.isEmpty()) continue;
            map.put(methodEntry.getName(), methodList);
        }
        return map;
    }

    private List<BuildTargetData> bindMethodToProject(BuildScriptData buildScriptData, BuildProjectListItem target, SBIPluginManager sbiPlugins, String sdkPath, String workspacePath, List<String> predefines, String baseOutputPath, String outPath, BuildMethodData method, String buildScriptPath, int jobs) {
        ArrayList<BuildTargetData> result = new ArrayList<BuildTargetData>();
        if (target.projectType.startsWith("native/")) {
            if (target.predefines != null && !target.predefines.isEmpty()) {
                if (predefines != null && !predefines.isEmpty()) {
                    predefines.addAll(target.predefines);
                } else {
                    predefines = target.predefines;
                }
            }
            BuildTargetData r = this.makeFinalBuildTargetForNative(sbiPlugins, sdkPath, workspacePath, predefines, baseOutputPath, target.projectName, target.fullPath, target.projectType, target.order, target.buildOrder, buildScriptPath, jobs, method);
            result.add(r);
        } else if (target.projectType.startsWith("web/")) {
            BuildTargetData r = this.makeFinalBuildTargetForWeb(baseOutputPath, target.fullPath, target.projectType, target.order, target.buildOrder);
            result.add(r);
        }
        return result;
    }

    private List<BuildTargetData> bindMethodToAllProject(BuildScriptData buildScriptData, List<BuildProjectListItem> projTargetList, SBIPluginManager sbiPlugins, String sdkPath, String workspacePath, List<String> predefines, String baseOutputPath, Map<String, BuildScriptData.BuildEntry> finalBuildMap, Map<String, List<BuildMethodData>> finalMethodMap) {
        if (projTargetList == null) {
            return null;
        }
        ArrayList<BuildTargetData> buildResult = new ArrayList<BuildTargetData>();
        for (BuildProjectListItem target : projTargetList) {
            String outPath;
            Object dummyList;
            BuildScriptData.BuildEntry buildEntry = finalBuildMap != null ? (target.buildName != null && !target.buildName.isEmpty() ? finalBuildMap.get(target.buildName) : finalBuildMap.get("_dummy_")) : null;
            List<Object> methodList = null;
            String buildScriptPath = null;
            int multitask = 0;
            List<String> predefines2 = predefines;
            if (buildEntry != null) {
                if (finalMethodMap != null) {
                    methodList = new ArrayList();
                    if (buildEntry.getBuildMethodList() != null) {
                        for (String methodName : buildEntry.getBuildMethodList()) {
                            List<BuildMethodData> method = finalMethodMap.get(methodName);
                            methodList.addAll(method);
                        }
                    }
                    if ((dummyList = finalMethodMap.get("_dummy_")) != null) {
                        methodList.addAll((Collection<Object>)dummyList);
                    }
                }
                if (buildEntry.getPredefines() != null && !buildEntry.getPredefines().isEmpty()) {
                    if (predefines != null && !predefines.isEmpty()) {
                        predefines2 = new ArrayList<String>();
                        predefines2.addAll(predefines);
                        predefines2.addAll(buildEntry.getPredefines());
                    } else {
                        predefines2 = buildEntry.getPredefines();
                    }
                }
                outPath = buildEntry.getOutputPath();
                buildScriptPath = buildEntry.getBuildScriptPath();
                multitask = buildEntry.getMultitaskJobs();
            } else {
                if (finalMethodMap != null) {
                    methodList = finalMethodMap.get("_dummy_");
                }
                outPath = null;
            }
            if (methodList != null && !methodList.isEmpty()) {
                dummyList = methodList.iterator();
                while (dummyList.hasNext()) {
                    List<BuildTargetData> r;
                    List<String> newPredefines;
                    BuildMethodData method = (BuildMethodData)dummyList.next();
                    if (method.getPredefineOptions() != null && !method.getPredefineOptions().isEmpty()) {
                        if (predefines2 != null && !predefines2.isEmpty()) {
                            newPredefines = new ArrayList<String>();
                            newPredefines.addAll(predefines2);
                            newPredefines.addAll(method.getPredefineOptions());
                        } else {
                            newPredefines = method.getPredefineOptions();
                        }
                    } else {
                        newPredefines = predefines2;
                    }
                    if ((r = this.bindMethodToProject(buildScriptData, target, sbiPlugins, sdkPath, workspacePath.toString(), newPredefines, baseOutputPath, outPath, method, buildScriptPath, multitask)) == null || r.isEmpty()) continue;
                    buildResult.addAll(r);
                }
                continue;
            }
            List<BuildTargetData> r = this.bindMethodToProject(buildScriptData, target, sbiPlugins, sdkPath, workspacePath.toString(), predefines, baseOutputPath, outPath, null, buildScriptPath, multitask);
            if (r == null || r.isEmpty()) continue;
            buildResult.addAll(r);
        }
        return buildResult;
    }

    @Override
    protected BuildAppData call() {
        if (this.data.hasRequiredOptions) {
            this.setCommandArgs();
            String sdkPath = this.data.getSdkPath();
            this.workspacePath = this.getWorkingDir().toString();
            this.data.setWorkingDir(this.workspacePath);
            String sbiHomePath = this.data.getSbiHomePath();
            if (this.workspacePath == null) {
                this.workspacePath = this.scriptPath != null && PathUtil.isAbsolutePath((String)this.scriptPath) ? new File(this.scriptPath).getParent() : System.getProperty("user.curdir");
            }
            SBIPluginManager sbiPlugins = new SBIPluginManager(sbiHomePath);
            BuildScriptData buildScriptData = null;
            if (this.scriptPath != null) {
                this.scriptPath = PathUtil.getFullPath((String)this.workspacePath, (String)this.scriptPath);
                buildScriptData = BuildScriptFileParser.analizeBuildScript(this.scriptPath, this.workspacePath, this.macros, this.log);
                if (buildScriptData == null) {
                    return null;
                }
            }
            buildScriptData = BuildScriptParamParser.analizeBuildParam(buildScriptData, "t", this.targetDesc, this.log);
            buildScriptData = BuildScriptParamParser.analizeBuildParam(buildScriptData, "m", this.methodDesc, this.log);
            buildScriptData = BuildScriptParamParser.analizeBuildParam(buildScriptData, "b", this.buildDesc, this.log);
            if ((buildScriptData = BuildScriptParamParser.analizeBuildParam(buildScriptData, "p", this.packageDesc, this.log)) == null) {
                return null;
            }
            String baseOutputPath = this.outputPath;
            if (baseOutputPath == null) {
                baseOutputPath = buildScriptData.getWorkspace().getOutputPath();
            }
            if (baseOutputPath != null) {
                baseOutputPath = PathUtil.getFullPath((String)this.workspacePath.toString(), (String)baseOutputPath);
            }
            Map<String, BuildScriptData.BuildEntry> finalBuildMap = this.prepBuildList(buildScriptData);
            Map<String, List<BuildMethodData>> finalMethodMap = this.prepMethodList(buildScriptData.getBuildMethodMap());
            ArrayList<BuildTargetData> completeTargetList = new ArrayList<BuildTargetData>();
            if (buildScriptData.getPackageList() != null) {
                for (BuildScriptData.PackageEntry pkg : buildScriptData.getPackageList()) {
                    String pathname;
                    if (pkg.getTargetList() == null) continue;
                    List<BuildProjectListItem> projTargetList = this.makeBuildProjectListAll(buildScriptData, pkg.getTargetList(), finalBuildMap, this.workspacePath);
                    if (projTargetList == null) {
                        return null;
                    }
                    List<BuildTargetData> buildResult = this.bindMethodToAllProject(buildScriptData, projTargetList, sbiPlugins, sdkPath, this.workspacePath, pkg.getPredefines(), baseOutputPath, finalBuildMap, finalMethodMap);
                    PackageTargetData pkgData = this.analisys(buildResult, this.workspacePath);
                    if (pkgData == null) continue;
                    String pkgType = null;
                    PackageValidator validator = new PackageValidator();
                    if (this.preprocValidator(validator, sdkPath, this.log)) {
                        List<String> pkgTypes = this.getValidatedPackageType(validator, pkgData, this.log);
                        if (pkgTypes == null || pkgTypes.isEmpty()) {
                            this.log.error("Wrong package type.");
                            this.progressLog.error("Wrong package type.");
                            continue;
                        }
                        if (pkg.getPackageType() != null && pkg.getValidate()) {
                            if (!pkgTypes.contains(pkg.getPackageType())) {
                                this.log.error("Wrong package type.");
                                this.progressLog.error("Wrong package type.");
                                continue;
                            }
                            pkgType = pkg.getPackageType();
                        } else {
                            pkgType = pkgTypes.get(0);
                        }
                    } else {
                        pkgType = pkg.getPackageType();
                    }
                    if (pkgType == null) {
                        this.log.error("Wrong package type.");
                        this.progressLog.error("Wrong package type.");
                        continue;
                    }
                    System.out.println("=== summary ===");
                    Set<Map.Entry<BuildConfigData, List<BuildTargetData>>> configSet0 = pkgData.configMap.entrySet();
                    if (configSet0 != null && !configSet0.isEmpty()) {
                        System.out.println("package : " + pkg.getName());
                        System.out.println("package type : " + pkgType);
                        for (String string : pkgData.projectList) {
                            System.out.println("project : " + string);
                        }
                        for (Map.Entry entry : configSet0) {
                            for (BuildTargetData buildTarget : (List)entry.getValue()) {
                                System.out.println(buildTarget.platform + ", " + buildTarget.arch);
                            }
                        }
                    }
                    System.out.println("=== ====== ===");
                    int r = this.buildAllForPackage(pkgData, completeTargetList);
                    if (r != 0) {
                        return null;
                    }
                    SSIProcess sSIProcess = new SSIProcess(sdkPath);
                    boolean isMain = true;
                    Set<Map.Entry<BuildConfigData, List<BuildTargetData>>> configSet = pkgData.configMap.entrySet();
                    if (configSet != null && !configSet.isEmpty()) {
                        PackageData data2 = null;
                        for (Map.Entry<BuildConfigData, List<BuildTargetData>> entry : configSet) {
                            String pathname2;
                            BuildConfigData buildCfg = entry.getKey();
                            ArrayList<SSITargetType> targets = new ArrayList<SSITargetType>();
                            for (String buildTarget : pkgData.projectList) {
                                String prjType;
                                BuildTargetData buildTargetData = pkgData.projectMap.get(buildTarget);
                                String projPath = PathUtil.getFullPath((String)this.workspacePath, (String)buildTargetData.projPath);
                                String workPath = PathUtil.getFullPath((String)this.workspacePath, (String)buildTargetData.output);
                                boolean type = this.isNativeProject(projPath);
                                if (type) {
                                    prjType = "native";
                                    data2 = PackageNativeCLICommand.getEnv(workPath, projPath, this.log);
                                    if (data2 == null) {
                                        return null;
                                    }
                                    String[] plt = buildCfg.platform.split("-");
                                    if (plt.length > 0) {
                                        data2.setSbiProfile(plt[0]);
                                        if (plt.length >= 2) {
                                            data2.setSbiProfileVersion(plt[1]);
                                        }
                                    }
                                    data2.setArchitecture(buildCfg.arch);
                                    data2.setSbiConfig(buildCfg.buildConfig);
                                } else if (this.isWebProject(projPath)) {
                                    prjType = "web";
                                    data2 = PackageProject.getWebSSIData(workPath, projPath, this.log);
                                    if (data2 == null) {
                                        return null;
                                    }
                                } else {
                                    prjType = null;
                                }
                                if (prjType == null) continue;
                                if (isMain) {
                                    this.data.setSbiProfileVersion(data2.getSbiProfileVersion());
                                    isMain = false;
                                }
                                targets.add(new SSITargetType("project", prjType, projPath, workPath, (SSIMacro.Runner)new PackageProject.MacroRunner(data2)));
                            }
                            if (data2 == null) {
                                return null;
                            }
                            if (targets.isEmpty()) continue;
                            String filename = pkg.getName() + "_" + buildCfg.platform + "_" + buildCfg.arch;
                            if (buildCfg.buildConfig == null || buildCfg.buildConfig.equals("Debug")) {
                                filename = filename + "_" + buildCfg.buildConfig;
                            }
                            String string = pathname2 = baseOutputPath != null ? baseOutputPath : this.workspacePath;
                            if (pkg.getOutputPath() != null && !pkg.getOutputPath().isEmpty()) {
                                pathname2 = pathname2 + File.separator + pkg.getOutputPath();
                            }
                            targets.add(new SSITargetType("package", "", null, null, null));
                            SSIData ssiData = new SSIData();
                            ssiData.putProperty("sdk.path", (Object)sdkPath);
                            ssiData.putProperty("build.config", (Object)data2.getSbiConfig());
                            ssiData.putProperty("build.arch", (Object)data2.getArchitecture());
                            ssiData.putProperty("project.output.path", (Object)pathname2);
                            this.processSSI(sSIProcess, targets, pkgType, ssiData, sdkPath, this.sign, pathname2 + File.separator + filename, this.log);
                        }
                        continue;
                    }
                    ArrayList<SSITargetType> targets = new ArrayList<SSITargetType>();
                    PackageData data2 = null;
                    for (String buildTarget : pkgData.projectList) {
                        String prjType;
                        BuildTargetData buildTargetData = pkgData.projectMap.get(buildTarget);
                        String projPath = PathUtil.getFullPath((String)this.workspacePath, (String)buildTargetData.projPath);
                        String workPath = PathUtil.getFullPath((String)this.workspacePath, (String)buildTargetData.output);
                        boolean type = this.isNativeProject(projPath);
                        if (type) {
                            prjType = "native";
                            data2 = PackageNativeCLICommand.getEnv(workPath, projPath, this.log);
                            if (data2 == null) {
                                return null;
                            }
                        } else if (this.isWebProject(projPath)) {
                            prjType = "web";
                            data2 = PackageProject.getWebSSIData(workPath, projPath, this.log);
                            if (data2 == null) {
                                return null;
                            }
                        } else {
                            prjType = null;
                        }
                        if (prjType == null) continue;
                        if (isMain) {
                            this.data.setSbiProfileVersion(data2.getSbiProfileVersion());
                            isMain = false;
                        }
                        targets.add(new SSITargetType("project", prjType, projPath, workPath, (SSIMacro.Runner)new PackageProject.MacroRunner(data2)));
                    }
                    if (data2 == null) {
                        return null;
                    }
                    if (targets.isEmpty()) continue;
                    String string = pkg.getName();
                    String string2 = pathname = baseOutputPath != null ? baseOutputPath : this.workspacePath;
                    if (pkg.getOutputPath() != null && !pkg.getOutputPath().isEmpty()) {
                        pathname = pathname + File.separator + pkg.getOutputPath();
                    }
                    targets.add(new SSITargetType("package", "", null, null, null));
                    SSIData ssiData = new SSIData();
                    ssiData.putProperty("sdk.path", (Object)sdkPath);
                    ssiData.putProperty("build.config", (Object)data2.getSbiConfig());
                    ssiData.putProperty("build.arch", (Object)data2.getArchitecture());
                    ssiData.putProperty("project.output.path", (Object)pathname);
                    this.processSSI(sSIProcess, targets, pkgType, ssiData, sdkPath, this.sign, pathname + File.separator + string, this.log);
                }
            } else if (finalBuildMap != null) {
                boolean isEmptyBuild = finalBuildMap.size() <= 1;
                for (BuildScriptData.BuildEntry buildEntry : finalBuildMap.values()) {
                    int r;
                    List<BuildTargetData> buildResult;
                    List<BuildProjectListItem> projTargetList;
                    if (!isEmptyBuild && (buildEntry.getName().equals("_default_") || buildEntry.getName().equals("_override_")) || (projTargetList = this.makeBuildProjectList(buildScriptData, buildEntry.getName(), finalBuildMap, this.workspacePath, 0)) == null || projTargetList.isEmpty() || (buildResult = this.bindMethodToAllProject(buildScriptData, projTargetList, sbiPlugins, sdkPath, this.workspacePath, buildEntry.getPredefines(), baseOutputPath, finalBuildMap, finalMethodMap)) == null || (r = this.buildAll(buildResult, this.workspacePath, completeTargetList)) == 0) continue;
                    return null;
                }
            }
        } else {
            this.log.trace(TizenCLIMessages.BN_CANNOT_MAKE_BUILD_COMMAND);
            this.progressLog.info("Need more build informations. please check a tizen-sdk/tools/ide/ncli.log file");
            throw new UnexpectedException(2, TizenCLIMessages.BN_CANNOT_MAKE_BUILD_COMMAND);
        }
        return this.data;
    }

    private List<String> getValidatedPackageType(PackageValidator validator, PackageTargetData pkgData, Logger log) {
        if (validator == null || !validator.isValid()) {
            return null;
        }
        ArrayList<BuildTargetData> projTypeList = new ArrayList<BuildTargetData>();
        for (String string : pkgData.projectList) {
            BuildTargetData build = pkgData.projectMap.get(string);
            projTypeList.add(build);
        }
        Collections.sort(projTypeList, new Comparator<BuildTargetData>(){

            @Override
            public int compare(BuildTargetData arg0, BuildTargetData arg1) {
                return Integer.compare(arg0.order, arg1.order);
            }
        });
        ArrayList<String> projTypeList2 = new ArrayList<String>();
        for (BuildTargetData proj : projTypeList) {
            projTypeList2.add(proj.projTypeDetail);
        }
        List<PackageValidator.Package> list = validator.getMatchPakcages(projTypeList2);
        if (list == null) {
            return null;
        }
        ArrayList<String> pkgTypeList = new ArrayList<String>();
        for (PackageValidator.Package pkg : list) {
            pkgTypeList.add(pkg.getType());
        }
        return pkgTypeList;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public void setSignProfile(String sign) {
        this.sign = sign;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setTargetDescs(String[] targets) {
        this.targetDesc = targets;
    }

    public void setMethodDescs(String[] methods) {
        this.methodDesc = methods;
    }

    public void setBuildDescs(String[] builds) {
        this.buildDesc = builds;
    }

    public void setPackageDescs(String[] packages) {
        this.packageDesc = packages;
    }

    public void setMacros(String[] defines) {
        if (defines != null) {
            for (String define : defines) {
                String[] macro = define.split("=");
                if (macro.length != 2) continue;
                this.macros.put(macro[0], macro[1]);
            }
        }
    }

    private static class BuildProjectListItem {
        public int order;
        public int type;
        public String projectName;
        public String projectType;
        public String buildName;
        public List<String> predefines;
        public String fullPath;
        public int buildOrder;
        public String defProfile;
        public String defProfileVer;
        public String defArch;

        public BuildProjectListItem(int order, int buildOrder, int type, String projectName, String projectType, String defProfile, String defProfileVer, String defArch, String buildName, List<String> predefines, String fullPath) {
            this.order = order;
            this.buildOrder = buildOrder;
            this.type = type;
            this.projectName = projectName;
            this.projectType = projectType;
            this.defProfile = defProfile;
            this.defProfileVer = defProfileVer;
            this.defArch = defArch;
            this.buildName = buildName;
            this.predefines = predefines;
            this.fullPath = fullPath;
        }
    }

    static class PackageTargetData {
        public String workspacePath = null;
        public List<String> projectList = new ArrayList<String>();
        public Map<String, BuildTargetData> projectMap = new HashMap<String, BuildTargetData>();
        public Map<BuildConfigData, List<BuildTargetData>> configMap = new HashMap<BuildConfigData, List<BuildTargetData>>();

        PackageTargetData() {
        }
    }

    static class BuildTargetData {
        public String projPath;
        public String projType;
        public String projTypeDetail;
        public String platform;
        public String arch;
        public String config;
        public String output;
        public int order;
        public int buildOrder;
        public BuildNativeMethodData buildMethod;
        public String resultPath;
        public SBIProcess sbi;

        BuildTargetData() {
        }
    }

    static class BuildConfigData {
        public String rootstrapName;
        public String platform;
        public String arch;
        public String buildConfig;

        public BuildConfigData(String rootstrapName, String platform, String arch, String buildConfig) {
            this.rootstrapName = rootstrapName;
            this.platform = platform;
            this.arch = arch;
            this.buildConfig = buildConfig;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + (this.rootstrapName != null ? this.rootstrapName.hashCode() : 0);
            hash = hash * 31 + (this.rootstrapName == null && this.platform != null ? this.platform.hashCode() : 0);
            hash = hash * 31 + (this.rootstrapName == null && this.arch != null ? this.arch.hashCode() : 0);
            hash = hash * 31 + (this.buildConfig != null ? this.buildConfig.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object a) {
            if (a == null) {
                return false;
            }
            return ((BuildConfigData)a).hashCode() == this.hashCode();
        }
    }
}

