/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.listweb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.createweb.CreateWebProjectCommandData;
import org.tizen.ncli.subcommands.createweb.WebProjectInfo;
import org.tizen.ncli.subcommands.listweb.ListWebProject;
import org.tizen.ncli.subcommands.listweb.WebProfileCompare;

public class ListWebProjectCLICommand
extends AbstractSubCommand<ListWebProject> {
    private final String VIEW_FORMAT = "%-20s %s";
    private final String TITLE_FORMAT = String.format("%-20s %s", "[PROFILE]", "[TEMPLATE]");

    @Override
    protected ListWebProject call() {
        ListWebProject list = new ListWebProject();
        Map<WebProjectInfo, String> WebProjectMap = CreateWebProjectCommandData.getTemplateListFromAllProfile();
        if (WebProjectMap != null && WebProjectMap.size() != 0) {
            this.progressLog.info(this.TITLE_FORMAT);
            Set<WebProjectInfo> WebProjectInfoSet = WebProjectMap.keySet();
            ArrayList<WebProjectInfo> webProjectList = new ArrayList<WebProjectInfo>(WebProjectInfoSet);
            Collections.sort(webProjectList, new WebProfileCompare());
            for (WebProjectInfo info : webProjectList) {
                String projectInfo = String.format("%-20s %s", info.getProfileName(), info.getTemplateName());
                this.progressLog.info(projectInfo);
            }
        } else {
            this.progressLog.error("Not found Web templates");
            throw new UnexpectedException(2, "Not Found Web templates");
        }
        return list;
    }
}

