/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.model;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.sign.exception.CertificationException;
import org.tizen.common.sign.exception.ComplicatedCertificationException;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.preferences.UIMessages;

public class Certification {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Prompter prompter;
    protected KeyStore keyStore;
    protected PrivateKey privateKey;
    protected String privateKeyAlias;
    protected List<X509Certificate> certificationChain;
    protected X509Certificate certificate;
    protected String password;

    public Certification(Prompter prompter) {
        this.prompter = prompter;
    }

    protected Prompter getPrompter() {
        return this.prompter;
    }

    protected char[] inputPassword(String message) {
        Prompter prompter = this.getPrompter();
        return (char[])prompter.password(message);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean load(SigningProfileItem profileItem) throws CertificationException {
        String keyLocation = profileItem.getKeyLocation();
        char[] password = profileItem.getPassword();
        if (!(password != null && password.length != 0 || (password = this.inputPassword("Enter password for file" + keyLocation)) != null && password.length != 0)) {
            return false;
        }
        this.setPassword(new String(password));
        return true;
    }

    /*
     * Exception decompiling
     */
    protected void loadKeyStore(SigningProfileItem item, char[] password) throws CertificationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void loadPrivateKey(char[] password) {
        try {
            Enumeration<String> alias = this.keyStore.aliases();
            while (alias.hasMoreElements()) {
                String aliasEntry = alias.nextElement();
                if (!this.keyStore.isKeyEntry(aliasEntry)) continue;
                this.privateKeyAlias = aliasEntry;
                this.privateKey = (PrivateKey)this.keyStore.getKey(aliasEntry, password);
            }
        }
        catch (KeyStoreException e) {
            this.logger.error("Error occured", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("Error occured", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            this.logger.error("Error occured", (Throwable)e);
        }
    }

    private void assertInvalidCertificate(X509Certificate interCertificate, String p12FileLocation) throws ComplicatedCertificationException {
        Date notBefore = interCertificate.getNotBefore();
        Date notAfter = interCertificate.getNotAfter();
        Date date = new Date();
        if (date.before(notBefore) || date.after(notAfter)) {
            String detailsText = String.valueOf(UIMessages.getString("org.tizen.common.sign.certificatevaliditymessage1")) + " " + p12FileLocation + " " + UIMessages.getString("org.tizen.common.sign.certificatevaliditymessage2") + " " + notBefore + " " + UIMessages.getString("org.tizen.common.sign.certificatevaliditymessage3") + " " + notAfter;
            throw new ComplicatedCertificationException(detailsText);
        }
    }

    protected void loadCertificate(String location) throws KeyStoreException, ComplicatedCertificationException {
        Certificate cert = this.keyStore.getCertificate(this.privateKeyAlias);
        if (cert instanceof X509Certificate) {
            this.assertInvalidCertificate((X509Certificate)cert, location);
            this.certificate = (X509Certificate)cert;
        }
    }

    protected void loadCertificateChain() throws CertificationException {
        this.certificationChain = new ArrayList<X509Certificate>();
        try {
            Certificate[] chain = this.keyStore.getCertificateChain(this.privateKeyAlias);
            if (chain != null && chain.length > 0) {
                int i = 0;
                while (i < chain.length) {
                    if (chain[i] instanceof X509Certificate) {
                        this.certificationChain.add((X509Certificate)chain[i]);
                    }
                    ++i;
                }
            }
        }
        catch (KeyStoreException e) {
            throw new CertificationException(e.getMessage(), e);
        }
    }

    public Key getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate[] getCertificationChain() {
        return this.certificationChain.toArray(new X509Certificate[0]);
    }

    public static enum KeyExtension {
        p12("PKCS12"),
        keystore("JKS");

        private String keyType;

        private KeyExtension(String keyType) {
            this.keyType = keyType;
        }

        public String getKeyType() {
            return this.keyType;
        }

        public static boolean hasExtension(String extension) {
            KeyExtension[] keyExtensionArray = KeyExtension.values();
            int n = keyExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyExtension keyExt = keyExtensionArray[n2];
                if (keyExt.name().equalsIgnoreCase(extension)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

