/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildnative;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.core.gputil.IOUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.BuildMethodData;
import org.tizen.ncli.subcommands.build.buildnative.BuildInfo;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeData;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeMethodData;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeOption;
import org.tizen.sbilib.for_cli.SBIBuildParamData;
import org.tizen.sbilib.for_cli.SBIModel;
import org.tizen.sbilib.for_cli.SBIProcess;
import org.tizen.sbilib.for_cli.sbiplugin.SBIPluginManager;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIToolchainData;
import org.tizen.tpklib.lib.PathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BuildNativeCommand {
    protected final Logger log = LoggerFactory.getLogger(AbstractSubCommand.class);
    protected final Logger progressLog = LoggerFactory.getLogger((String)"NCLI_PROGRESS");

    public static boolean validateProject(String projPath) {
        File projFile = new File(projPath);
        return new File(projFile, "project_def.prop").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBuildInfoFromBuildProp(String projectDir, BuildNativeData data, Logger log) {
        File propFile = new File(projectDir, "project_def.prop");
        if (!propFile.exists()) {
            return false;
        }
        Properties prop = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propFile);
            prop.load(inputStream);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{inputStream});
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        String appName = prop.getProperty("APPNAME");
        String type = prop.getProperty("type");
        String profile = prop.getProperty("profile");
        if (appName == null) {
            if (log != null) {
                log.debug("Cannot get project name.");
            }
            return false;
        }
        data.setSbiAppName(appName);
        if (type == null || profile == null) {
            if (log != null) {
                log.debug("Cannot get profile (type: " + type + " profile: " + profile + ")");
            }
            return false;
        }
        data.setSbiType(type);
        StringTokenizer st = new StringTokenizer(profile, "-");
        if (!st.hasMoreTokens()) {
            return false;
        }
        String str = st.nextToken();
        str = str.substring(0, 1).toUpperCase() + str.substring(1);
        data.setSbiProfile(str);
        if (!st.hasMoreTokens()) {
            return false;
        }
        data.setSbiProfileVersion(st.nextToken());
        return true;
    }

    private static boolean getManifestInfo(String projectDir, BuildNativeData data) {
        File file = new File(projectDir, "tizen-manifest.xml");
        if (!file.exists()) {
            return false;
        }
        Document menifestDoc = XMLUtil.readXML((File)file);
        String pack = XMLUtil.getDOMValueNS((Document)menifestDoc, (String)"/:manifest/@package");
        data.setSbiPackage(pack);
        Node appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:manifest/:ui-application");
        String appType = "ui";
        if (appNode == null) {
            appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:manifest/:service-application");
            appType = "service";
        }
        if (appNode == null) {
            appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:manifest/:watch-application");
            appType = "watch";
        }
        if (appNode == null) {
            appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:manifest/:widget-application");
            appType = "widget";
        }
        if (appNode != null && appNode instanceof Element) {
            data.setSbiAppType(appType);
            String id = XMLUtil.getDOMValueNS((Element)((Element)appNode), (String)"@appid");
            data.setSbiAppId(id);
            String exec = XMLUtil.getDOMValueNS((Element)((Element)appNode), (String)"@exec");
            data.setSbiExecName(exec);
        }
        return true;
    }

    public static SBIProcess genDefSBIProcess(SBIPluginManager sbiPlugins, String sdkPath) {
        SBIModel result = null;
        SBIProcess sbi = null;
        sbi = new SBIProcess();
        sbi.setPluginManager(sbiPlugins);
        File sbiBuildConfFile = new File(sdkPath + "/tools/ide/resources/native/Build/SBI.xml");
        if (sbiBuildConfFile.exists()) {
            result = sbi.loadBuildScript(sbiBuildConfFile.toString());
        }
        if (result != null) {
            return sbi;
        }
        return null;
    }

    public static SBIProcess genSBIProcess(SBIPluginManager sbiPlugins, String buildScriptPath, String projDir) {
        File sbiBuildConfFile;
        SBIModel result = null;
        SBIProcess sbi = null;
        sbi = new SBIProcess();
        sbi.setPluginManager(sbiPlugins);
        if (buildScriptPath != null && (sbiBuildConfFile = new File(buildScriptPath, "SBI.xml")).exists()) {
            result = sbi.loadBuildScript(sbiBuildConfFile.toString(), "1.0");
        }
        if (result == null && (sbiBuildConfFile = new File(projDir, "Build/SBI.xml")).exists()) {
            result = sbi.loadBuildScript(sbiBuildConfFile.toString(), "1.0");
        }
        if (result != null) {
            return sbi;
        }
        return null;
    }

    public static boolean attachRootstrapAndToolchain(SBIProcess sbi, String profileName, String profileVersion, String arch, String rootstrapName, String toolchainName, String projType, Logger log) {
        SBIToolchainData platformDefGccToolchain;
        SBIRootstrapData.ToolchainData tool;
        SBIPluginManager sbiPlugins = sbi.getPluginManager();
        if (sbiPlugins == null) {
            return false;
        }
        SBIRootstrapData rootstrap = null;
        rootstrap = rootstrapName == null ? sbiPlugins.findRootstrap(profileName, profileVersion, arch) : sbiPlugins.findRootstrap(rootstrapName);
        if (rootstrap == null) {
            if (log != null) {
                log.error(TizenCLIMessages.BN_CANNOT_GET_PLATFORM_ID);
            }
            return false;
        }
        SBIToolchainData toolchain = null;
        toolchain = toolchainName.equalsIgnoreCase("LLVM") ? sbiPlugins.findLatestToolchain(toolchainName, arch, projType) : sbiPlugins.findToolchain(toolchainName, arch, projType);
        if (toolchain == null) {
            if (log != null) {
                log.error(TizenCLIMessages.BN_CANNOT_GET_TOOLCHAIN_ID);
            }
            return false;
        }
        Map macros = sbi.getMacro().getMacroOrgs();
        if (toolchainName.toLowerCase().startsWith("llvm") && (tool = rootstrap.getDefaultToolchain("gcc")) != null && (platformDefGccToolchain = tool.version != null && !tool.version.isEmpty() ? sbiPlugins.findToolchain(tool.name + "-" + tool.version, arch, projType) : sbiPlugins.findLatestToolchain(tool.name, arch, projType)) != null) {
            macros.put("PLATFORM_DEFAULT_GCC_PATH", platformDefGccToolchain.getPath());
        }
        sbi.setToolchainData(toolchain);
        sbi.setRootstrapData(rootstrap);
        return true;
    }

    public static BuildNativeData build(SBIProcess sbi, BuildMethodData method, String projectDir, boolean ownBuildScript, String outputPath, String buildScriptPath, int multitaskJobs, String workspaceLoc, Logger progressLog) {
        BuildNativeMethodData nativeMethod = BuildNativeCommand.prepareBuildMethod(sbi, method, null, projectDir);
        nativeMethod.setBuildScriptPath(buildScriptPath);
        nativeMethod.setJobs(multitaskJobs);
        return BuildNativeCommand.build(sbi, nativeMethod, projectDir, ownBuildScript, outputPath, workspaceLoc, progressLog);
    }

    public static BuildNativeData build(SBIProcess sbi, BuildNativeMethodData method, String projectDir, boolean ownBuildScript, String outputPath, String workspaceLoc, Logger progressLog) {
        return BuildNativeCommand.build(sbi, projectDir, method.getProjectType(), method.getAppId(), method.getAppExecName(), method.getArchitecture(), method.getProfileName(), method.getProfileVersion(), method.getRootstrapName(), method.getBuildConfig(), method.getPredefineOptions(), method.getToolchain(), ownBuildScript, outputPath, workspaceLoc, method.getBuildScriptPath(), method.getJobs(), progressLog);
    }

    public static BuildNativeData build(SBIProcess sbi, String projectDir, String projectType, String appId, String appExecName, String arch, String profileName, String profileVersion, String rootstrapName, String buildConfig, List<String> predefineOptions, String toolchain, boolean ownBuildScript, String outputPath, String workspaceLoc, String buildScriptPath, int multitaskJobs, Logger progressLog) {
        boolean r = BuildNativeCommand.attachRootstrapAndToolchain(sbi, profileName, profileVersion, arch, rootstrapName, toolchain, projectType, progressLog);
        if (!r) {
            return null;
        }
        if (progressLog != null) {
            progressLog.info("[PLATFORM] " + profileName + "-" + profileVersion);
            progressLog.info("[ARCHITECTURE] " + arch);
            progressLog.info("[COMPILER] " + toolchain);
            progressLog.info("[CONFIGURATION] " + buildConfig);
        }
        sbi.getPluginManager().realizePluginValue(sbi.getRootstrapData(), sbi.getToolchainData());
        String sdkPath = InstallPathConfig.getSDKPath();
        String sbiHomePath = sdkPath + File.separator + BuildNativeOption.SBI_HOME_PATH;
        SBIBuildParamData sysVarData = new SBIBuildParamData();
        sysVarData.putProperty("sdk.path", (Object)sdkPath);
        sysVarData.putProperty("sbi.path", (Object)sbiHomePath);
        sysVarData.putProperty("project.path", (Object)projectDir);
        sysVarData.putProperty("app.id", (Object)appId);
        sysVarData.putProperty("app.type", (Object)projectType);
        sysVarData.putProperty("build.config", (Object)buildConfig);
        sysVarData.putProperty("build.arch", (Object)arch);
        sysVarData.putProperty("build.options", predefineOptions);
        sbi.realizeBuildScript(sysVarData, null);
        int result = BuildNativeCommand.executeWithLog(sbi, progressLog, projectDir, outputPath, buildScriptPath, ownBuildScript, predefineOptions, workspaceLoc, multitaskJobs);
        if (result != 0) {
            return null;
        }
        BuildNativeData buildData = new BuildNativeData();
        buildData.setSbiExecName(appExecName);
        buildData.setSbiType(projectType);
        buildData.setSbiArchitecture(arch);
        buildData.setSbiProfile(profileName);
        buildData.setSbiProfileVersion(profileVersion);
        buildData.setSbiConfig(buildConfig);
        buildData.setSbiToolchain(toolchain);
        buildData.setOutputPath(outputPath);
        if (outputPath == null) {
            outputPath = projectDir + File.separator + buildConfig;
        }
        buildData.setOutputPath(outputPath);
        BuildNativeCommand.writeBuildInfo(projectDir, outputPath, buildData);
        return buildData;
    }

    public static BuildNativeData analisysProjectInfo(String projectDir) {
        BuildNativeData buildData = new BuildNativeData();
        BuildNativeCommand.getBuildInfoFromBuildProp(projectDir, buildData, null);
        BuildNativeCommand.getManifestInfo(projectDir, buildData);
        return buildData;
    }

    public static BuildNativeMethodData prepareBuildMethod(SBIProcess sbi, BuildMethodData method, BuildNativeData buildData, String projectDir) {
        SBIPluginManager sbiPlugins;
        BuildNativeMethodData nativeMethod = new BuildNativeMethodData();
        nativeMethod.setProjectPath(projectDir);
        if (buildData == null) {
            buildData = BuildNativeCommand.analisysProjectInfo(projectDir);
        }
        String projType = buildData.getSbiType();
        nativeMethod.setAppName(buildData.getSbiAppName());
        nativeMethod.setAppId(buildData.getSbiAppId());
        nativeMethod.setAppType(buildData.getSbiAppType());
        nativeMethod.setAppExecName(buildData.getSbiExecName());
        nativeMethod.setProjectType(projType);
        if (method != null) {
            nativeMethod.setBuildConfig(method.getBuildConfig());
        }
        if (nativeMethod.getBuildConfig() == null) {
            nativeMethod.setBuildConfig("Debug");
        }
        if ((sbiPlugins = sbi.getPluginManager()) == null) {
            return null;
        }
        if (method != null) {
            nativeMethod.setJobs(buildData.getMultiTaskingJobs());
            nativeMethod.setBuildScriptPath(buildData.buildScriptPath);
        }
        SBIRootstrapData rootstrap = null;
        if (method != null) {
            if (method.getRootstrapName() == null) {
                nativeMethod.setProfileName(method.getProfileName() != null ? method.getProfileName() : buildData.getSbiProfile());
                nativeMethod.setProfileVersion(method.getProfileVersion() != null ? method.getProfileVersion() : buildData.getSbiProfileVersion());
                nativeMethod.setArchitecture(method.getArchitecture() != null ? method.getArchitecture() : buildData.getSbiArchitecture());
            } else {
                nativeMethod.setRootstrapName(method.getRootstrapName());
            }
        } else {
            nativeMethod.setProfileName(buildData.getSbiProfile());
            nativeMethod.setProfileVersion(buildData.getSbiProfileVersion());
            nativeMethod.setArchitecture(buildData.getSbiArchitecture() != null ? buildData.getSbiArchitecture() : "i386");
        }
        if (nativeMethod.getArchitecture() == null) {
            nativeMethod.setArchitecture("i386");
        }
        if (nativeMethod.getRootstrapName() == null) {
            rootstrap = sbiPlugins.findRootstrap(nativeMethod.getProfileName(), nativeMethod.getProfileVersion(), nativeMethod.getArchitecture());
        } else {
            rootstrap = sbiPlugins.findRootstrap(nativeMethod.getRootstrapName());
            if (rootstrap != null) {
                String[] platform;
                String arch = rootstrap.getArchitecture();
                nativeMethod.setArchitecture(arch);
                if (rootstrap.getPlatformName() != null && (platform = rootstrap.getPlatformName().split(" ")).length >= 1) {
                    nativeMethod.setProfileName(platform[0]);
                    if (platform.length >= 2) {
                        nativeMethod.setProfileVersion(platform[1]);
                    }
                }
            }
        }
        if (rootstrap == null) {
            // empty if block
        }
        String toolchainName = method != null && method.getToolchain() != null ? method.getToolchain() : "llvm";
        SBIToolchainData toolchain = null;
        if (toolchainName != null) {
            if (toolchainName.equalsIgnoreCase("gcc") || toolchainName.equalsIgnoreCase("llvm")) {
                String version = rootstrap != null ? null : null;
                if (version != null && !version.isEmpty()) {
                    toolchainName = toolchainName + "-" + version;
                    toolchain = sbiPlugins.findToolchain(toolchainName, nativeMethod.getArchitecture(), projType);
                } else {
                    toolchain = sbiPlugins.findLatestToolchain(toolchainName, nativeMethod.getArchitecture(), projType);
                    if (toolchain != null) {
                        toolchainName = toolchain.getName();
                    }
                }
            }
            nativeMethod.setToolchain(toolchainName);
        }
        if (toolchain == null) {
            // empty if block
        }
        if (method != null && method.getPredefineOptions() != null && !method.getPredefineOptions().isEmpty()) {
            nativeMethod.predefineOptions = new ArrayList<String>();
            nativeMethod.predefineOptions.addAll(method.getPredefineOptions());
        }
        if (method == null) {
            nativeMethod.setOutputPath(projectDir + File.separator + nativeMethod.getBuildConfig() + File.separator + nativeMethod.getArchitecture());
        }
        return nativeMethod;
    }

    public static void writeBuildInfo(String projectPath, String outputPath, BuildNativeData buildData) {
        if (outputPath == null || buildData == null) {
            return;
        }
        if (!new File(outputPath).exists()) {
            return;
        }
        BuildInfo buildInfo = new BuildInfo(buildData.getSbiProfile(), buildData.getSbiProfileVersion(), null, buildData.getSbiArchitecture(), buildData.getSbiType());
        buildInfo.setBuildConfig(buildData.getSbiConfig());
        buildInfo.setToolchain(buildData.getSbiToolchain());
        buildInfo.setProjectPath(projectPath);
        buildInfo.writeBuildInfo(PathUtil.addPath((String[])new String[]{outputPath, "build.info"}), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeWithLog(SBIProcess sbi, Logger logger, String projDir, String outputPath, String buildScriptPath, boolean ownBuildScript, List<String> predefineOption, String workspaceLoc, int jobs) {
        int sbi_result = 0;
        if (sbi == null) {
            return -1;
        }
        if (!sbi.isValidate()) {
            // empty if block
        }
        ProcessBuilder pb = SBIProcess.genProcessBuilder(null);
        Map<String, String> env = pb.environment();
        Configuration config = new Configuration();
        config.getEnvValueFromCLIConfig(env);
        String preproc = null;
        String postproc = null;
        String preproc_msg = null;
        String postproc_msg = null;
        File buildPropFile = new File(projDir, "build_def.prop");
        if (buildPropFile.exists()) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(buildPropFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                preproc_msg = prop.getProperty("PREBUILD_DESC");
                preproc = prop.getProperty("PREBUILD_COMMAND");
                postproc_msg = prop.getProperty("POSTBUILD_DESC");
                postproc = prop.getProperty("POSTBUILD_COMMAND");
            }
        }
        if (sbi_result == 0) {
            sbi.getMacro().addMacro("_PARAM1_", jobs > 0 ? String.valueOf(jobs) : "");
            if (preproc != null && !preproc.isEmpty()) {
                sbi.getMacro().addMacro("_PARAM2_", preproc);
                sbi.getMacro().addMacro("_PARAM3_", "PreBuild Desc : " + preproc_msg);
            }
            if (postproc != null && !postproc.isEmpty()) {
                sbi.getMacro().addMacro("_PARAM4_", postproc);
                sbi.getMacro().addMacro("_PARAM5_", "PostBuild Desc : " + postproc_msg);
            }
            if (predefineOption != null && predefineOption.size() > 0) {
                String predefine = "";
                for (String pd : predefineOption) {
                    if (!predefine.isEmpty()) {
                        predefine = predefine + " ";
                    }
                    predefine = predefine + pd;
                }
                sbi.getMacro().addMacro("_PARAM6_", predefine);
            }
            sbi.getMacro().addMacro("_PARAM7_", outputPath);
            if (buildScriptPath != null && !buildScriptPath.isEmpty()) {
                sbi.getMacro().addMacro("_PARAM8_", buildScriptPath);
            }
            if (ownBuildScript) {
                sbi.getMacro().addMacro("_PARAM9_", "ownbuild");
            }
            if (workspaceLoc != null && !workspaceLoc.isEmpty()) {
                sbi.getMacro().addMacro("_PARAM10_", workspaceLoc);
            }
            sbi_result = sbi.procAction("build", projDir, pb, logger);
        }
        return sbi_result;
    }
}

