/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createcsharp;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.util.FileUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.createcsharp.CSSolutionInfo;
import org.tizen.ncli.subcommands.createcsharp.IWizard;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VSTemplateParser {
    private static final String TEMPATE_DATA = "TemplateData";
    private static final String TEMPATE_CONTENT = "TemplateContent";
    private static final String WIZARD_EXTENSION = "WizardExtension";
    private static final String PROJECT = "Project";
    private static final String PROJECT_COLLECTION = "ProjectCollection";
    private static final String CUSTOM_PARAMETERS = "CustomParameters";
    private static final String FULL_CLASS_NAME = "FullClassName";
    private static final String FOLDER = "Folder";
    private static final String PROJECT_ITEM = "ProjectItem";
    private static final String CUSTOM_PARAMETER = "CustomParameter";
    private static final String PROJECT_TEMPLATE_LINK = "ProjectTemplateLink";
    private static final String TEMPLATE_ID = "TemplateID";
    private static final String CREATE_NEW_FOLDER = "CreateNewFolder";
    private static final String PATTERN_PARAMETER = "\\$[a-zA-Z0-9_]*\\$";
    private static final String PATTERN_EXPRESSION = "\\(\\s*(\"([^\"]*)\")\\s*==\\s*(\"?([^\"]*)\"?)\\s*\\)";
    private File vstemplateFile;
    private Element elementRoot;
    private VSTemplate data = new VSTemplate();

    public static String makeSafeProjectName(String projectName) {
        String regex = new String("[^\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}\\p{Nd}\\p{Nl}\\p{Mn}\\p{Mc}\\p{Cf}\\p{Pc}\\p{Lm}|._]");
        String safeName = projectName.replaceAll(regex, "");
        if (!Character.isLetter(safeName.charAt(0))) {
            safeName = "_" + safeName;
        }
        return safeName.replace(" ", "");
    }

    VSTemplateParser(String vstemplateFilePath) {
        this.vstemplateFile = new File(vstemplateFilePath);
        this.elementRoot = XMLUtil.readXML((File)this.vstemplateFile).getDocumentElement();
    }

    public boolean parse() {
        NodeList childList = this.elementRoot.getElementsByTagName(TEMPATE_DATA);
        if (childList.getLength() <= 0) {
            return false;
        }
        Node node = childList.item(0);
        this.parseTemplateData(node);
        childList = this.elementRoot.getElementsByTagName(TEMPATE_CONTENT);
        if (childList.getLength() > 0) {
            node = childList.item(0);
            if (!this.parseTemplateContent(node)) {
                return false;
            }
        } else {
            return false;
        }
        childList = this.elementRoot.getElementsByTagName(WIZARD_EXTENSION);
        if (childList.getLength() > 0) {
            node = childList.item(0);
            this.parseWizardExtension(node);
        }
        return true;
    }

    private void parseTemplateData(Node templateDataNode) {
        NodeList childList = templateDataNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TEMPLATE_ID)) {
                this.data.templateData.templateID = child.getTextContent().trim();
                continue;
            }
            if (!nodeName.equals(CREATE_NEW_FOLDER)) continue;
            this.data.templateData.createNewFolder = Boolean.parseBoolean(child.getTextContent().trim());
        }
    }

    private boolean parseTemplateContent(Node templateContentNode) {
        NodeList childList = templateContentNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(PROJECT)) {
                this.parseProject(child);
                continue;
            }
            if (nodeName.equals(CUSTOM_PARAMETERS)) {
                this.parseCustomeParameters(child);
                continue;
            }
            if (!nodeName.equals(PROJECT_COLLECTION) || this.parseProjectCollection(child)) continue;
            return false;
        }
        return true;
    }

    private void parseWizardExtension(Node wizardExtensionNode) {
        this.data.wizardExtension = new WizardExtension();
        NodeList childList = wizardExtensionNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equals(FULL_CLASS_NAME)) continue;
            this.parseFullClassName(child);
        }
    }

    private void parseCustomeParameters(Node rootNode) {
        this.data.templateContent.paramter = new CustomParameters();
        NodeList childList = rootNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equals(CUSTOM_PARAMETER)) continue;
            Element param = (Element)child;
            CustomParameter cparam = new CustomParameter();
            cparam.attrName = param.getAttribute("Name");
            cparam.attrValue = param.getAttribute("Value");
            this.data.templateContent.paramter.customParamters.add(cparam);
        }
    }

    private boolean parseProjectCollection(Node rootNode) {
        this.data.templateContent.collection = new ProjectCollection();
        NodeList childList = rootNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equals(PROJECT_TEMPLATE_LINK)) continue;
            Element param = (Element)child;
            ProjectTemplateLink link = new ProjectTemplateLink();
            link.value = param.getTextContent().trim();
            link.attrProjectName = param.hasAttribute("ProjectName") ? param.getAttribute("ProjectName") : new File(this.vstemplateFile.getParentFile().getAbsolutePath() + File.separator + link.value).getName();
            link.attrCopyParameters = param.hasAttribute("CopyParameters") ? Boolean.parseBoolean(param.getAttribute("CopyParameters")) : false;
            link.vParser = new VSTemplateParser(this.vstemplateFile.getParentFile().getAbsolutePath() + File.separator + link.value);
            if (!link.vParser.parse()) {
                return false;
            }
            this.data.templateContent.collection.templateLinks.add(link);
        }
        return true;
    }

    private void parseProject(Node rootNode) {
        Element rootElement = (Element)rootNode;
        this.data.templateContent.project = new Project();
        this.data.templateContent.project.file = rootElement.getAttribute("File");
        this.data.templateContent.project.replaceParameters = rootElement.hasAttribute("ReplaceParameters") ? Boolean.parseBoolean(rootElement.getAttribute("ReplaceParameters")) : false;
        NodeList childList = rootNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(PROJECT_ITEM)) {
                if (this.data.templateContent.project.projectItems == null) {
                    this.data.templateContent.project.projectItems = new ArrayList<ProjectItem>();
                }
                this.parseProjectItem(child, this.data.templateContent.project.projectItems);
                continue;
            }
            if (!nodeName.equals(FOLDER)) continue;
            if (this.data.templateContent.project.folders == null) {
                this.data.templateContent.project.folders = new ArrayList<Folder>();
            }
            this.parseFolder(child, this.data.templateContent.project.folders);
        }
    }

    private void parseFolder(Node rootNode, List<Folder> list) {
        Element rootElement = (Element)rootNode;
        Folder folder = new Folder();
        folder.attrName = rootElement.getAttribute("Name");
        if (rootElement.hasAttribute("TargetFolderName")) {
            folder.attrTargetFolderName = rootElement.getAttribute("TargetFolderName");
        }
        list.add(folder);
        NodeList childList = rootNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(PROJECT_ITEM)) {
                if (folder.projectItems == null) {
                    folder.projectItems = new ArrayList<ProjectItem>();
                }
                this.parseProjectItem(child, folder.projectItems);
                continue;
            }
            if (!nodeName.equals(FOLDER)) continue;
            if (folder.folders == null) {
                folder.folders = new ArrayList<Folder>();
            }
            this.parseFolder(child, folder.folders);
        }
    }

    private void parseProjectItem(Node rootNode, List<ProjectItem> list) {
        Element param = (Element)rootNode;
        ProjectItem item = new ProjectItem();
        item.attrTargetFileName = param.hasAttribute("TargetFileName") ? param.getAttribute("TargetFileName") : null;
        item.attrReplaceParameters = param.hasAttribute("ReplaceParameters") ? Boolean.parseBoolean(param.getAttribute("ReplaceParameters")) : false;
        item.value = param.getTextContent().trim();
        list.add(item);
    }

    private void parseFullClassName(Node rootNode) {
        String fullClassName = rootNode.getTextContent().trim();
        int last_index = fullClassName.lastIndexOf(46);
        this.data.wizardExtension.fullClassName = this.getClass().getPackage().getName() + "." + fullClassName.substring(last_index + 1);
    }

    public int copyFiles(String destDir, Map<String, String> symbolMap, CSSolutionInfo solution) throws UnexpectedException {
        int ret = this.processCustomParamter(symbolMap);
        if (ret != 0) {
            return ret;
        }
        ret = this.processProject(destDir, symbolMap, solution);
        if (ret != 0) {
            return ret;
        }
        ret = this.processWizard(symbolMap);
        if (ret != 0) {
            return ret;
        }
        ret = this.processProjectCollection(destDir, symbolMap, solution);
        if (ret != 0) {
            return ret;
        }
        return 0;
    }

    private int processCustomParamter(Map<String, String> symbolMap) {
        if (this.data.templateContent.paramter != null) {
            for (CustomParameter param : this.data.templateContent.paramter.customParamters) {
                symbolMap.put(param.attrName, param.attrValue);
            }
        }
        return 0;
    }

    private int processWizard(Map<String, String> symbolMap) {
        if (this.data.wizardExtension != null) {
            try {
                Class<?> cls = Class.forName(this.data.wizardExtension.fullClassName);
                IWizard wzd = (IWizard)cls.newInstance();
                if (!wzd.contructDictionary(symbolMap)) {
                    return 1;
                }
            }
            catch (ClassNotFoundException e) {
                return -1;
            }
            catch (InstantiationException e) {
                return -1;
            }
            catch (IllegalAccessException e) {
                return -1;
            }
        }
        return 0;
    }

    private int processProjectCollection(String destDir, Map<String, String> symbolMap, CSSolutionInfo solution) {
        if (this.data.templateContent.collection != null) {
            HashMap<String, String> parentSymbols = new HashMap<String, String>(symbolMap);
            for (ProjectTemplateLink link : this.data.templateContent.collection.templateLinks) {
                String projectname = this.replaceParamter(link.attrProjectName, parentSymbols);
                String projectPath = destDir + File.separator + projectname;
                File projectDir = new File(projectPath);
                projectDir.mkdir();
                if (link.attrCopyParameters) {
                    this.copyParameters(parentSymbols, symbolMap);
                }
                symbolMap.put("$projectname$", projectname);
                symbolMap.put("$safeprojectname$", VSTemplateParser.makeSafeProjectName(projectname));
                int ret = link.vParser.copyFiles(projectPath, symbolMap, solution);
                if (ret >= 0) continue;
                return ret;
            }
        }
        return 0;
    }

    private int processProject(String destDir, Map<String, String> symbolMap, CSSolutionInfo solution) {
        if (this.data.templateContent.project != null) {
            try {
                String guid = UUID.randomUUID().toString();
                symbolMap.put("$guid1$", guid);
                String templatePath = this.vstemplateFile.getParentFile().getAbsolutePath();
                String src_csproj = templatePath + File.separator + this.data.templateContent.project.file;
                String target_csproj = this.data.templateContent.project.targetFileName != null ? destDir + File.separator + this.data.templateContent.project.targetFileName : destDir + File.separator + symbolMap.get("$safeprojectname$") + ".csproj";
                this.copyFileWithParsingCondition(src_csproj, target_csproj, symbolMap);
                if (this.data.templateContent.project.replaceParameters) {
                    this.replaceParametersInFile(target_csproj, symbolMap);
                }
                solution.addProject(symbolMap.get("$projectname$"), target_csproj, guid);
                if (this.data.templateContent.project.projectItems != null) {
                    for (ProjectItem item : this.data.templateContent.project.projectItems) {
                        this.processProjectItem(item, destDir, symbolMap);
                    }
                }
                if (this.data.templateContent.project.folders != null) {
                    for (Folder folder : this.data.templateContent.project.folders) {
                        this.processFolder(folder, destDir, symbolMap);
                    }
                }
            }
            catch (IOException e) {
                return -1;
            }
        }
        return 0;
    }

    private int processFolder(Folder folder, String destDir, Map<String, String> symbolMap) throws IOException {
        String folderpath = folder.attrTargetFolderName != null ? destDir + File.separator + this.replaceParamter(folder.attrTargetFolderName, symbolMap) : destDir + File.separator + folder.attrName;
        new File(folderpath).mkdir();
        if (folder.projectItems != null) {
            for (ProjectItem item : folder.projectItems) {
                this.processProjectItem(item, folderpath, symbolMap);
            }
        }
        if (folder.folders != null) {
            for (Folder fd : folder.folders) {
                this.processFolder(fd, folderpath, symbolMap);
            }
        }
        return 0;
    }

    private int processProjectItem(ProjectItem item, String destDir, Map<String, String> symbolMap) throws IOException {
        String templatePath = this.vstemplateFile.getParentFile().getAbsolutePath();
        String srcpath = templatePath + File.separator + item.value;
        String dstpath = item.attrTargetFileName != null ? destDir + File.separator + this.replaceParamter(item.attrTargetFileName, symbolMap) : destDir + File.separator + item.value;
        this.copyFileWithParsingCondition(srcpath, dstpath, symbolMap);
        if (item.attrReplaceParameters) {
            this.replaceParametersInFile(dstpath, symbolMap);
        }
        return 0;
    }

    private void copyFileWithParsingCondition(String srcpath, String dstpath, Map<String, String> symbolMap) throws IOException {
        if (!dstpath.endsWith(".cs") && !dstpath.endsWith(".csproj")) {
            FileUtil.copyTo((String)srcpath, (String)dstpath);
        } else {
            String currentline;
            boolean isProjectFile = dstpath.endsWith(".csproj");
            File parent = new File(dstpath).getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException("File copy error. Cannot create directory - " + parent.getAbsolutePath());
            }
            ArrayList<String> newLines = new ArrayList<String>();
            Boolean bCopy = true;
            Stack<Boolean> conditionStack = new Stack<Boolean>();
            int i = 0;
            List<String> readLines = Files.readAllLines(Paths.get(srcpath, new String[0]), StandardCharsets.UTF_8);
            int numberOfLines = readLines.size();
            String string = currentline = i >= numberOfLines ? null : readLines.get(i);
            while (currentline != null) {
                String trimline = currentline.trim();
                if (trimline.startsWith("$if$")) {
                    if (bCopy.booleanValue()) {
                        Boolean bRet = this.evaluateExpression(trimline.substring(4).trim(), symbolMap);
                        bCopy = this.updateStack("if", conditionStack, bRet);
                    } else {
                        bCopy = this.updateStack("if", conditionStack, false);
                    }
                } else if (trimline.startsWith("$else$")) {
                    bCopy = this.updateStack("else", conditionStack, bCopy);
                    if (trimline.substring(6).trim().startsWith("$if$")) {
                        currentline = trimline.substring(6);
                        continue;
                    }
                } else if (trimline.startsWith("$endif$")) {
                    bCopy = this.updateStack("endif", conditionStack, bCopy);
                } else if (bCopy.booleanValue()) {
                    if (isProjectFile && trimline.contains("<DebugType>")) {
                        currentline = currentline.replace("portable", "full");
                    }
                    newLines.add(currentline);
                }
                currentline = ++i >= numberOfLines ? null : readLines.get(i);
            }
            Files.write(Paths.get(dstpath, new String[0]), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private boolean updateStack(String keyword, Stack<Boolean> conditions, boolean bRet) {
        if (keyword.equals("if")) {
            conditions.push(bRet);
        } else if (keyword.equals("else")) {
            boolean prev = conditions.pop();
            conditions.push(!prev);
        } else if (keyword.equals("endif")) {
            conditions.pop();
        }
        return this.getAndValue(conditions);
    }

    private boolean getAndValue(Stack<Boolean> conditions) {
        for (Boolean bool : conditions) {
            if (bool.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateExpression(String expr, Map<String, String> symbolMap) {
        Pattern pt = Pattern.compile(PATTERN_EXPRESSION);
        Matcher mt = pt.matcher(expr);
        if (mt.find()) {
            String rValue;
            String rKey;
            String key = mt.group(2);
            String value = mt.group(4);
            if (key != null && value != null && (rKey = this.replaceParamter(key, symbolMap)).equalsIgnoreCase(rValue = this.replaceParamter(value, symbolMap))) {
                return true;
            }
        }
        return false;
    }

    private void replaceParametersInFile(String filepath, Map<String, String> symbolMap) throws IOException {
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line : Files.readAllLines(Paths.get(filepath, new String[0]), StandardCharsets.UTF_8)) {
            if (line.contains("$")) {
                newLines.add(this.replaceParamter(line, symbolMap));
                continue;
            }
            newLines.add(line);
        }
        Files.write(Paths.get(filepath, new String[0]), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private String replaceParamter(String original, Map<String, String> symbolMap) {
        Pattern patternParam = Pattern.compile(PATTERN_PARAMETER);
        Matcher matcher = patternParam.matcher(original);
        StringBuffer sbuffer = new StringBuffer();
        while (matcher.find()) {
            String token = matcher.group();
            String value = symbolMap.get(token);
            if (value == null) {
                value = "";
            } else if (token.contains("guid") && original.contains("<ProjectGuid>")) {
                value = "{" + value + "}";
            }
            matcher.appendReplacement(sbuffer, value);
        }
        matcher.appendTail(sbuffer);
        return sbuffer.toString();
    }

    private Map<String, String> copyParameters(Map<String, String> parentSymbols, Map<String, String> symbolMap) {
        for (Map.Entry<String, String> entry : parentSymbols.entrySet()) {
            String key = entry.getKey();
            symbolMap.put(key.replaceFirst(Pattern.quote("$"), Matcher.quoteReplacement("$ext_")), entry.getValue());
        }
        return symbolMap;
    }

    static class CustomParameter {
        String attrName;
        String attrValue;

        CustomParameter() {
        }
    }

    static class Folder {
        String attrName;
        String attrTargetFolderName = null;
        List<ProjectItem> projectItems = null;
        List<Folder> folders = null;

        Folder() {
        }
    }

    static class ProjectItem {
        String attrTargetFileName;
        boolean attrReplaceParameters = false;
        String value;

        ProjectItem() {
        }
    }

    static class ProjectTemplateLink {
        String attrProjectName;
        boolean attrCopyParameters;
        String value;
        VSTemplateParser vParser;

        ProjectTemplateLink() {
        }
    }

    static class CustomParameters {
        List<CustomParameter> customParamters = new ArrayList<CustomParameter>();

        CustomParameters() {
        }
    }

    static class Project {
        String file;
        boolean replaceParameters = false;
        String targetFileName = null;
        List<ProjectItem> projectItems = null;
        List<Folder> folders = null;

        Project() {
        }
    }

    static class ProjectCollection {
        List<ProjectTemplateLink> templateLinks = new ArrayList<ProjectTemplateLink>();

        ProjectCollection() {
        }
    }

    static class WizardExtension {
        String assemblyName;
        String fullClassName;

        WizardExtension() {
        }
    }

    static class TemplateContent {
        ProjectCollection collection = null;
        Project project = null;
        CustomParameters paramter = null;

        TemplateContent() {
        }
    }

    static class TemplateData {
        String templateID;
        boolean createNewFolder;

        TemplateData() {
        }
    }

    static class VSTemplate {
        TemplateData templateData = new TemplateData();
        TemplateContent templateContent = new TemplateContent();
        WizardExtension wizardExtension = null;

        VSTemplate() {
        }
    }
}

