/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.tizen.core.gputil.IOUtil;

public abstract class HostUtil {
    private static final int CMDLINEMAX = 65535;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int executeProcess(ProcessBuilder pb, String[] cmds, Logger logger) {
        String sbiTrace = "command : ";
        for (String c : cmds) {
            sbiTrace = sbiTrace + c + " ";
        }
        logger.info(sbiTrace);
        pb.command(cmds);
        pb.redirectErrorStream(true);
        Process proc = null;
        BufferedReader input = null;
        try {
            proc = pb.start();
            input = new BufferedReader(new InputStreamReader(proc.getInputStream()), 65535);
            if (logger != null) {
                String line = null;
                while ((line = input.readLine()) != null) {
                    logger.info(line);
                }
            }
            proc.waitFor();
        }
        catch (IOException e) {
            if (logger != null) {
                logger.error("IOException occurred:", (Throwable)e);
            }
            int n = -1;
            IOUtil.tryClose((Object[])new Object[]{input});
            if (proc != null) {
                proc.destroy();
            }
            return n;
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
            int n = -1;
            {
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{input});
                    if (proc != null) {
                        proc.destroy();
                    }
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{input});
            if (proc != null) {
                proc.destroy();
            }
            return n;
        }
        IOUtil.tryClose((Object[])new Object[]{input});
        if (proc != null) {
            proc.destroy();
        }
        return proc.exitValue();
    }
}

