/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.CompactDecimalDataCache;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactDecimalFormat
extends DecimalFormat {
    private static final long serialVersionUID = 4716293295276629682L;
    private static final CompactDecimalDataCache cache = new CompactDecimalDataCache();
    private final Map<String, DecimalFormat.Unit[]> units;
    private final long[] divisor;
    private final Map<String, DecimalFormat.Unit> pluralToCurrencyAffixes;
    private final PluralRules pluralRules;

    public static CompactDecimalFormat getInstance(ULocale locale, CompactStyle style) {
        return new CompactDecimalFormat(locale, style);
    }

    public static CompactDecimalFormat getInstance(Locale locale, CompactStyle style) {
        return new CompactDecimalFormat(ULocale.forLocale(locale), style);
    }

    CompactDecimalFormat(ULocale locale, CompactStyle style) {
        this.pluralRules = PluralRules.forLocale(locale);
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(locale);
        CompactDecimalDataCache.Data data = this.getData(locale, style);
        this.units = data.units;
        this.divisor = data.divisors;
        this.pluralToCurrencyAffixes = null;
        this.finishInit(style, format.toPattern(), format.getDecimalFormatSymbols());
    }

    @Deprecated
    public CompactDecimalFormat(String pattern, DecimalFormatSymbols formatSymbols, CompactStyle style, PluralRules pluralRules, long[] divisor, Map<String, String[][]> pluralAffixes, Map<String, String[]> currencyAffixes, Collection<String> debugCreationErrors) {
        this.pluralRules = pluralRules;
        this.units = this.otherPluralVariant(pluralAffixes, divisor, debugCreationErrors);
        if (!pluralRules.getKeywords().equals(this.units.keySet())) {
            debugCreationErrors.add("Missmatch in pluralCategories, should be: " + pluralRules.getKeywords() + ", was actually " + this.units.keySet());
        }
        this.divisor = (long[])divisor.clone();
        if (currencyAffixes == null) {
            this.pluralToCurrencyAffixes = null;
        } else {
            this.pluralToCurrencyAffixes = new HashMap<String, DecimalFormat.Unit>();
            for (Map.Entry<String, String[]> s : currencyAffixes.entrySet()) {
                String[] pair = s.getValue();
                this.pluralToCurrencyAffixes.put(s.getKey(), new DecimalFormat.Unit(pair[0], pair[1]));
            }
        }
        this.finishInit(style, pattern, formatSymbols);
    }

    private void finishInit(CompactStyle style, String pattern, DecimalFormatSymbols formatSymbols) {
        this.applyPattern(pattern);
        this.setDecimalFormatSymbols(formatSymbols);
        this.setMaximumSignificantDigits(2);
        this.setSignificantDigitsUsed(true);
        if (style == CompactStyle.SHORT) {
            this.setGroupingUsed(false);
        }
        this.setCurrency(null);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompactDecimalFormat other = (CompactDecimalFormat)obj;
        return this.mapsAreEqual(this.units, other.units) && Arrays.equals(this.divisor, other.divisor) && (this.pluralToCurrencyAffixes == other.pluralToCurrencyAffixes || this.pluralToCurrencyAffixes != null && this.pluralToCurrencyAffixes.equals(other.pluralToCurrencyAffixes)) && this.pluralRules.equals(other.pluralRules);
    }

    private boolean mapsAreEqual(Map<String, DecimalFormat.Unit[]> lhs, Map<String, DecimalFormat.Unit[]> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (Map.Entry<String, DecimalFormat.Unit[]> entry : lhs.entrySet()) {
            Object[] value = rhs.get(entry.getKey());
            if (value != null && Arrays.equals(entry.getValue(), value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        Output<DecimalFormat.Unit> currencyUnit = new Output<DecimalFormat.Unit>();
        Amount amount = this.toAmount(number, currencyUnit);
        if (currencyUnit.value != null) {
            ((DecimalFormat.Unit)currencyUnit.value).writePrefix(toAppendTo);
        }
        DecimalFormat.Unit unit = amount.getUnit();
        unit.writePrefix(toAppendTo);
        super.format(amount.getQty(), toAppendTo, pos);
        unit.writeSuffix(toAppendTo);
        if (currencyUnit.value != null) {
            ((DecimalFormat.Unit)currencyUnit.value).writeSuffix(toAppendTo);
        }
        return toAppendTo;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        if (!(obj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        Number number = (Number)obj;
        Amount amount = this.toAmount(number.doubleValue(), null);
        return super.formatToCharacterIterator(amount.getQty(), amount.getUnit());
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(com.ibm.icu.math.BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    @Override
    public Number parse(String text, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new NotSerializableException();
    }

    private Amount toAmount(double number, Output<DecimalFormat.Unit> currencyUnit) {
        int base;
        boolean negative = this.isNumberNegative(number);
        int n = base = (number = this.adjustNumberAsInFormatting(number)) <= 1.0 ? 0 : (int)Math.log10(number);
        if (base >= 15) {
            base = 14;
        }
        String pluralVariant = this.getPluralForm(this.getFixedDecimal(number /= (double)this.divisor[base], this.toDigitList(number)));
        if (this.pluralToCurrencyAffixes != null && currencyUnit != null) {
            currencyUnit.value = this.pluralToCurrencyAffixes.get(pluralVariant);
        }
        if (negative) {
            number = -number;
        }
        return new Amount(number, CompactDecimalDataCache.getUnit(this.units, pluralVariant, base));
    }

    private void recordError(Collection<String> creationErrors, String errorMessage) {
        if (creationErrors == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        creationErrors.add(errorMessage);
    }

    private Map<String, DecimalFormat.Unit[]> otherPluralVariant(Map<String, String[][]> pluralCategoryToPower10ToAffix, long[] divisor, Collection<String> debugCreationErrors) {
        if (divisor.length < 15) {
            this.recordError(debugCreationErrors, "Must have at least 15 prefix items.");
        }
        long oldDivisor = 0L;
        int i = 0;
        while (i < divisor.length) {
            long roundTrip;
            int log = (int)Math.log10(divisor[i]);
            if (log > i) {
                this.recordError(debugCreationErrors, "Divisor[" + i + "] must be less than or equal to 10^" + i + ", but is: " + divisor[i]);
            }
            if ((roundTrip = (long)Math.pow(10.0, log)) != divisor[i]) {
                this.recordError(debugCreationErrors, "Divisor[" + i + "] must be a power of 10, but is: " + divisor[i]);
            }
            if (divisor[i] < oldDivisor) {
                this.recordError(debugCreationErrors, "Bad divisor, the divisor for 10E" + i + "(" + divisor[i] + ") is less than the divisor for the divisor for 10E" + (i - 1) + "(" + oldDivisor + ")");
            }
            oldDivisor = divisor[i];
            ++i;
        }
        HashMap<String, DecimalFormat.Unit[]> result = new HashMap<String, DecimalFormat.Unit[]>();
        HashMap<String, Integer> seen = new HashMap<String, Integer>();
        String[][] defaultPower10ToAffix = pluralCategoryToPower10ToAffix.get("other");
        for (Map.Entry<String, String[][]> pluralCategoryAndPower10ToAffix : pluralCategoryToPower10ToAffix.entrySet()) {
            String pluralCategory = pluralCategoryAndPower10ToAffix.getKey();
            String[][] power10ToAffix = pluralCategoryAndPower10ToAffix.getValue();
            if (power10ToAffix.length != divisor.length) {
                this.recordError(debugCreationErrors, "Prefixes & suffixes must be present for all divisors " + pluralCategory);
            }
            DecimalFormat.Unit[] units = new DecimalFormat.Unit[power10ToAffix.length];
            int i2 = 0;
            while (i2 < power10ToAffix.length) {
                String[] pair = power10ToAffix[i2];
                if (pair == null) {
                    pair = defaultPower10ToAffix[i2];
                }
                if (pair.length != 2 || pair[0] == null || pair[1] == null) {
                    this.recordError(debugCreationErrors, "Prefix or suffix is null for " + pluralCategory + ", " + i2 + ", " + Arrays.asList(pair));
                } else {
                    int log = (int)Math.log10(divisor[i2]);
                    String key = String.valueOf(pair[0]) + "\uffff" + pair[1] + "\uffff" + (i2 - log);
                    Integer old = (Integer)seen.get(key);
                    if (old == null) {
                        seen.put(key, i2);
                    } else if (old != i2) {
                        this.recordError(debugCreationErrors, "Collision between values for " + i2 + " and " + old + " for [prefix/suffix/index-log(divisor)" + key.replace('\uffff', ';'));
                    }
                    units[i2] = new DecimalFormat.Unit(pair[0], pair[1]);
                }
                ++i2;
            }
            result.put(pluralCategory, units);
        }
        return result;
    }

    private String getPluralForm(PluralRules.FixedDecimal fixedDecimal) {
        if (this.pluralRules == null) {
            return "other";
        }
        return this.pluralRules.select(fixedDecimal);
    }

    private CompactDecimalDataCache.Data getData(ULocale locale, CompactStyle style) {
        CompactDecimalDataCache.DataBundle bundle = cache.get(locale);
        switch (style) {
            case SHORT: {
                return bundle.shortData;
            }
            case LONG: {
                return bundle.longData;
            }
        }
        return bundle.shortData;
    }

    private static class Amount {
        private final double qty;
        private final DecimalFormat.Unit unit;

        public Amount(double qty, DecimalFormat.Unit unit) {
            this.qty = qty;
            this.unit = unit;
        }

        public double getQty() {
            return this.qty;
        }

        public DecimalFormat.Unit getUnit() {
            return this.unit;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompactStyle {
        SHORT,
        LONG;

    }
}

