/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.ui.view.console;

import java.io.IOException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.tizen.common.ui.view.console.ConsoleProcessClosure;
import org.tizen.common.ui.view.console.HyperlinkManager;
import org.tizen.common.ui.view.console.IHyperlinkManager;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.ui.view.console.LinkInfo;
import org.tizen.common.ui.view.console.MessageConsoleSpy;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.SWTUtil;

public class ConsoleManager2
implements ITizenConsoleManager,
IHyperlinkManager {
    protected final MessageConsoleSpy console;
    protected final HyperlinkManager hyperlinkManager;
    private String consoleName;
    protected int documentLength = 0;

    public ConsoleManager2(String consoleName, boolean focus) {
        this.consoleName = consoleName;
        this.console = this.createMessageConsole();
        this.hyperlinkManager = new HyperlinkManager((TextConsole)this.console);
        this.console.getDocument().addDocumentListener((IDocumentListener)this.hyperlinkManager);
        if (focus) {
            this.getConsoleManager().showConsoleView((IConsole)this.console);
        }
        this.setName(consoleName);
    }

    protected IConsoleManager getConsoleManager() {
        return ConsolePlugin.getDefault().getConsoleManager();
    }

    protected IConsole[] getConsoles() {
        return this.getConsoleManager().getConsoles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(final String newName) {
        Assert.notNull(newName);
        ConsoleManager2 consoleManager2 = this;
        synchronized (consoleManager2) {
            this.consoleName = newName;
        }
        SWTUtil.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ConsoleManager2.this.console == null) {
                    return;
                }
                ConsoleManager2.this.console.setName(newName);
            }
        });
    }

    protected synchronized MessageConsoleSpy createMessageConsole() {
        IConsole[] consoles = this.getConsoles();
        int i = 0;
        int n = consoles.length;
        while (i < n) {
            if (this.consoleName.equals(consoles[i].getName())) {
                this.getConsoleManager().removeConsoles(new IConsole[]{this.console});
            }
            ++i;
        }
        MessageConsoleSpy console = new MessageConsoleSpy(this.consoleName);
        this.getConsoleManager().addConsoles(new IConsole[]{console});
        return console;
    }

    @Override
    public IConsole getConsole() {
        return this.console;
    }

    @Override
    public synchronized void println(String line) {
        MessageConsoleStream output = this.createConsoleStream();
        try {
            output.println(line);
            this.documentLength += line.length() + 1;
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(output);
            throw throwable;
        }
        IOUtil.tryClose(output);
    }

    @Override
    public void printProcessStreams(Process process) {
        this.clear();
        ConsoleProcessClosure closure = new ConsoleProcessClosure(process, this);
        closure.runBlocking();
    }

    protected MessageConsoleStream getConsoleStream(int fontStyle, Color color) {
        MessageConsoleStream stream = this.createConsoleStream();
        this.configureConsole(stream, fontStyle, color);
        return stream;
    }

    protected MessageConsoleStream createConsoleStream() {
        MessageConsoleStream stream = this.console.newMessageStream();
        return stream;
    }

    protected void configureConsole(final MessageConsoleStream stream, final int fontStyle, final Color color) {
        SWTUtil.syncExec(new Runnable(){

            @Override
            public void run() {
                stream.setFontStyle(fontStyle);
                stream.setColor(color);
            }
        });
    }

    @Override
    public synchronized void print(String message, int fontStyle, Color color) {
        MessageConsoleStream stream = this.getConsoleStream(fontStyle, color);
        try {
            stream.print(message);
            this.documentLength += message.length();
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(stream);
            throw throwable;
        }
        IOUtil.tryClose(stream);
    }

    @Override
    public void println(String message, int fontStyle, Color color) {
        this.print(String.valueOf(message) + "\n", fontStyle, color);
    }

    public synchronized void clear() {
        SWTUtil.syncExec(new Runnable(){

            @Override
            public void run() {
                IDocument document = ConsoleManager2.this.console.getDocument();
                if (document == null) {
                    return;
                }
                ConsoleManager2.this.console.clearConsole();
            }
        });
        this.documentLength = 0;
    }

    @Override
    public void show() {
        this.show(true);
    }

    public void show(final boolean focus) {
        SWTUtil.syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = SWTUtil.getActivePage();
                if (page == null) {
                    throw new IllegalStateException();
                }
                IConsoleView view = (IConsoleView)page.findView("org.eclipse.ui.console.ConsoleView");
                view.display(ConsoleManager2.this.getConsole());
                if (focus) {
                    view.setFocus();
                }
            }
        });
    }

    @Override
    public void addLinker(LinkInfo link) {
        this.hyperlinkManager.addLinker(link);
    }

    @Override
    public void print(String line) {
        MessageConsoleStream output = this.console.newMessageStream();
        output.print(line);
        try {
            output.close();
        }
        catch (IOException e) {
            ConsolePlugin.log((Throwable)e);
        }
    }
}

