/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildcs;

import java.io.File;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.util.OSChecker;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSCommand;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSData;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSOption;
import org.tizen.ncli.util.HostUtil;

public class BuildCSCLICommand
extends AbstractSubCommand<BuildCSData> {
    private Configuration config = new Configuration();
    private BuildCSData data = new BuildCSData();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected BuildCSData call() {
        if (!OSChecker.isWindows()) {
            this.progressLog.info(TizenCLIMessages.NOT_YET_SUPPORTED);
            throw new UnexpectedException(2, TizenCLIMessages.NOT_YET_SUPPORTED);
        }
        String msbuildPath = this.config.getValue("default.csharp.buildtool.path");
        String workingPath = this.workingDir.toString();
        this.data.setWorkingDir(workingPath);
        if (!this.data.hasRequiredOptions) {
            this.progressLog.info(TizenCLIMessages.CANNOT_GET_OPTIONS);
            throw new UnexpectedException(2, TizenCLIMessages.CANNOT_GET_OPTIONS);
        }
        if (!this.validateRequiredOptions()) {
            this.log.trace(TizenCLIMessages.INVALID_ARGS);
            throw new UnexpectedException(2, TizenCLIMessages.INVALID_ARGS);
        }
        this.convertOption(this.data);
        if (BuildCSCommand.analisysProjectInfo(workingPath, this.data) == null) {
            this.progressLog.info(TizenCLIMessages.CANNOT_GET_OPTIONS);
            throw new UnexpectedException(2, TizenCLIMessages.CANNOT_GET_OPTIONS);
        }
        String configuration = this.data.getConfig();
        if (this.data.getOutputPath() == null) {
            this.data.setOutputPath(workingPath + File.separator + "bin" + File.separator + configuration);
        }
        String buildTargetFilePath = null;
        File slnFile = new File(workingPath + File.separator + this.workingDir.getName() + ".sln");
        File csprojFile = new File(workingPath + File.separator + this.workingDir.getName() + ".csproj");
        if (workingPath.endsWith(".sln") || workingPath.endsWith(".csproj")) {
            buildTargetFilePath = workingPath;
        } else if (slnFile.exists()) {
            buildTargetFilePath = slnFile.getPath();
        } else {
            if (!csprojFile.exists()) {
                this.progressLog.info("Cannot find the build target file(.sln or .csproj).");
                throw new UnexpectedException(2, "Cannot find the build target file(.sln or .csproj).");
            }
            buildTargetFilePath = csprojFile.getPath();
        }
        String[] msbuildCommand = configuration != null ? new String[]{msbuildPath, buildTargetFilePath, "/p:Configuration=" + configuration} : new String[]{msbuildPath, buildTargetFilePath};
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Map<String, String> env = pb.environment();
        new Configuration().getEnvValueFromCLIConfig(env);
        HostUtil.executeProcess(pb, msbuildCommand, this.progressLog);
        if (this.data == null) return this.data;
        BuildCSCommand.writeBuildInfo(this.data.getOutputPath(), this.data);
        return this.data;
    }

    private void convertOption(BuildCSData data) {
        BuildCSOption.BuildCSRequiredOption[] options = BuildCSOption.BuildCSRequiredOption.values();
        for (int i = 0; i < options.length; ++i) {
            BuildCSOption.BuildCSRequiredOption option = options[i];
            if (option.name().equalsIgnoreCase("configuration")) {
                data.setConfig(option.getValue());
                this.log.debug("configuration : " + data.getConfig());
                continue;
            }
            this.log.debug("invalid option : " + option.name());
        }
    }

    private boolean validateRequiredOptions() {
        boolean result = true;
        BuildCSOption.BuildCSRequiredOption[] options = BuildCSOption.BuildCSRequiredOption.values();
        for (int i = 0; i < options.length; ++i) {
            boolean isValid = false;
            BuildCSOption.BuildCSRequiredOption option = options[i];
            String value = option.getValue();
            String[] candidates = option.getCandidates();
            for (int j = 0; j < candidates.length; ++j) {
                if (!value.equals(candidates[j])) continue;
                isValid = true;
                break;
            }
            if (isValid) continue;
            StringBuilder strBuilder = new StringBuilder();
            for (int j = 0; j < candidates.length; ++j) {
                strBuilder.append(" \"" + candidates[j] + "\"");
            }
            result = false;
            this.progressLog.info(NLS.bind((String)TizenCLIMessages.INVALID_ARG, (Object)((Object)option), (Object)strBuilder.toString().trim()));
            break;
        }
        return result;
    }

    public void setRequiredOptions(String[] input) {
        BuildCSOption.BuildCSRequiredOption[] requiredOptions = BuildCSOption.BuildCSRequiredOption.values();
        for (int i = 0; i < requiredOptions.length; ++i) {
            BuildCSOption.BuildCSRequiredOption requiredOption = requiredOptions[i];
            String str = input[i];
            if (str == null) {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.BN_NO_BUILD_INPUT, (Object)requiredOption.getName()));
                str = this.config.getValue(requiredOption.getKey());
            }
            if (str == null) {
                this.progressLog.info(requiredOption.getErrorMessage());
                continue;
            }
            requiredOption.setValue(str);
        }
    }

    public void setOutputPath(String output) {
        this.data.setOutputPath(output);
    }
}

