/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractCLI;

@TizenSubCommand(name="clean", usage="Clean the build output directory.")
public class CleanCLI
extends AbstractCLI {
    @Argument(index=0, required=false, metaVar="<command>")
    String commandName;
    @Option(name="--script-file", aliases={"-f"}, metaVar="ABS Script file path", usage="Specifies the path of ABS script file.", hidden=true)
    private String scriptPath;
    @Option(name="--output", aliases={"-o"}, metaVar="path", usage="Output file paths.", hidden=true)
    private String outputPath;

    @Override
    public int execute() {
        File webProjectResult;
        File releaseBuildPath;
        int clean_count = 0;
        this.log.trace("Execute Clean...");
        File debugBuildPath = new File(this.getRealWorkingPath(), "Debug");
        if (debugBuildPath.exists()) {
            if (this.deleteDirectory(debugBuildPath)) {
                ++clean_count;
                this.progressLog.info("native-app (Debug) clean success.");
            } else {
                this.progressLog.error("native-app (Debug) clean failed.");
                throw new UnexpectedException(2, "native-app (Debug) clean failed.");
            }
        }
        if ((releaseBuildPath = new File(this.getRealWorkingPath(), "Release")).exists()) {
            if (this.deleteDirectory(releaseBuildPath)) {
                ++clean_count;
                this.progressLog.info("native-app (Release) clean success.");
            } else {
                this.progressLog.error("native-app (Release) clean failed.");
                throw new UnexpectedException(2, "native-app (Release) clean failed.");
            }
        }
        if ((webProjectResult = new File(this.getRealWorkingPath(), ".buildResult")).exists()) {
            if (this.deleteDirectory(webProjectResult)) {
                ++clean_count;
                this.progressLog.info("web-app clean success.");
            } else {
                this.progressLog.error("web-app clean failed.");
                throw new UnexpectedException(2, "web-app clean failed.");
            }
        }
        if (clean_count == 0) {
            this.progressLog.info("There is no directory to clean.");
        }
        return 0;
    }

    private boolean deleteDirectory(File path) {
        if (!path.exists()) {
            return false;
        }
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }
}

