/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.SdbResponse;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.SmartDevelopmentBridgetConstants;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.Preferences;
import org.tizen.sdblib.util.ThreadUtil;

public class SdbHelper {
    public static final int WAIT_TIME = 50;
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final String UTF_DECODING = "UTF-8";
    public static final String OUTPUT_DECODING = "UTF-8";
    public static final Charset UTF_CHARSET = Charset.forName("UTF-8");

    public static byte[] string2bytes(String str) throws UnsupportedEncodingException {
        return str.getBytes(UTF_CHARSET);
    }

    public static String bytes2string(byte[] bytes) {
        return new String(bytes, UTF_CHARSET);
    }

    public static byte[] string2bytes(String str, String characterSet) throws UnsupportedEncodingException {
        return str.getBytes(characterSet);
    }

    public static String bytes2string(byte[] bytes, String characterSet) throws UnsupportedEncodingException {
        return new String(bytes, characterSet);
    }

    public static boolean check(byte[] bytes1, int start1, byte[] bytes2, int start2, int length) {
        if (bytes1 == null || start1 < 0 || bytes1.length < start1 + length) {
            return false;
        }
        if (bytes2 == null || start2 < 0 || bytes2.length < start2 + length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (bytes1[start1++] != bytes2[start2++]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] formSdbRequest(String req) {
        try {
            byte[] reqByte = SdbHelper.string2bytes(req);
            byte[] lengthByte = String.format("%04X", reqByte.length).getBytes();
            byte[] result = new byte[reqByte.length + 4];
            System.arraycopy(lengthByte, 0, result, 0, 4);
            System.arraycopy(reqByte, 0, result, 4, reqByte.length);
            return result;
        }
        catch (UnsupportedEncodingException uee) {
            Log.e("Unsupported encoding. ", uee);
            return null;
        }
    }

    public static SdbResponse readSdbResponse(SocketChannel chan) throws IOException {
        return SdbHelper.readSdbResponse(chan, false);
    }

    public static SdbResponse readSdbResponse(SocketChannel chan, boolean readMessageAfterOkay) throws IOException {
        int len;
        SdbResponse resp = new SdbResponse();
        byte[] reply = new byte[4];
        SdbHelper.read(chan, reply);
        if (SdbHelper.check(SmartDevelopmentBridgetConstants.ID_OKAY, 0, reply, 0, 4)) {
            resp.okay = true;
            if (!readMessageAfterOkay) {
                return resp;
            }
        } else {
            resp.okay = false;
        }
        byte[] lenBuf = new byte[4];
        SdbHelper.read(chan, lenBuf);
        String lenStr = SdbHelper.replyToString(lenBuf);
        try {
            len = Integer.parseInt(lenStr, 16);
        }
        catch (NumberFormatException numberFormatException) {
            Log.w("sdb", "Expected digits, got '" + lenStr + "': " + lenBuf[0] + " " + lenBuf[1] + " " + lenBuf[2] + " " + lenBuf[3]);
            Log.w("sdb", "reply was " + SdbHelper.replyToString(reply));
            return resp;
        }
        byte[] msg = new byte[len];
        SdbHelper.read(chan, msg);
        resp.message = SdbHelper.replyToString(msg);
        Log.v("sdb", "Got reply '" + SdbHelper.replyToString(reply) + "', diag='" + resp.message + "'");
        return resp;
    }

    public static void createForward(SmartDevelopmentBridge sdb, Device device, int local, int remote) throws IOException {
        SocketChannel sdbChan = null;
        try {
            sdbChan = sdb.openChannel();
            byte[] request = SdbHelper.formSdbRequest(String.format("host-serial:%1$s:forward:tcp:%2$d;tcp:%3$d", device.getSerialNumber(), local, remote));
            SdbHelper.write(sdbChan, request);
            SdbResponse resp = SdbHelper.readSdbResponse(sdbChan);
            if (!resp.okay) {
                Log.w("create-forward", "Error creating forward: " + resp.message);
                throw new SdbCommandRejectedException(resp.message);
            }
        }
        finally {
            IOUtil.tryClose(sdbChan);
        }
    }

    public static void removeForward(SmartDevelopmentBridge sdb, Device device, int local, int remote) throws TimeoutException, SdbCommandRejectedException, IOException {
        SocketChannel sdbChan = null;
        try {
            sdbChan = sdb.openChannel();
            byte[] request = SdbHelper.formSdbRequest(String.format("host-serial:%1$s:killforward:tcp:%2$d;tcp:%3$d", device.getSerialNumber(), local, remote));
            SdbHelper.write(sdbChan, request);
            SdbResponse resp = SdbHelper.readSdbResponse(sdbChan);
            if (!resp.okay) {
                Log.w("remove-forward", "Error creating forward: " + resp.message);
                throw new SdbCommandRejectedException(resp.message);
            }
        }
        finally {
            IOUtil.tryClose(sdbChan);
            if (sdbChan != null) {
                sdbChan.close();
            }
        }
    }

    public static String replyToString(byte[] reply) {
        try {
            return new String(reply, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            Log.e("Unsupported encoding.", uee);
            return "";
        }
    }

    public static String replyToString(byte[] reply, int offset, int length) {
        try {
            return new String(reply, offset, length, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            Log.e("Unsupported encoding.", uee);
            return "";
        }
    }

    static void read(SocketChannel chan, byte[] data) throws IOException {
        SdbHelper.read(chan, data, -1, Preferences.getTimeOut());
    }

    /*
     * Unable to fully structure code
     */
    public static void read(SocketChannel chan, byte[] data, int length, int timeout) throws IOException {
        buf = ByteBuffer.wrap(data, 0, length >= 0 ? length : data.length);
        Assert.notNull(chan.socket());
        try {
            time = timeout < 0 ? 0 : timeout;
            chan.socket().setSoTimeout(time);
            if (true) ** GOTO lbl23
        }
        catch (SocketException v0) {
            Log.v("Socket", "Socket is not connect");
            throw new SocketException("Socket is not connect");
        }
        do {
            count = 0;
            try {
                count = chan.read(buf);
            }
            catch (SocketTimeoutException v1) {
                Log.d("sdb", "read: timeout");
                throw new TimeoutException();
            }
            if (count < 0) {
                Log.d("sdb", "read: channel EOF");
                throw new EOFException("read: channel EOF");
            }
            if (count != 0) continue;
            ThreadUtil.trySleep(50L);
lbl23:
            // 3 sources

        } while (buf.position() != buf.limit());
    }

    public static String readAsString(SocketChannel socket, byte[] buffer) throws IOException {
        SdbHelper.read(socket, buffer);
        return new String(buffer, DEFAULT_ENCODING);
    }

    public static void write(SocketChannel chan, byte[] data) throws IOException {
        SdbHelper.write(chan, data, -1, Preferences.getTimeOut());
    }

    public static void write(SocketChannel chan, byte[] data, int length, int timeout) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(data, 0, length < 0 ? data.length : length);
        final AtomicBoolean running = new AtomicBoolean(true);
        Timer timer = null;
        if (timeout > 0) {
            timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public synchronized void run() {
                    running.set(false);
                }
            }, timeout);
        }
        while (buf.position() != buf.limit() && running.get()) {
            int count = chan.write(buf);
            if (count < 0) {
                Log.d("sdb", "write: channel EOF");
                throw new IOException("channel EOF");
            }
            if (count != 0) continue;
            ThreadUtil.trySleep(50L);
        }
        if (buf.position() == buf.limit()) {
            if (timer != null) {
                timer.cancel();
            }
            return;
        }
        Log.d("sdb", "write: Timeout");
        throw new TimeoutException();
    }

    public static void initializeDevice(SocketChannel channel, String serialNumber) throws TimeoutException, SdbCommandRejectedException, IOException {
        String msg = "host:transport:" + serialNumber;
        byte[] deviceQuery = SdbHelper.formSdbRequest(msg);
        SdbHelper.write(channel, deviceQuery);
        SdbResponse resp = SdbHelper.readSdbResponse(channel);
        if (!resp.okay) {
            throw new SdbCommandRejectedException(resp.message);
        }
    }

    public static byte[] sendServiceRequest(SmartDevelopmentBridge sdb, Device device, String req, int maxbuf_size) throws TimeoutException, SdbCommandRejectedException, IOException {
        SocketChannel sdbChan = null;
        byte[] msg = new byte[maxbuf_size];
        try {
            try {
                sdbChan = sdb.openChannel();
                SdbHelper.initializeDevice(sdbChan, device.getSerialNumber());
                byte[] request = SdbHelper.formSdbRequest(req);
                SdbHelper.write(sdbChan, request);
                SdbResponse resp = SdbHelper.readSdbResponse(sdbChan);
                if (!resp.okay) {
                    Log.w("sendServiceRequest", "Error creating service(" + req + "):" + resp.message);
                    throw new SdbCommandRejectedException(resp.message);
                }
                SdbHelper.read(sdbChan, msg);
            }
            catch (EOFException eOFException) {
                Log.i("sdb", "channel closed as normal, and continuing.....");
                IOUtil.tryClose(sdbChan);
                if (sdbChan != null) {
                    sdbChan.close();
                }
            }
        }
        finally {
            IOUtil.tryClose(sdbChan);
            if (sdbChan != null) {
                sdbChan.close();
            }
        }
        return msg;
    }

    public static String getPlatformType(SmartDevelopmentBridge sdb, Device device) throws TimeoutException, SdbCommandRejectedException, IOException {
        SocketChannel sdbChan = null;
        SdbResponse resp = null;
        try {
            sdbChan = sdb.openChannel();
            byte[] request = SdbHelper.formSdbRequest(String.format("host-serial:%1$s:get-platform", device.getSerialNumber()));
            SdbHelper.write(sdbChan, request);
            resp = SdbHelper.readSdbResponse(sdbChan, true);
        }
        finally {
            IOUtil.tryClose(sdbChan);
            if (sdbChan != null) {
                sdbChan.close();
            }
        }
        return resp.message;
    }
}

