/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.tv;

import java.util.regex.Pattern;
import org.tizen.ncli.subcommands.tv.ITVSdbCmd;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformCapability;

public class TVSdbCmdSelector {
    public PlatformCapability platformCapabilityChecker;
    public Object tvSdbCmdObj;
    private IDevice device;
    private String version;
    private String arch;
    private float sdbPluginVersion;
    String sdbPluginVer;

    public TVSdbCmdSelector(IDevice device) {
        block12: {
            this.platformCapabilityChecker = null;
            this.tvSdbCmdObj = null;
            this.version = null;
            this.arch = null;
            try {
                this.device = device;
                this.platformCapabilityChecker = device.getPlatformCapability();
                this.version = device.getPlatformCapability().getPlatformVersion();
                this.arch = device.getPlatformCapability().getCpuArch();
                this.sdbPluginVer = device.getPlatformCapability().getSdbdPluginVersion().substring(0, 3);
                this.sdbPluginVersion = Float.valueOf(this.sdbPluginVer).floatValue();
                if (this.platformCapabilityChecker.getSecureProtocol().equals("enabled")) {
                    try {
                        String className = this.getSecureCmdClassName();
                        if (className != null) {
                            Class<?> securityCmd = Class.forName(className);
                            this.tvSdbCmdObj = securityCmd.newInstance();
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
                try {
                    String className = this.getNonSecureCmdClassName();
                    if (className != null) {
                        Class<?> nonSecurityCmd = Class.forName(className);
                        this.tvSdbCmdObj = nonSecurityCmd.newInstance();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                try {
                    String className = this.getNonSecureCmdClassName();
                    if (className != null) {
                        Class<?> nonSecurityCmd = Class.forName(className);
                        this.tvSdbCmdObj = nonSecurityCmd.newInstance();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public String getCmd(String key, String param) {
        String cmd = "";
        ((ITVSdbCmd)this.getTVSdbCmdObj()).setPlatformCapabilityInstance(this.platformCapabilityChecker);
        cmd = ((ITVSdbCmd)this.getTVSdbCmdObj()).getCmd(key, param);
        return cmd;
    }

    public Object getTVSdbCmdObj() {
        return this.tvSdbCmdObj;
    }

    private String getSecureCmdClassName() {
        if (this.platformCapabilityChecker == null) {
            return null;
        }
        String productVer = this.platformCapabilityChecker.getProductVersion();
        if (productVer == null || productVer.isEmpty() || productVer.equals("unknown")) {
            return null;
        }
        String verText = productVer.replace(".", "_");
        String secureCmdClassName = "SecureCmdVer" + verText;
        if (((double)this.sdbPluginVersion < 3.4 || this.sdbPluginVer.contains("3.4")) && this.version.contains("4.0") && this.arch.contains("armv7")) {
            return "org.tizen.ncli.subcommands.tv." + secureCmdClassName + "_device";
        }
        return "org.tizen.ncli.subcommands.tv." + secureCmdClassName;
    }

    private String getNonSecureCmdClassName() {
        if (this.platformCapabilityChecker == null) {
            return null;
        }
        String productVer = this.platformCapabilityChecker.getProductVersion();
        if (productVer == null || productVer.isEmpty() || productVer.equals("unknown")) {
            return null;
        }
        String verText = productVer.replace(".", "_");
        String nonSecureCmdClassName = "NonSecureCmdVer" + verText;
        if (((double)this.sdbPluginVersion < 3.4 || this.sdbPluginVer.contains("3.4")) && this.version.contains("4.0") && this.arch.contains("armv7")) {
            return "org.tizen.ncli.subcommands.tv." + nonSecureCmdClassName + "_device";
        }
        return "org.tizen.ncli.subcommands.tv." + nonSecureCmdClassName;
    }

    public boolean isSecureProtocol() {
        if (this.platformCapabilityChecker == null) {
            return false;
        }
        try {
            return this.platformCapabilityChecker.getSecureProtocol().equals("enabled");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSTV() {
        boolean isSTV = false;
        try {
            PlatformCapability platformCapabilityChecker = this.device.getPlatformCapability();
            if (platformCapabilityChecker.getProfileName().equals("tv") && platformCapabilityChecker.getVendorName().equals("Samsung")) {
                isSTV = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isSTV;
    }

    public boolean isAppID(String appID) {
        return Pattern.matches("^[a-zA-Z0-9]{10,}[\\.][a-zA-Z0-9_\\.-]*", appID);
    }
}

