/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildapp;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import org.tizen.ncli.subcommands.build.buildapp.BuildScriptData;

public class BuildScriptParser {
    public static void parseWorkspace(BuildScriptData buildScript, JsonObject workspace) {
        if (buildScript != null && workspace != null) {
            JsonPrimitive path;
            JsonPrimitive output = workspace.getAsJsonPrimitive("output");
            if (output != null) {
                buildScript.getWorkspace().setOutputPath(output.getAsString());
            }
            if ((path = workspace.getAsJsonPrimitive("path")) != null) {
                buildScript.getWorkspace().setWorkspacePath(path.getAsString());
            }
        }
    }

    public static void parseProject(BuildScriptData buildScript, JsonObject project) {
        if (project != null) {
            JsonArray predefine;
            JsonPrimitive typeObj;
            String path;
            JsonPrimitive nameObj = project.getAsJsonPrimitive("name");
            String name = nameObj != null ? nameObj.getAsString() : null;
            JsonPrimitive pathObj = project.getAsJsonPrimitive("path");
            String string = path = pathObj != null ? pathObj.getAsString() : null;
            if (name == null) {
                name = path;
            }
            if (path == null) {
                path = name;
            }
            String type = (typeObj = project.getAsJsonPrimitive("type")) != null ? typeObj.getAsString() : null;
            JsonPrimitive validateObj = project.getAsJsonPrimitive("validate");
            boolean validate = validateObj != null ? validateObj.getAsBoolean() : true;
            JsonPrimitive ownBuildObj = project.getAsJsonPrimitive("ownbuild");
            boolean ownBuild = ownBuildObj != null ? ownBuildObj.getAsBoolean() : true;
            BuildScriptData.ProjectEntry projEntry = new BuildScriptData.ProjectEntry(name, path, type, validate, ownBuild, null);
            JsonArray dependency = project.getAsJsonArray("dependencies");
            if (dependency != null && dependency.size() > 0) {
                int cnt2 = dependency.size();
                for (int j = 0; j < cnt2; ++j) {
                    projEntry.addDependencyProject(dependency.get(j).getAsString());
                }
            }
            if ((predefine = project.getAsJsonArray("predefines")) != null && predefine.size() > 0) {
                int cnt2 = predefine.size();
                for (int j = 0; j < cnt2; ++j) {
                    projEntry.addPredefine(predefine.get(j).getAsString());
                }
            }
            buildScript.addProject(projEntry);
        }
    }

    public static void parseMethod(BuildScriptData buildScript, JsonObject method, String defaultName) {
        if (method != null) {
            Object target;
            int j;
            int cnt2;
            String name;
            JsonPrimitive nameObj = method.getAsJsonPrimitive("name");
            String string = name = nameObj != null ? nameObj.getAsString() : defaultName;
            if (name == null) {
                return;
            }
            JsonArray rootstraps = method.getAsJsonArray("rootstraps");
            JsonPrimitive toolchainObj = method.getAsJsonPrimitive("compiler");
            String toolchain = toolchainObj != null ? toolchainObj.getAsString() : null;
            JsonArray buildConfigs = method.getAsJsonArray("configs");
            BuildScriptData.BuildMethodEntry methodEntry = new BuildScriptData.BuildMethodEntry(name, null, toolchain, null);
            if (rootstraps != null) {
                cnt2 = rootstraps.size();
                for (j = 0; j < cnt2; ++j) {
                    target = rootstraps.get(j).getAsJsonObject();
                    JsonPrimitive idObj = target.getAsJsonPrimitive("name");
                    JsonPrimitive platformObj = target.getAsJsonPrimitive("platform");
                    JsonPrimitive archObj = target.getAsJsonPrimitive("arch");
                    String id = idObj != null ? idObj.getAsString() : null;
                    String platform = platformObj != null ? platformObj.getAsString() : null;
                    String arch = archObj != null ? archObj.getAsString() : null;
                    methodEntry.addRootstrap(id, platform, arch);
                }
            }
            if (buildConfigs != null) {
                cnt2 = buildConfigs.size();
                for (j = 0; j < cnt2; ++j) {
                    target = buildConfigs.get(j).getAsString();
                    methodEntry.addBuildConfig((String)target);
                }
            }
            methodEntry.mergeAllRootstraps();
            JsonArray predefine = method.getAsJsonArray("predefines");
            if (predefine != null && predefine.size() > 0) {
                int cnt22 = predefine.size();
                for (int j2 = 0; j2 < cnt22; ++j2) {
                    methodEntry.addPredefine(predefine.get(j2).getAsString());
                }
            }
            buildScript.addBuildMethod(methodEntry);
        }
    }

    public static void parseMethod(BuildScriptData buildScript, JsonObject method) {
        BuildScriptParser.parseMethod(buildScript, method, null);
    }

    public static void parseBuild(BuildScriptData buildScript, JsonObject build, String defaultName) {
        if (build != null) {
            JsonPrimitive jobsObj;
            JsonArray predefine;
            JsonPrimitive outputObj;
            ArrayList<String> methodList;
            String name;
            JsonPrimitive nameObj = build.getAsJsonPrimitive("name");
            String string = name = nameObj != null ? nameObj.getAsString() : defaultName;
            if (name == null) {
                return;
            }
            JsonArray methods2 = build.getAsJsonArray("methods");
            if (methods2 != null && methods2.size() > 0) {
                methodList = new ArrayList<String>();
                int cnt2 = methods2.size();
                for (int j = 0; j < cnt2; ++j) {
                    methodList.add(methods2.get(j).getAsString());
                }
            } else {
                methodList = null;
            }
            String output = (outputObj = build.getAsJsonPrimitive("output")) != null ? outputObj.getAsString() : null;
            BuildScriptData.BuildEntry buildEntry = new BuildScriptData.BuildEntry(name, null, methodList, null, output);
            JsonArray targets = build.getAsJsonArray("targets");
            if (targets != null && targets.size() > 0) {
                int cnt2 = targets.size();
                for (int j = 0; j < cnt2; ++j) {
                    String target = targets.get(j).getAsString();
                    buildEntry.addTargetProject(target);
                }
            }
            if ((predefine = build.getAsJsonArray("predefines")) != null && predefine.size() > 0) {
                int cnt2 = predefine.size();
                for (int j = 0; j < cnt2; ++j) {
                    buildEntry.addPredefine(predefine.get(j).getAsString());
                }
            }
            int jobs = (jobsObj = build.getAsJsonPrimitive("multitask")) != null ? jobsObj.getAsInt() : 0;
            buildEntry.setMultitaskJobs(jobs);
            JsonPrimitive buildscriptObj = build.getAsJsonPrimitive("buildscript");
            String buildScriptPath = buildscriptObj != null ? buildscriptObj.getAsString() : null;
            buildEntry.setBuildScriptPath(buildScriptPath);
            buildScript.addBuild(buildEntry);
        }
    }

    public static void parseBuild(BuildScriptData buildScript, JsonObject build) {
        BuildScriptParser.parseBuild(buildScript, build, null);
    }

    public static void parsePackage(BuildScriptData buildScript, JsonObject pkg) {
        if (pkg != null) {
            JsonPrimitive nameObj = pkg.getAsJsonPrimitive("name");
            String name = nameObj != null ? nameObj.getAsString() : null;
            JsonArray targets = pkg.getAsJsonArray("targets");
            BuildScriptData.PackageEntry packageEntry = null;
            if (targets != null && targets.size() > 0) {
                JsonPrimitive validateObj;
                String type;
                JsonPrimitive outputObj = pkg.getAsJsonPrimitive("output");
                String output = outputObj != null ? outputObj.getAsString() : null;
                JsonPrimitive typeObj = pkg.getAsJsonPrimitive("type");
                String string = type = typeObj != null ? typeObj.getAsString() : null;
                if (type == null) {
                    // empty if block
                }
                boolean validate = (validateObj = pkg.getAsJsonPrimitive("validate")) != null ? validateObj.getAsBoolean() : true;
                packageEntry = new BuildScriptData.PackageEntry(name, type, validate, null, null, null, output);
                int cnt2 = targets.size();
                for (int j = 0; j < cnt2; ++j) {
                    packageEntry.addTarget(targets.get(j).getAsString());
                }
                JsonArray predefine = pkg.getAsJsonArray("predefines");
                if (predefine != null && predefine.size() > 0) {
                    int cnt3 = predefine.size();
                    for (int j = 0; j < cnt3; ++j) {
                        packageEntry.addPredefine(predefine.get(j).getAsString());
                    }
                }
            }
            if (packageEntry != null) {
                buildScript.addPackage(packageEntry);
            }
        }
    }
}

