/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.command.policy;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.CommandCancelException;

public enum UncaughtExceptionHandlingPolicy implements Thread.UncaughtExceptionHandler
{
    INSTANCE;

    private final Logger logger = LoggerFactory.getLogger(UncaughtExceptionHandlingPolicy.class);
    private final Map<String, Thread.UncaughtExceptionHandler> repository = new HashMap<String, Thread.UncaughtExceptionHandler>();

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Thread.UncaughtExceptionHandler handler = null;
        Class<?> throwableClass = e.getClass();
        do {
            if ((handler = this.repository.get(throwableClass.getCanonicalName())) == null) continue;
            handler.uncaughtException(t, e);
            return;
        } while (!(throwableClass = throwableClass.getSuperclass()).getCanonicalName().equals(Object.class.getCanonicalName()));
        throw new IllegalStateException(e);
    }

    private UncaughtExceptionHandlingPolicy() {
        this.installUncaughtExceptionHandlers();
    }

    private void installUncaughtExceptionHandlers() {
        this.putHandler(CommandCancelException.class.getCanonicalName(), new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof CommandCancelException) {
                    throw (CommandCancelException)e;
                }
                throw new IllegalStateException();
            }
        });
    }

    private void putHandler(String throwableName, Thread.UncaughtExceptionHandler handler) {
        if (this.repository.containsKey(throwableName)) {
            if (!this.repository.get(throwableName).equals(handler)) {
                this.logger.error("Handlers are duplicately assigned with one key: " + throwableName);
            }
            return;
        }
        this.repository.put(throwableName, handler);
    }
}

