/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.util;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.util.CommandUtil;

public class DirectoryUtil {
    protected static Logger log = LoggerFactory.getLogger(CommandUtil.class);

    public static boolean deleteDirectory(File path, boolean deleteDir) {
        if (!path.exists()) {
            return false;
        }
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    DirectoryUtil.deleteDirectory(file, true);
                    continue;
                }
                try {
                    file.delete();
                }
                catch (Exception e) {
                    log.error("Unable to delete file");
                }
            }
        }
        if (deleteDir) {
            return path.delete();
        }
        return true;
    }

    public static boolean deleteDirectory(File path) {
        return DirectoryUtil.deleteDirectory(path, true);
    }

    public static File createTempDirectory() throws IOException {
        String sysTempDir = System.getProperty("java.io.tmpdir");
        File tempPath = new File(sysTempDir, "tizen_temp_" + Long.toString(System.nanoTime()));
        if (!tempPath.mkdirs()) {
            throw new IOException("Could not create temp directory: " + tempPath.getAbsolutePath());
        }
        return tempPath;
    }
}

