/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.config.Loader;
import org.tizen.common.config.Preference;
import org.tizen.common.config.PreferenceProvider;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.ncli.config.ConfigConstant;
import org.tizen.ncli.core.config.TizenCLIConfigProvider;

public class NCLIConfigLoader
implements Loader {
    private static final String configFileName = ".tizen-cli-config";
    private static Logger log = LoggerFactory.getLogger(NCLIConfigLoader.class);

    public void load(String ns) throws IOException {
        Assert.notNull((Object)ns, (String)"Namespace could not be null");
        if ("TIZEN.CLI.GLOBAL".equals(ns)) {
            Preference.register((String)ns, (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadGlobalConf()));
        } else if ("TIZEN.CLI.LOCAL".equals(ns)) {
            Preference.register((String)ns, (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadLocalConf()));
        }
    }

    public static Properties loadLocalConf() {
        return NCLIConfigLoader.loadConf(NCLIConfigLoader.getLocalConfigFile(), true);
    }

    public static Properties loadGlobalConf() {
        return NCLIConfigLoader.loadConf(NCLIConfigLoader.getGlobalConfigFile(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadConf(File file, boolean needDefaultValue) {
        FileInputStream is = null;
        Properties prop = new Properties();
        try {
            boolean isConfExist = file.exists();
            log.trace("isConfExist:{}", (Object)isConfExist);
            if (!isConfExist) {
                log.info("{} file does not exist.", (Object)file.getAbsolutePath());
                file.createNewFile();
                if (needDefaultValue) {
                    NCLIConfigLoader.setDefault(file);
                }
            }
            is = new FileInputStream(file);
            prop.load(is);
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFoundException occurred: {}", (Object)file.getAbsolutePath());
            IOUtil.tryClose((Object[])new Object[]{is});
        }
        catch (IOException io) {
            log.error("IOException occurred: {}", (Object)file.getAbsolutePath());
            {
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{is});
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        }
        IOUtil.tryClose((Object[])new Object[]{is});
        return prop;
    }

    public static File getLocalConfigFile() {
        return NCLIConfigLoader.getConfigFile(InstallPathConfig.getToolsPath());
    }

    public static File getGlobalConfigFile() {
        return NCLIConfigLoader.getConfigFile(System.getProperty("user.home"));
    }

    public static File getConfigFile(String pathName) {
        return new File(pathName + HostUtil.FILE_SEPARATOR + configFileName);
    }

    private static void setDefault(File file) {
        String defaultValues = ConfigConstant.getDefaultValues();
        try {
            FileUtil.writeTextFile((File)file, (String)defaultValues, null);
        }
        catch (IOException e) {
            log.error("IOException occurred: {}", (Object)file.getAbsolutePath());
        }
    }
}

