/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.ncli.core.CommandInfo;
import org.tizen.ncli.core.CommandLineParser;
import org.tizen.ncli.core.SubCommandData;
import org.tizen.ncli.core.TizenSubCommandHandler;
import org.tizen.ncli.core.collection.TreeNode;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLINLS;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.ide.shell.BuildAppCLI;
import org.tizen.ncli.ide.shell.BuildCSCLI;
import org.tizen.ncli.ide.shell.BuildNativeCLI;
import org.tizen.ncli.ide.shell.BuildWebCLI;
import org.tizen.ncli.ide.shell.CleanCLI;
import org.tizen.ncli.ide.shell.ConfigCLI;
import org.tizen.ncli.ide.shell.CreateCLI;
import org.tizen.ncli.ide.shell.GenerateCertificateCLI;
import org.tizen.ncli.ide.shell.InstallCLI;
import org.tizen.ncli.ide.shell.ListCLI;
import org.tizen.ncli.ide.shell.ManualCLI;
import org.tizen.ncli.ide.shell.PackageCLI;
import org.tizen.ncli.ide.shell.RunCLI;
import org.tizen.ncli.ide.shell.SecurityProfilesCLI;
import org.tizen.ncli.ide.shell.UninstallCLI;
import org.tizen.ncli.ide.shell.VersionCLI;
import org.tizen.ncli.util.TargetUtil;

public class Main {
    private Logger log = LoggerFactory.getLogger(Main.class);
    protected final Logger progressLog = LoggerFactory.getLogger((String)"NCLI_PROGRESS");
    private PrintWriter errorWriter = new PrintWriter(System.err);
    @Argument(index=0, required=true, handler=TizenSubCommandHandler.class, metaVar="<command>", usage="tizen <command>")
    @SubCommands(value={@SubCommand(name="create", impl=CreateCLI.class), @SubCommand(name="certificate", impl=GenerateCertificateCLI.class), @SubCommand(name="build-native", impl=BuildNativeCLI.class), @SubCommand(name="build-web", impl=BuildWebCLI.class), @SubCommand(name="build-cs", impl=BuildCSCLI.class), @SubCommand(name="build-app", impl=BuildAppCLI.class), @SubCommand(name="clean", impl=CleanCLI.class), @SubCommand(name="security-profiles", impl=SecurityProfilesCLI.class), @SubCommand(name="cli-config", impl=ConfigCLI.class), @SubCommand(name="package", impl=PackageCLI.class), @SubCommand(name="install", impl=InstallCLI.class), @SubCommand(name="uninstall", impl=UninstallCLI.class), @SubCommand(name="run", impl=RunCLI.class), @SubCommand(name="list", impl=ListCLI.class), @SubCommand(name="manual", impl=ManualCLI.class), @SubCommand(name="version", impl=VersionCLI.class)})
    private AbstractCLI tizenCLI;
    @Option(name="--help", aliases={"-h"}, usage="tizen -h", help=true)
    private boolean helpOpt;

    public static void main(String[] args) {
        Main tizen = new Main();
        tizen.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) {
        int result = 0;
        CommandLineParser cmdParser = new CommandLineParser(this);
        this.log.trace("Start running Tizen CLI Main class...");
        this.log.trace("Argument count:{}", (Object)args.length);
        try {
            cmdParser.setUsageWidth(120);
            cmdParser.parseArgument(args);
        }
        catch (CmdLineException e) {
            try {
                TizenCLINLS nls = new TizenCLINLS();
                Enumeration<String> keys = nls.getResourceBundle().getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    this.log.trace("key:{}, value:{}", (Object)key, (Object)nls.get(key));
                }
                if (args.length == 0) {
                    this.printDefaultCommandUsage(this.errorWriter);
                } else {
                    this.progressLog.info("");
                    this.progressLog.info(MessageFormat.format("Error: {0}", e.getMessage()));
                    this.progressLog.info("");
                    String command = args[0];
                    this.log.trace("{}", (Object)command);
                    if (null == SubCommandData.get(command)) {
                        this.printDefaultCommandUsage(this.errorWriter);
                    } else {
                        CommandInfo currentCmdInfo = SubCommandData.get("CURRENT_CMD");
                        this.log.trace("currentCmdInfo: {}", (Object)currentCmdInfo);
                        if (null != currentCmdInfo) {
                            this.printSubCommandOrArgUsage(currentCmdInfo);
                            this.log.trace("command:{}", (Object)currentCmdInfo.getCommandName());
                        }
                    }
                }
            }
            finally {
                this.errorWriter.flush();
                System.exit(1);
            }
        }
        if (this.helpOpt) {
            this.printDefaultCommandUsage(this.errorWriter);
        } else if (this.isHelped(args) && !args[0].equals("manual") && !args[0].equals("version")) {
            CommandInfo currentCmdInfo = SubCommandData.get("CURRENT_CMD");
            this.printSubCommandOrArgUsage(currentCmdInfo);
        } else {
            try {
                if (null != this.tizenCLI) {
                    result = this.tizenCLI.execute(cmdParser);
                }
            }
            catch (UnexpectedException e) {
                result = e.getValue();
            }
            catch (Exception e) {
                result = 1;
                this.progressLog.error("An error has occurred. See the log file tizen-sdk" + File.separator + "tools" + File.separator + "ide" + File.separator + "cli.log.");
                this.log.error(e.getMessage());
            }
            finally {
                TargetUtil.finalizeSmartDeviceBridge();
            }
        }
        this.errorWriter.flush();
        if (this.tizenCLI != null && this.tizenCLI.needPrintTime()) {
            this.tizenCLI.printElapsedTime();
        }
        IOUtil.tryClose((Object[])new Object[]{this.errorWriter});
        System.exit(result);
    }

    private boolean isHelped(String[] args) {
        for (int i = 1; i < args.length; ++i) {
            if (!args[i].trim().equals("--help") && !args[i].trim().equals("-h")) continue;
            return true;
        }
        return false;
    }

    private void printSubCommandOrArgUsage(CommandInfo currentCmdInfo) {
        TreeNode<CommandInfo> rootNode = SubCommandData.getRootNode();
        TreeNode<CommandInfo> currCmdNode = rootNode.findTreeNode(currentCmdInfo);
        if (null != currCmdNode) {
            String printCommands = this.concatenateCommands(currCmdNode, currentCmdInfo.getCommandName());
            this.progressLog.info("Usage:  {}", (Object)printCommands);
            if (currCmdNode.children.size() > 0) {
                List<TreeNode<CommandInfo>> children = currCmdNode.children;
                int maxLen = this.getMaxLengthForTreeNode(children) + 4;
                for (TreeNode<CommandInfo> treeNode : children) {
                    this.progressLog.info(String.format("  %-" + maxLen + "s%s", ((CommandInfo)treeNode.data).getCommandName(), ((CommandInfo)treeNode.data).getUsage()));
                }
            } else {
                currentCmdInfo.getCmdLineParser().printUsage(this.errorWriter, null);
            }
        } else {
            this.log.error("==COULD NOT REACH THIS CODE==");
        }
    }

    private String concatenateCommands(TreeNode<CommandInfo> findTreeNode, String command) {
        StringBuilder returnCommand = new StringBuilder("tizen ");
        if (findTreeNode.children.size() > 0) {
            returnCommand.append(command);
            returnCommand.append(" ");
            returnCommand.append("<sub-command>");
        } else if (null != findTreeNode.parent && !"MAIN".equals(((CommandInfo)findTreeNode.parent.data).getCommandName())) {
            returnCommand.append(this.makeCmdRecursively(findTreeNode));
            returnCommand.append(command);
        } else {
            returnCommand.append(command);
        }
        returnCommand.append(" [args]");
        return returnCommand.toString();
    }

    private String makeCmdRecursively(TreeNode<CommandInfo> current) {
        StringBuilder returnCmd = new StringBuilder();
        if (null != current.parent && !"MAIN".equals(((CommandInfo)current.parent.data).getCommandName())) {
            returnCmd.append(this.makeCmdRecursively(current.parent));
        } else if (!current.isRoot()) {
            returnCmd.append(((CommandInfo)current.data).getCommandName());
            returnCmd.append(" ");
        }
        return returnCmd.toString();
    }

    private int getMaxLengthForTreeNode(List<TreeNode<CommandInfo>> children) {
        int ret = 0;
        for (TreeNode<CommandInfo> treeNode : children) {
            int currLen = null != ((CommandInfo)treeNode.data).getCommandName() ? ((CommandInfo)treeNode.data).getCommandName().length() : 0;
            ret = Math.max(ret, currLen);
        }
        return ret;
    }

    private void printDefaultCommandUsage(PrintWriter errorWriter) {
        this.progressLog.error("Usage: tizen <command> [args]");
        this.progressLog.error("Where <command> is one of ");
        this.progressLog.error("-----------------------------");
        Set<String> commandNames = SubCommandData.keySet();
        int maxLen = this.getMaxLength(commandNames) + 4;
        for (String key : commandNames) {
            CommandInfo commandInfo = SubCommandData.get(key);
            this.progressLog.error(String.format("  %-" + maxLen + "s%s", key, commandInfo.getUsage() == null ? "" : commandInfo.getUsage()));
        }
    }

    private int getMaxLength(Iterable<String> keys) {
        int ret = 0;
        for (String key : keys) {
            ret = Math.max(ret, key.length());
        }
        return ret;
    }
}

