/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildcs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.buildcs.BuildCSData;
import org.tizen.tpklib.lib.PathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BuildCSCommand {
    protected final Logger log = LoggerFactory.getLogger(AbstractSubCommand.class);
    protected final Logger progressLog = LoggerFactory.getLogger((String)"NCLI_PROGRESS");
    public static final String PROJECT_MANIFEST = "tizen-manifest.xml";
    public static final String PROJECT_CSPROP_EXTENSION = ".csproj";
    public static final String PROJECT_SLN_EXTENSION = ".sln";
    public static final String CLI_DEFAULT_CONFIGURATION = "Debug";

    public static BuildCSData analisysProjectInfo(String projectDir, BuildCSData buildCSData) {
        if (!BuildCSCommand.setCSharpProjInfo(projectDir, buildCSData)) {
            return null;
        }
        if (!BuildCSCommand.setManifestInfo(projectDir, buildCSData)) {
            return null;
        }
        return buildCSData;
    }

    private static boolean setManifestInfo(String projectDir, BuildCSData data) {
        File manifestFile;
        String manifestFilePath = null;
        String slnFilePath = null;
        String csProjFilePath = null;
        String csProjFolderPath = null;
        File csProjFolderPathFile = null;
        File f = new File(projectDir);
        if (f == null || !f.exists()) {
            return false;
        }
        File[] allFilesInProject = f.listFiles();
        if (allFilesInProject == null) {
            return false;
        }
        block2: for (File fileInProject : allFilesInProject) {
            if (fileInProject.getName().endsWith(PROJECT_MANIFEST)) {
                manifestFilePath = FileUtil.appendPath((String)projectDir, (String)fileInProject.getName());
                break;
            }
            if (!fileInProject.getName().endsWith(PROJECT_SLN_EXTENSION)) continue;
            try {
                slnFilePath = fileInProject.getCanonicalPath();
                csProjFilePath = BuildCSCommand.getCSProjFilePathFromSlnFile(projectDir, slnFilePath);
                csProjFolderPath = new File(csProjFilePath).getParent();
                csProjFolderPathFile = new File(csProjFilePath).getParentFile();
                if (csProjFolderPath == null || csProjFolderPathFile == null) {
                    return false;
                }
                File[] filesInCS = csProjFolderPathFile.listFiles();
                if (filesInCS == null) {
                    return false;
                }
                for (File fileInCS : filesInCS) {
                    if (!fileInCS.getName().endsWith(PROJECT_MANIFEST)) continue;
                    manifestFilePath = FileUtil.appendPath((String)csProjFolderPath, (String)fileInCS.getName());
                    break block2;
                }
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
        }
        if (!(manifestFile = new File(manifestFilePath)).exists()) {
            return false;
        }
        Document menifestDoc = XMLUtil.readXML((File)manifestFile);
        String pack = XMLUtil.getDOMValueNS((Document)menifestDoc, (String)"/:manifest/@package");
        data.setPackageName(pack);
        Node appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:manifest/:ui-application");
        String appType = "ui";
        if (appNode != null && appNode instanceof Element) {
            data.setAppType(appType);
            String id = XMLUtil.getDOMValueNS((Element)((Element)appNode), (String)"@appid");
            data.setAppId(id);
            String exec = XMLUtil.getDOMValueNS((Element)((Element)appNode), (String)"@exec");
            data.setExecName(exec);
            String type = XMLUtil.getDOMValueNS((Element)((Element)appNode), (String)"@type");
            data.setType(type);
        }
        return true;
    }

    private static boolean setCSharpProjInfo(String projectDir, BuildCSData data) {
        String csProjFilePath = null;
        String csProjFolderPath = null;
        String slnFilePath = null;
        String selectedConfiguration = null;
        String outputPath = null;
        File f = new File(projectDir);
        if (!f.exists()) {
            return false;
        }
        File[] allFiles = f.listFiles();
        if (allFiles == null) {
            return false;
        }
        for (File file : allFiles) {
            if (file.getName().endsWith(PROJECT_CSPROP_EXTENSION)) {
                try {
                    csProjFolderPath = file.getParent();
                    csProjFilePath = file.getCanonicalPath();
                    data.setProjectPath(csProjFolderPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            if (!file.getName().endsWith(PROJECT_SLN_EXTENSION)) continue;
            try {
                slnFilePath = file.getCanonicalPath();
                csProjFilePath = BuildCSCommand.getCSProjFilePathFromSlnFile(projectDir, slnFilePath);
                csProjFolderPath = new File(csProjFilePath).getParent();
                data.setProjectPath(csProjFolderPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break;
        }
        if (csProjFilePath != null) {
            String outputPathQuery;
            File file = new File(csProjFilePath);
            if (!file.exists()) {
                return false;
            }
            Document menifestDoc = XMLUtil.readXML((File)file);
            selectedConfiguration = data.getConfig();
            if (selectedConfiguration == null) {
                selectedConfiguration = XMLUtil.getDOMValueNS((Document)menifestDoc, (String)"/:Project/:PropertyGroup/:Configuration");
                if (selectedConfiguration == null) {
                    selectedConfiguration = CLI_DEFAULT_CONFIGURATION;
                }
                data.setConfig(selectedConfiguration);
            }
            if ((outputPath = XMLUtil.getDOMValueNS((Document)menifestDoc, (String)(outputPathQuery = String.format("/:Project/:PropertyGroup[contains(@Condition, '%s')]/:OutputPath", selectedConfiguration)))) != null) {
                data.setOutputPath(FileUtil.appendPath((String)csProjFolderPath, (String)outputPath));
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCSProjFilePathFromSlnFile(String projectDir, String slnFilePath) {
        String csProjFilePath;
        block16: {
            BufferedReader in = null;
            ArrayList<String> csprojLists = new ArrayList<String>();
            Pattern pattern = Pattern.compile("(Project.)(\"([^\"]*)\").\\s=\\s(\"([^\"]*)\"),\\s(\"([^\"]*)\"),\\s(\"([^\"]*)\")");
            csProjFilePath = null;
            String csProjFilePathTemp = null;
            try {
                String s;
                InputStreamReader isr = new InputStreamReader(new FileInputStream(slnFilePath));
                in = new BufferedReader(isr);
                while ((s = in.readLine()) != null) {
                    if (!s.startsWith("Project")) continue;
                    csprojLists.add(s);
                }
                if (csprojLists.size() == 1) {
                    Matcher matcher = pattern.matcher((CharSequence)csprojLists.get(0));
                    if (matcher.find() && matcher.group(7) != null) {
                        csProjFilePath = FileUtil.appendPath((String)projectDir, (String)matcher.group(7));
                    }
                    break block16;
                }
                if (csprojLists.size() <= 1) break block16;
                for (String csProj : csprojLists) {
                    Matcher matcher = pattern.matcher(csProj);
                    if (!matcher.find() || matcher.group(7) == null || !BuildCSCommand.isMainProject(csProjFilePathTemp = FileUtil.appendPath((String)projectDir, (String)matcher.group(7)))) continue;
                    csProjFilePath = csProjFilePathTemp;
                    break;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return csProjFilePath;
    }

    public static boolean isMainProject(String csProjFilePath) {
        File file = new File(csProjFilePath);
        if (!file.exists()) {
            return false;
        }
        Document menifestDoc = XMLUtil.readXML((File)file);
        Node appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:Project/:ItemGroup/:ProjectReference");
        return appNode != null && appNode instanceof Element;
    }

    public static void writeBuildInfo(String outputPath, BuildCSData buildCSData) {
        if (outputPath == null || buildCSData == null) {
            return;
        }
        if (!new File(outputPath).exists()) {
            return;
        }
        buildCSData.writeBuildInfo(PathUtil.addPath((String[])new String[]{outputPath, "build.info"}), null);
    }
}

