/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createcsharp;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.subcommands.createcsharp.CSTemplateInfo;
import org.w3c.dom.Document;

public class CreateCSProjectCommandData {
    private static final String CSHARP_TEMPLATE_PATH = "cs-templates";
    private static final String TIZEN_CS_TEMPLATE_FILE = ".+\\.Tizen\\.vstemplate";
    private static final String TIZEN_CS_TEMPLATE_PROJECT_FILE = "ProjectTemplate.csproj";
    private static final String TIZEN_CS_TEMPLATE_TYPE_GUID_XPATH = "/:Project/:PropertyGroup/:ProjectTypeGuids";
    private static final String TIZEN_CS_TEMPLATE_MANDATORY_GUID = "{2F98DAC9-6F16-457B-AED7-D43CAC379341}";
    private String templateName = "";
    private String projectName = "";
    private String outputName = "";
    private String projectType;
    private static Map<String, CSTemplateInfo> csTemplates = new HashMap<String, CSTemplateInfo>();

    public static Map<String, CSTemplateInfo> getTemplateList() {
        return csTemplates;
    }

    private static void initializeTemplateList() {
        csTemplates.clear();
        String cliToolPath = InstallPathConfig.getToolsPath() + File.separator + "ide";
        File root = new File(cliToolPath + File.separator + CSHARP_TEMPLATE_PATH);
        List fileArray = null;
        try {
            fileArray = FileUtil.findFiles((File)root, (String)TIZEN_CS_TEMPLATE_FILE, (boolean)true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        for (File templatefile : fileArray) {
            File parentDir = templatefile.getParentFile();
            if (parentDir == null || csTemplates.containsKey(parentDir.getName())) continue;
            try {
                String templateName;
                if (!CreateCSProjectCommandData.isTizenProject(parentDir) || (templateName = parentDir.getName()) == null) continue;
                CSTemplateInfo templateInfo = new CSTemplateInfo(templateName, parentDir.getAbsolutePath(), templatefile.getAbsolutePath());
                csTemplates.put(templateName, templateInfo);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    private static boolean isTizenProject(File projectDir) throws FileNotFoundException {
        boolean isTizenProejct = false;
        List projectFileArray = FileUtil.findFiles((File)projectDir, (String)TIZEN_CS_TEMPLATE_PROJECT_FILE, (boolean)true);
        if (projectFileArray != null) {
            for (File projectfile : projectFileArray) {
                Document xml = XMLUtil.readXML((File)projectfile);
                String domValue = XMLUtil.getDOMValueNS((Document)xml, (String)TIZEN_CS_TEMPLATE_TYPE_GUID_XPATH);
                if (domValue == null || !domValue.contains(TIZEN_CS_TEMPLATE_MANDATORY_GUID)) continue;
                isTizenProejct = true;
                break;
            }
        }
        return isTizenProejct;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    static {
        CreateCSProjectCommandData.initializeTemplateList();
    }
}

