/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.createweb;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.tproject.ObjectFactory;
import org.tizen.common.core.application.tproject.Platform;
import org.tizen.common.core.application.tproject.Platforms;
import org.tizen.common.core.application.tproject.Tproject;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FreeMarkerUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.createweb.CreateWebProjectCommandData;
import org.tizen.ncli.subcommands.createweb.ProjectGenUtil;
import org.tizen.ncli.subcommands.createweb.WebProjectInfo;
import org.tizen.ncli.subcommands.packages.WebProject;
import org.tizen.web.apptemplate.model.LibraryElement;
import org.tizen.web.apptemplate.model.OptionElement;
import org.tizen.web.apptemplate.model.OptionGroup;
import org.tizen.web.apptemplate.model.Options;
import org.tizen.web.apptemplate.model.SupportLibraries;
import org.tizen.web.apptemplate.model.TizenTemplateKindsOfLibraries;
import org.tizen.web.model.TizenAppTemplate;
import org.tizen.web.model.TizenModelFactory;
import org.tizen.web.project.wizard.model.TizenTemplateLibrariesPool;
import org.tizen.web.project.wizard.model.TizenTemplateLibraryGroup;
import org.tizen.web.project.wizard.operation.LibraryCopyOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateWebProjectCommand
extends AbstractSubCommand<CreateWebProjectCommandData> {
    private CreateWebProjectCommandData data = new CreateWebProjectCommandData();
    private Map<String, Object> root = new HashMap<String, Object>();
    private Configuration cfg;
    private static String temporaryFileAdditionalName = ".template";
    private static String optionGroupSeparator = "_";
    TizenAppTemplate tizenAppTemplate;
    private ProjectGenUtil pg = new ProjectGenUtil();
    private TizenTemplateLibrariesPool libraryPool;

    public CreateWebProjectCommandData getData() {
        return this.data;
    }

    @Override
    protected CreateWebProjectCommandData call() {
        Map<WebProjectInfo, String> webProjects = this.data.getTemplateList();
        if (webProjects == null || webProjects.size() == 0) {
            this.progressLog.error("No templates found");
            throw new UnexpectedException(2, "No templates found");
        }
        if (this.copyWebProjectTemplate() != 0) {
            this.progressLog.error("Failed to copy web project template");
            throw new UnexpectedException(2, "Failed to copy web project template");
        }
        if (this.copyLibrary() != 0) {
            this.progressLog.error("Failed to copy dependent library");
            throw new UnexpectedException(2, "Failed to copy dependent library");
        }
        if (this.processOption() != 0) {
            this.progressLog.error("Failed to generate file from template");
            throw new UnexpectedException(2, "Failed to generate file from template");
        }
        if (this.makeTizenDescription() != 0) {
            this.progressLog.error("Failed to generate tizen description file");
            throw new UnexpectedException(2, "Failed to generate tizen description file");
        }
        if (this.isWebWidget()) {
            this.changeWidgetDummyNameAsProjectName();
        }
        return this.data;
    }

    private void changeWidgetDummyNameAsProjectName() {
        String widgetPath = this.data.getOutputName() + File.separator + "widget";
        File dummyDir = new File(widgetPath, "Widget");
        File widgetPrjDir = new File(widgetPath, this.data.getProjectName());
        if (dummyDir.exists()) {
            dummyDir.renameTo(widgetPrjDir);
        }
    }

    private boolean isWebWidget() {
        String configPath = this.data.getOutputName() + File.separator + "config.xml";
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            this.progressLog.error("Failed to find config.xml");
            throw new UnexpectedException(2, "Failed to find config.xml");
        }
        Document configDoc = null;
        try {
            configDoc = WebProject.getDocument(configPath);
            if (configDoc == null) {
                this.progressLog.error("Error Can't parse config.xml file ");
                throw new UnexpectedException(2, "Error Can't parse config.xml file");
            }
        }
        catch (Exception e) {
            this.progressLog.error("Error Can't parse cofnig.xml file", (Object)e.getMessage());
            throw new UnexpectedException(2, "Error Can't parse config.xml file");
        }
        return WebProject.isWebWidgetProject(configDoc);
    }

    public void setTemplateName(String projectName) {
        this.data.setTemplateName(projectName);
    }

    public void getTemplateName() {
        this.data.getTemplateName();
    }

    public void setProjectName(String projectName) {
        this.data.setProjectName(projectName);
    }

    public String getProjectName() {
        return this.data.getProjectName();
    }

    public void setOutputName(String projectName) {
        this.data.setOutputName(projectName);
    }

    public String getOutputName() {
        return this.data.getOutputName();
    }

    private int copyWebProjectTemplate() {
        String destDir = this.data.getOutputName();
        String templatePath = this.data.getTizenWebTemplateRootPath(new WebProjectInfo(this.data.getTemplateName(), this.data.getProfileName()));
        if (templatePath == null) {
            this.progressLog.error(String.format("Cannot find '%s' template in '%s' profile", this.data.getTemplateName(), this.data.getProfileName()));
            return -1;
        }
        templatePath = templatePath + File.separator + "project";
        File[] resourceFilter = new File[]{new File(".project")};
        try {
            FileUtil.copyRecursively((String)templatePath, (String)destDir, (boolean)true, (File[])resourceFilter);
        }
        catch (IOException e) {
            this.log.error(TizenCLIMessages.CR_CANNOT_COPY_PROJECT);
            return -1;
        }
        return 0;
    }

    private int copyLibrary() {
        SupportLibraries sl;
        String configFile = this.data.getTizenWebTemplateConfigFile(new WebProjectInfo(this.data.getTemplateName(), this.data.getProfileName()));
        try {
            this.tizenAppTemplate = TizenModelFactory.unmarshalAppTemplate((String)configFile);
        }
        catch (FileNotFoundException e) {
            this.log.error("not found template file\n{}", (Object)e.getMessage());
            return -1;
        }
        Options options = null;
        if (this.tizenAppTemplate != null && (options = this.tizenAppTemplate.getOptions()) == null) {
            this.log.info("no options");
        }
        if (options != null && (sl = options.getSupportLibraries()) != null) {
            ProfileInfo profileInfo = InstallPathConfig.getLatestProfileInfo();
            String rootPath = this.pg.extractBuiltinJarFiles("templateLibraries");
            if (profileInfo != null) {
                this.libraryPool = new TizenTemplateLibrariesPool(profileInfo, rootPath);
                if (this.libraryPool != null) {
                    List groupList = this.libraryPool.getLibraryGroupWithDepends(sl);
                    for (TizenTemplateLibraryGroup group : groupList) {
                        if (group.getSelectedElement().getKindsOfLibrary() == TizenTemplateKindsOfLibraries.TIZENWEBUIFW) {
                            this.copyTizenWebUIFWLibrary(group);
                            continue;
                        }
                        this.copyNormalLibrary(group);
                    }
                }
            }
        }
        return 0;
    }

    private void copyTizenWebUIFWLibrary(TizenTemplateLibraryGroup group) {
        String libraryPath = group.getSelectedLibraryPath();
        if (libraryPath == null) {
            return;
        }
        File source = new File(libraryPath);
        if (!source.exists()) {
            this.log.error("Cannot find template library resource : {}", (Object)libraryPath);
        }
        LibraryCopyOperation.TizenWebUIFWType type = null;
        String elementKey = group.getSelectedElementKey();
        try {
            type = LibraryCopyOperation.TizenWebUIFWType.valueOf((String)elementKey);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        URI destinationURI = null;
        switch (type) {
            case TizenWebUIFramework_Theme: 
            case TizenWebUIFramework_Theme_Images: {
                String[] themePaths = libraryPath.split("Theme/");
                break;
            }
        }
        if (type != LibraryCopyOperation.TizenWebUIFWType.TizenWebUIFramework_Theme) {
            destinationURI = URI.create(destinationURI + group.getSelectedElementValue());
        }
        if (destinationURI == null) {
            return;
        }
        if (source.isDirectory()) {
            if (!FileUtil.isExist((String)destinationURI.getPath())) {
                FileUtil.createDirectory((File)new File(destinationURI));
            }
        } else {
            File parentFile = new File(destinationURI).getParentFile();
            if (parentFile != null && !FileUtil.isExist((String)parentFile.getPath())) {
                FileUtil.createDirectory((File)parentFile);
            }
        }
    }

    private void copyNormalLibrary(TizenTemplateLibraryGroup group) {
        String destDir;
        String libraryPath = group.getSelectedLibraryPath();
        if (libraryPath == null) {
            return;
        }
        File source = new File(libraryPath);
        if (!source.exists() || !source.isDirectory()) {
            this.log.error("Cannot find template library resource folder: {}", (Object)libraryPath);
        }
        TizenTemplateKindsOfLibraries kindOfLibrary = group.getSelectedElement().getKindsOfLibrary();
        switch (kindOfLibrary) {
            case JAVASCRIPT: {
                destDir = this.data.getOutputName() + File.separator + "js";
                break;
            }
            case CSS: {
                destDir = this.data.getOutputName() + File.separator + "css";
                break;
            }
            default: {
                destDir = this.data.getOutputName();
            }
        }
        try {
            FileUtil.copyRecursively((String)libraryPath, (String)destDir, (boolean)true);
        }
        catch (IOException e) {
            this.log.error(TizenCLIMessages.CR_CANNOT_COPY_PROJECT);
        }
    }

    private int processOption() {
        this.cfg = FreeMarkerUtil.getDefaultConfiguration();
        String projectDestDir = this.data.getOutputName();
        File projectDir = new File(projectDestDir);
        try {
            this.cfg.setDirectoryForTemplateLoading(projectDir);
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            return -1;
        }
        if (this.tizenAppTemplate == null) {
            return -1;
        }
        Options options = this.tizenAppTemplate.getOptions();
        if (options != null) {
            SupportLibraries supportLibraries = options.getSupportLibraries();
            if (supportLibraries != null) {
                this.buildModelForSupportLibraries(supportLibraries);
            }
            for (OptionGroup optionGroup : options.getOptionGroup()) {
                this.buildModelForOptionGroup(optionGroup, optionGroup.getKey());
            }
        }
        this.buildModelForConfigFile();
        this.generateFilefromProjectRoot(projectDir, projectDir);
        return 0;
    }

    private void generateFilefromProjectRoot(File projectRootFile, File rootDir) {
        File[] fileList;
        if (projectRootFile != null && projectRootFile.isDirectory() && (fileList = projectRootFile.listFiles()) != null && fileList.length != 0) {
            for (File file : fileList) {
                String sdkPath;
                File xslFile;
                if (file.isDirectory()) {
                    this.generateFilefromProjectRoot(file, rootDir);
                } else if (this.isAvailableTemplate(file.getName())) {
                    this.generateFileFromTemplate(file, rootDir);
                }
                if (!this.isAvailableRegenTemplate(file.getName()) || !(xslFile = new File(sdkPath = InstallPathConfig.getSDKPath(), "tools/ide/resources/web/conf/web-manifest.xsl")).exists()) continue;
                this.generateFileFromRegenTemplate(file, xslFile);
            }
        }
    }

    private boolean isAvailableTemplate(String fileName) {
        String[] availableExtension = new String[]{".html"};
        String[] availableList = new String[]{"app.xml", "config.xml"};
        for (String res : availableExtension) {
            if (fileName.indexOf(res) == -1) continue;
            return true;
        }
        for (String res : availableList) {
            if (fileName.indexOf(res) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean isAvailableRegenTemplate(String fileName) {
        String[] availableList;
        for (String res : availableList = new String[]{"config.xml"}) {
            if (fileName.indexOf(res) == -1) continue;
            return true;
        }
        return false;
    }

    private void buildModelForSupportLibraries(SupportLibraries supportLibraries) {
        if (this.libraryPool != null) {
            List groupList = this.libraryPool.getLibraryGroupWithDepends(supportLibraries);
            for (TizenTemplateLibraryGroup group : groupList) {
                String key = group.getKey();
                LibraryElement selectedElement = group.getSelectedElement();
                String value = group.isSelectedMinified() ? selectedElement.getMinifiedValue() : selectedElement.getOriginalValue();
                if (value == null) continue;
                this.root.put(key, value);
            }
        }
    }

    private void buildModelForOptionGroup(OptionGroup optionGroup, String key) {
        for (OptionElement optionElement : optionGroup.getOptionElement()) {
            boolean isDefault = optionElement.isDefaultElement() != null ? optionElement.isDefaultElement() : false;
            String addedKey = key + optionGroupSeparator + optionElement.getKey();
            String value = optionElement.getValue();
            switch (optionGroup.getOptionType()) {
                case MANDATORY: {
                    this.root.put(addedKey, value);
                    break;
                }
                case MULTI_SELECTION: {
                    this.root.put(addedKey, isDefault ? value : "");
                    break;
                }
                case SINGLE_SELECTION: {
                    if (!isDefault) break;
                    this.root.put(key, value);
                    break;
                }
            }
        }
        for (OptionGroup innerOptionGroup : optionGroup.getOptionGroup()) {
            String addedKey = key + optionGroupSeparator + innerOptionGroup.getKey();
            this.buildModelForOptionGroup(innerOptionGroup, addedKey);
        }
    }

    private void buildModelForConfigFile() {
        this.root.put("PACKAGE_ID", this.data.getAppID());
        this.root.put("PROJECT_NAME", this.data.getProjectName());
        this.root.put("PROFILE_NAME", this.data.getBaseProfileName());
        this.root.put("PROFILE_VER", this.data.getBaseProfileVer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFileFromTemplate(File srcFile, File rootDir) {
        String originalFilePath = srcFile.getAbsolutePath();
        String templateFilePath = originalFilePath + temporaryFileAdditionalName;
        File templateFile = new File(templateFilePath);
        srcFile.renameTo(templateFile);
        try {
            String relPath = rootDir.toURI().relativize(templateFile.toURI()).getPath();
            FreeMarkerUtil.generateDocument(this.root, (Configuration)this.cfg, (String)relPath, (String)originalFilePath);
        }
        catch (IOException e) {
            this.log.error("not found file\n{}", (Object)e.getMessage());
        }
        catch (TemplateException e) {
            this.log.error("Fail to generate HTML files.\n{}", (Object)e.getMessage());
        }
        finally {
            templateFile.delete();
        }
    }

    private void generateFileFromRegenTemplate(File srcFile, File xslFile) {
        String originalFilePath = srcFile.getAbsolutePath();
        String templateFilePath = originalFilePath + temporaryFileAdditionalName;
        File templateFile = new File(templateFilePath);
        srcFile.renameTo(templateFile);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transFactory.newTransformer(new StreamSource(xslFile));
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
            return;
        }
        trans.setOutputProperty("indent", "yes");
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
            return;
        }
        Document doc = docBuilder.newDocument();
        Element rootElem = doc.createElement("root");
        doc.appendChild(rootElem);
        Element dataElem = doc.createElement("data");
        rootElem.appendChild(dataElem);
        Set<String> keySet = this.root.keySet();
        for (String key : keySet) {
            Element macro = doc.createElement("macro");
            macro.setAttribute("name", key);
            macro.setAttribute("value", this.root.get(key).toString());
            dataElem.appendChild(macro);
        }
        Element manifestElem = doc.createElement("manifest");
        rootElem.appendChild(manifestElem);
        Document doc2 = XMLUtil.readXML((File)templateFile, (boolean)true);
        if (doc2 == null) {
            this.log.warn("Cannot read the " + templateFile + " file.");
            return;
        }
        manifestElem.appendChild(doc.adoptNode(doc2.getDocumentElement()));
        DOMSource src = new DOMSource(doc);
        StreamResult result = new StreamResult(originalFilePath);
        try {
            trans.transform(src, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        templateFile.delete();
    }

    private int makeTizenDescription() {
        ObjectFactory objFactory = new ObjectFactory();
        Tproject tProject = objFactory.createTproject();
        Platform platform = objFactory.createPlatform();
        Platforms platforms = objFactory.createPlatforms();
        platform.setName(this.data.getProfileName());
        platforms.getPlatform().add(platform);
        tProject.setPlatforms(platforms);
        File file = new File(this.data.getDestTizenProjectDescriptionFile());
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)tProject, file);
        }
        catch (JAXBException e) {
            this.log.error("cannot marshal \n{}", (Object)e.getMessage());
            return -1;
        }
        return 0;
    }
}

